/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LikeTest
extends BaseJDBCTestCase {
    public LikeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(LikeTest.class);
    }

    public void testOptimizeConcatenatedStringLiterals() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t (x varchar(128) primary key, y int)");
        s.execute("insert into t(x) values 'abc', 'def', 'ghi', 'ab', 'de', 'gh'");
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        String[][] expectedRows = new String[][]{{"ab", null}, {"abc", null}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t where x like 'ab%'"), expectedRows);
        LikeTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(s).usedIndexScan());
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t where x like 'a'||'b'||'%'"), expectedRows);
        LikeTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(s).usedIndexScan());
    }

    public void testDerby6477() throws SQLException {
        JDBC.assertSingleValueResultSet(this.createStatement().executeQuery("select javaclassname from sys.sysaliases where javaclassname like 'org.apache.derby.catalog.Java5SystemProcedures%'"), "org.apache.derby.catalog.Java5SystemProcedures");
    }
}

