/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.derbyTesting.functionTests.tests.memorydb.ClusMog;
import org.apache.derbyTesting.junit.BaseTestCase;

public class ClusMogSQL
extends ClusMog {
    Connection conn;
    int uniq = 0;

    public ClusMogSQL(Connection conn) {
        this.conn = conn;
    }

    public void setUnique(int uniq) {
        this.uniq = uniq & Integer.MAX_VALUE;
    }

    public void clusterSQL(int n, double[] center, int ns, double[] sample) throws SQLException {
        this.setCenters(n, center);
        this.setSamples(ns, sample);
        this.init();
        double thresh = 1.0E-6;
        double oldmsr = Double.MAX_VALUE;
        int it = 1;
        while (true) {
            double msr = this.expect();
            this.maximize();
            double dif = Math.abs(msr - oldmsr);
            double err = dif / (1.0 + oldmsr);
            oldmsr = msr;
            if (err < 1.0E-6) break;
            ++it;
        }
        this.download();
        this.cleanup();
        this.printMog("SQL-COMPUTED", n, this.weight, this.mean, this.var);
        BaseTestCase.println("msr = (" + oldmsr + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws SQLException {
        Arrays.sort(this.sample, 0, this.ns);
        Arrays.sort(this.mean, 0, this.n);
        String clusterN = "cluster" + this.uniq;
        String sampleN = "sample" + this.uniq;
        Statement pstmt = null;
        Statement stmt = this.conn.createStatement();
        try {
            double x;
            int i;
            stmt.executeUpdate("CREATE TABLE " + clusterN + "(weight double, mean double, var double, bucket int PRIMARY KEY)");
            stmt.executeUpdate("CREATE TABLE " + sampleN + "(value double, id int PRIMARY KEY, bucket int)");
            pstmt = this.conn.prepareStatement("INSERT INTO " + sampleN + "(value, id) VALUES (?, ?)");
            for (i = 0; i < this.ns; ++i) {
                x = this.sample[i];
                pstmt.setDouble(1, x);
                pstmt.setInt(2, i);
                pstmt.executeUpdate();
            }
            pstmt.close();
            pstmt = this.conn.prepareStatement("INSERT INTO " + clusterN + "(mean, bucket) VALUES (?, ?)");
            for (i = 0; i < this.n; ++i) {
                x = this.mean[i];
                pstmt.setDouble(1, x);
                pstmt.setInt(2, i);
                pstmt.executeUpdate();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        this.maximize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double expect() throws SQLException {
        String clusterN = "cluster" + this.uniq;
        String sampleN = "sample" + this.uniq;
        String mm = "mm" + this.uniq;
        String vv = "vv" + this.uniq;
        String ee = "ee" + this.uniq;
        double msr = Double.MAX_VALUE;
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = this.conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + mm + "(bucket int PRIMARY KEY, mean double)");
            stmt.executeUpdate("CREATE TABLE " + vv + "(bucket int PRIMARY KEY, var double)");
            stmt.executeUpdate("CREATE TABLE " + ee + "(bucket int PRIMARY KEY, err double, size int)");
            stmt.executeUpdate("INSERT INTO " + mm + "(bucket, mean) \nSELECT bucket, avg(value) \n  FROM " + sampleN + " \n GROUP BY bucket \n");
            stmt.executeUpdate("INSERT INTO " + ee + "(bucket, err, size) \nSELECT S.bucket, sum((S.value - M.mean) * (S.value - M.mean)), count(*) \n  FROM " + sampleN + " S JOIN " + mm + " M ON S.bucket = M.bucket \n GROUP BY S.bucket \n");
            stmt.executeUpdate("INSERT INTO " + vv + "(bucket, var) \nSELECT bucket, \n       CASE WHEN (size > 1) THEN (err / (size - 1)) ELSE 0.0 END \n  FROM " + ee + " \n");
            stmt.executeUpdate("DELETE FROM " + clusterN);
            stmt.executeUpdate("INSERT INTO " + clusterN + "(mean, var, bucket) \nSELECT M.mean, V.var, V.bucket \n  FROM " + mm + " M JOIN " + vv + " V ON M.bucket = V.bucket \n");
            rset = stmt.executeQuery("SELECT (sum(err) / sum(size)) AS measure FROM " + ee);
            while (rset.next()) {
                msr = rset.getDouble(1);
            }
            stmt.executeUpdate("DROP TABLE " + mm);
            stmt.executeUpdate("DROP TABLE " + vv);
            stmt.executeUpdate("DROP TABLE " + ee);
        }
        finally {
            if (rset != null) {
                rset.close();
                rset = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        return msr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maximize() throws SQLException {
        String clusterN = "cluster" + this.uniq;
        String sampleN = "sample" + this.uniq;
        String gg = "gg" + this.uniq;
        String jj = "jj" + this.uniq;
        try (Statement stmt = null;){
            stmt = this.conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + gg + "(id int PRIMARY KEY, diff double)");
            stmt.executeUpdate("CREATE TABLE " + jj + "(value double, id int, diff double, bucket int)");
            stmt.executeUpdate("INSERT INTO " + gg + "(id, diff) \nSELECT S.id, min(abs(S.value - C.mean)) \n  FROM " + sampleN + " S, " + clusterN + " C \n GROUP BY S.id \n");
            stmt.executeUpdate("INSERT INTO " + jj + "(value, id, diff, bucket) \nSELECT S.value, S.id, abs(S.value - C.mean), C.bucket \n  FROM " + sampleN + " S, " + clusterN + " C \n");
            stmt.executeUpdate("DELETE FROM " + sampleN);
            stmt.executeUpdate("INSERT INTO " + sampleN + "(value, id, bucket) \nSELECT J.value, J.id, min(J.bucket) \n  FROM " + jj + " J \n  JOIN " + gg + " G \n    ON J.id   = G.id \n   AND J.diff = G.diff \n GROUP BY J.id, J.value \n");
            stmt.executeUpdate("DROP TABLE " + gg);
            stmt.executeUpdate("DROP TABLE " + jj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void download() throws SQLException {
        String clusterN = "cluster" + this.uniq;
        String sampleN = "sample" + this.uniq;
        String ww = "ww" + this.uniq;
        String cc = "cc" + this.uniq;
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = this.conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + ww + "(bucket int PRIMARY KEY, size int)");
            stmt.executeUpdate("CREATE TABLE " + cc + "(weight double, mean double, var double, bucket int PRIMARY KEY)");
            stmt.executeUpdate("INSERT INTO " + ww + "(bucket, size) \nSELECT bucket, count(*) \n  FROM " + sampleN + " \n GROUP BY bucket \n");
            stmt.executeUpdate("INSERT INTO " + cc + "(weight, mean, var, bucket) \nSELECT (CAST(W.size AS double) / (SELECT sum(size) FROM " + ww + ")), C.mean, C.var, C.bucket \n  FROM " + clusterN + " C JOIN " + ww + " W ON C.bucket = W.bucket \n");
            stmt.executeUpdate("DELETE FROM " + clusterN);
            stmt.executeUpdate("INSERT INTO " + clusterN + "(weight, mean, var, bucket) \nSELECT weight, mean, var, bucket FROM " + cc + " \n");
            stmt.executeUpdate("DROP TABLE " + ww);
            stmt.executeUpdate("DROP TABLE " + cc);
            rset = stmt.executeQuery("SELECT weight, mean, var FROM " + clusterN + " ORDER BY mean");
            this.n = 0;
            while (rset.next()) {
                double w = rset.getDouble(1);
                double m = rset.getDouble(2);
                double v = rset.getDouble(3);
                this.weight[this.n] = w;
                this.mean[this.n] = m;
                this.var[this.n] = v;
                ++this.n;
            }
        }
        finally {
            if (rset != null) {
                rset.close();
                rset = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() throws SQLException {
        String clusterN = "cluster" + this.uniq;
        String sampleN = "sample" + this.uniq;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.executeUpdate("DROP TABLE " + sampleN);
            stmt.executeUpdate("DROP TABLE " + clusterN);
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }
}

