/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RenameTableTest
extends BaseJDBCTestCase {
    private static final String PRIMARY_VIOLATION = "23505";
    private static final String FOREIGN_VIOLATION = "23503";
    private static final String DEFERRED_PRIMARY_VIOLATION = "23506";
    private static final String DEFERRED_FOREIGN_VIOLATION = "23516";
    private static final String USER_ERROR = "38000";

    public RenameTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(RenameTableTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRenameNonExistingTable() throws SQLException {
        Statement s = this.createStatement();
        RenameTableTest.assertStatementError("42Y55", s, "rename table notexists to notexists1");
    }

    public void testExistedNameForRenameTable() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int not null primary key)");
        s.executeUpdate("create table t2(c21 int not null primary key)");
        RenameTableTest.assertStatementError("X0Y32", s, "rename table t1 to t2");
        s.executeUpdate("drop table t1");
        s.executeUpdate("drop table t2");
    }

    public void testRenameSystemTable() throws SQLException {
        Statement s = this.createStatement();
        RenameTableTest.assertStatementError("42X62", s, "rename table sys.systables to fake");
    }

    public void testRenameTableWithViews() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int not null primary key)");
        s.executeUpdate("insert into t1 values 11");
        s.executeUpdate("create view v1 as select * from t1");
        RenameTableTest.assertStatementError("42Y62", s, "rename table v1 to fake");
        RenameTableTest.assertStatementError("X0Y23", s, "rename table t1 to fake");
        s.executeUpdate("drop view v1");
        s.executeUpdate("drop table t1");
    }

    public void testRenameWithIndex() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t3(c31 int not null)");
        s.executeUpdate("create index i1_t3 on t3(c31)");
        RenameTableTest.assertUpdateCount(s, 0, "rename table t3 to t3r");
        s.executeUpdate("drop table t3r");
    }

    public void testRenameWithPreparedStatement() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t3(c31 int not null primary key)");
        s.executeUpdate("insert into t3 values 31");
        s.executeUpdate("insert into t3 values 32");
        s.executeUpdate("insert into t3 values 33");
        PreparedStatement pstmt = this.prepareStatement("select * from t3 where c31 > ?");
        pstmt.setInt(1, 30);
        ResultSet rs = pstmt.executeQuery();
        rs.next();
        rs.close();
        RenameTableTest.assertUpdateCount(s, 0, "rename table t3 to t3r");
        pstmt.setInt(1, 30);
        try {
            ResultSet rs1 = pstmt.executeQuery();
            RenameTableTest.fail((String)"Table/View t3 Doesn't exists:");
        }
        catch (SQLException e) {
            RenameTableTest.assertSQLState("42X05", e);
        }
        s.executeUpdate("drop table t3r");
    }

    public void testRenameTableWithTriggersOnIt() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t6 (c61 int default 1)");
        s.executeUpdate("create table t7(c71 int)");
        s.executeUpdate("create trigger t7insert after insert on t7 referencing new as NEWROW for each row insert into t6 values(NEWROW.c71)");
        s.executeUpdate("insert into t7 values(1)");
        RenameTableTest.assertStatementError("X0Y25", s, "rename table t7 to t7r");
        RenameTableTest.assertStatementError("42X05", s, "select * from t7r");
        ResultSet rs = s.executeQuery("select * from t7");
        rs.next();
        rs.close();
        RenameTableTest.assertStatementError("X0Y25", s, "rename table t6 to t6r");
        s.execute("insert into t7 values(3)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t6 order by c61"), new String[][]{{"1"}, {"3"}});
        RenameTableTest.assertStatementError("42X05", s, "select * from t7r");
        s.executeUpdate("drop table t7");
        s.executeUpdate("drop table t6");
    }

    public void testRenameWithCheckConstraintsOnIt() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table tcheck (i int check(i>5))");
        RenameTableTest.assertStatementError("X0Y25", s, "rename table tcheck to tcheck1");
        s.executeUpdate("drop table tcheck");
        s.executeUpdate("create table tcheck (i int, j int, constraint tcon check (i+j>2))");
        RenameTableTest.assertStatementError("X0Y25", s, "rename table tcheck to tcheck1");
        s.executeUpdate("alter table tcheck drop constraint tcon");
        s.executeUpdate("rename table tcheck to tcheck1");
        s.executeUpdate("drop table tcheck1");
    }

    public void testRenameInvalidation_derby_4479() throws SQLException {
        this.getConnection().setAutoCommit(true);
        Statement s = this.createStatement();
        s.executeUpdate("create table a (x int not null primary key)");
        s.executeUpdate("rename table a to b");
        s.executeUpdate("create table a (x int not null primary key)");
        s.executeUpdate("drop table a");
        s.executeUpdate("drop table b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_6672_1() throws Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        this.goodStatement(conn, "create procedure runStatementAndRaiseError( text varchar( 128 ) )\nlanguage java parameter style java modifies sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RenameTableTest.runStatementAndRaiseError'\n");
        this.goodStatement(conn, "create table primary1( a int primary key )");
        this.goodStatement(conn, "create table foreign1( a int references primary1( a ) )");
        this.goodStatement(conn, "rename table primary1 to primary2");
        this.goodStatement(conn, "rename table foreign1 to foreign2");
        this.goodStatement(conn, "rename column primary2.a to b");
        this.goodStatement(conn, "rename column foreign2.a to b");
        this.goodStatement(conn, "insert into primary2 values 1");
        RenameTableTest.assertPreparedStatementError(PRIMARY_VIOLATION, conn.prepareStatement("insert into primary2 values 1"));
        this.goodStatement(conn, "insert into foreign2 values 1");
        RenameTableTest.assertPreparedStatementError(FOREIGN_VIOLATION, conn.prepareStatement("insert into foreign2 values 2"));
        this.goodStatement(conn, "create table primary10( a int primary key initially deferred )");
        this.goodStatement(conn, "create table foreign10( a int references primary10( a ) initially deferred )");
        conn.setAutoCommit(false);
        try {
            this.goodStatement(conn, "insert into primary10 values 1");
            this.goodStatement(conn, "rename table primary10 to primary20");
            this.goodStatement(conn, "insert into primary20 values 1");
            try {
                conn.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException se) {
                RenameTableTest.assertEquals((String)DEFERRED_PRIMARY_VIOLATION, (String)se.getSQLState());
            }
            this.goodStatement(conn, "insert into primary10 values 1");
            this.goodStatement(conn, "rename table primary10 to primary20");
            this.goodStatement(conn, "rename table foreign10 to foreign20");
            this.goodStatement(conn, "insert into foreign20 values 2");
            try {
                conn.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException se) {
                RenameTableTest.assertEquals((String)DEFERRED_FOREIGN_VIOLATION, (String)se.getSQLState());
            }
        }
        finally {
            conn.setAutoCommit(true);
        }
        this.goodStatement(conn, "create table primary100( a int primary key initially deferred )");
        this.goodStatement(conn, "create table foreign100( a int references primary100( a ) initially deferred )");
        conn.setAutoCommit(false);
        try {
            this.goodStatement(conn, "insert into primary100 values 1, 1");
            try {
                conn.prepareStatement("call runStatementAndRaiseError( 'rename table primary100 to primary200' )").execute();
                RenameTableTest.fail((String)"Statement should have failed!");
            }
            catch (SQLException se) {
                RenameTableTest.assertEquals((String)USER_ERROR, (String)se.getSQLState());
            }
            try {
                conn.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException se) {
                RenameTableTest.assertEquals((String)DEFERRED_PRIMARY_VIOLATION, (String)se.getSQLState());
            }
            this.goodStatement(conn, "insert into primary100 values 1");
            this.goodStatement(conn, "rename table primary100 to primary200");
            this.goodStatement(conn, "insert into foreign100 values 2");
            try {
                conn.prepareStatement("call runStatementAndRaiseError( 'rename table foreign100 to foreign200' )").execute();
                RenameTableTest.fail((String)"Statement should have failed!");
            }
            catch (SQLException se) {
                RenameTableTest.assertEquals((String)USER_ERROR, (String)se.getSQLState());
            }
            try {
                conn.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException se) {
                RenameTableTest.assertEquals((String)DEFERRED_FOREIGN_VIOLATION, (String)se.getSQLState());
            }
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    public static void runStatementAndRaiseError(String text) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.prepareStatement(text).execute();
        throw new SQLException("Oh sorry, an error occurred.");
    }
}

