/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollationElementsInterface;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.shared.common.sanity.SanityManager;

final class WorkHorseForCollatorDatatypes {
    private RuleBasedCollator collatorForCharacterDatatypes;
    private SQLChar stringData;

    WorkHorseForCollatorDatatypes(RuleBasedCollator collatorForCharacterDatatypes, SQLChar stringData) {
        this.collatorForCharacterDatatypes = collatorForCharacterDatatypes;
        this.stringData = stringData;
    }

    int stringCompare(SQLChar str1, SQLChar str2) throws StandardException {
        CollationKey ckey1 = str1.getCollationKey();
        CollationKey ckey2 = str2.getCollationKey();
        if (ckey1 == null || ckey2 == null) {
            if (ckey1 != null) {
                return -1;
            }
            if (ckey2 != null) {
                return 1;
            }
            return 0;
        }
        return ckey1.compareTo(ckey2);
    }

    BooleanDataValue like(DataValueDescriptor pattern) throws StandardException {
        SanityManager.ASSERT(pattern instanceof CollationElementsInterface, "Both the operands must be instances of CollationElementsInterface");
        Boolean likeResult = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)pattern).getCharArray(), pattern.getLength(), null, 0, this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, pattern, likeResult);
    }

    BooleanDataValue like(DataValueDescriptor pattern, DataValueDescriptor escape) throws StandardException {
        SanityManager.ASSERT(pattern instanceof CollationElementsInterface && escape instanceof CollationElementsInterface, "All three operands must be instances of CollationElementsInterface");
        if (escape.isNull()) {
            throw StandardException.newException("22501", new Object[0]);
        }
        CollationElementsInterface escapeCharacter = (CollationElementsInterface)((Object)escape);
        if (escape.getLength() != 1 || !escapeCharacter.hasSingleCollationElement()) {
            throw StandardException.newException("22019", escapeCharacter.toString());
        }
        Boolean likeResult = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)pattern).getCharArray(), pattern.getLength(), ((SQLChar)escape).getCharArray(), escape.getLength(), this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, pattern, likeResult);
    }

    RuleBasedCollator getCollatorForCollation() {
        return this.collatorForCharacterDatatypes;
    }

    boolean hasSingleCollationElement() throws StandardException {
        if (this.stringData.isNull()) {
            return false;
        }
        CollationElementIterator cei = this.collatorForCharacterDatatypes.getCollationElementIterator(this.stringData.getString());
        return cei.next() != -1 && cei.next() == -1;
    }
}

