/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Sequence {
    public static void doSequences(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("SELECT SCHEMAID, SEQUENCENAME, SEQUENCEDATATYPE, STARTVALUE, MINIMUMVALUE, MAXIMUMVALUE, INCREMENT, CYCLEOPTION\nFROM SYS.SYSSEQUENCES\nWHERE CAST( SCHEMAID AS CHAR( 36) ) != '8000000d-00d0-fd77-3ed8-000a0a0b1900'");
        ResultSet rs = ps.executeQuery();
        boolean firstTime = true;
        while (rs.next()) {
            String cycleOption;
            int col = 1;
            String schemaName = dblook.lookupSchemaId(rs.getString(col++));
            String sequenceName = rs.getString(col++);
            String typeName = DB_Sequence.stripNotNull(rs.getString(col++));
            long startValue = rs.getLong(col++);
            long minimumValue = rs.getLong(col++);
            long maximumValue = rs.getLong(col++);
            long increment = rs.getLong(col++);
            String string = cycleOption = "Y".equals(rs.getString(col++)) ? "CYCLE" : "NO CYCLE";
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SequenceHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String fullName = dblook.addQuotes(dblook.expandDoubleQuotes(sequenceName));
            fullName = schemaName + "." + fullName;
            String creationString = DB_Sequence.createSequenceString(fullName, typeName, startValue, minimumValue, maximumValue, increment, cycleOption);
            Logs.writeToNewDDL(creationString);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        ps.close();
    }

    private static String stripNotNull(String datatypeName) {
        int idx = datatypeName.indexOf("NOT");
        if (idx > 0) {
            return datatypeName.substring(0, idx);
        }
        return datatypeName;
    }

    private static String createSequenceString(String fullName, String dataTypeName, long startValue, long minimumValue, long maximumValue, long increment, String cycleOption) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE SEQUENCE " + fullName + '\n');
        buffer.append("    AS " + dataTypeName + '\n');
        buffer.append("    START WITH " + Long.toString(startValue) + '\n');
        buffer.append("    INCREMENT BY " + Long.toString(increment) + '\n');
        buffer.append("    MAXVALUE " + Long.toString(maximumValue) + '\n');
        buffer.append("    MINVALUE " + Long.toString(minimumValue) + '\n');
        buffer.append("    " + cycleOption + '\n');
        return buffer.toString();
    }
}

