/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ClasspathSetup;
import org.apache.derbyTesting.junit.DatabaseChangeSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;

public class NativeAuthenticationServiceTest
extends GeneratedColumnsHelper {
    private static final int FILE = 0;
    private static final int JAR = 1;
    private static final int CLASSPATH = 2;
    private static final int NONE = 3;
    private static final int JAR_ENCRYPTED = 4;
    private static final boolean NATIVE = true;
    private static final boolean NO_AUTH = false;
    private static final boolean LOCAL = true;
    private static final boolean SYSTEM_WIDE = false;
    private static final boolean DISABLE_AUTHORIZATION = true;
    private static final boolean DONT_DISABLE_AUTH = false;
    private static final String DBO = "KIWI";
    private static final String APPLE_USER = "APPLE";
    private static final String PEAR_USER = "PEAR";
    private static final String PRICKLY_PEAR_USER = "PeAr";
    private static final String ORANGE_USER = "ORANGE";
    private static final String BANANA_USER = "BANANA";
    private static final String GRAPE_USER = "GRAPE";
    private static final String PINEAPPLE_USER = "PINEAPPLE";
    private static final String CAMEL_CASE_DBO = "kIwI";
    private static final String WALNUT_USER = "WALNUT";
    private static final String BUILTIN_USER = "PECAN";
    private static final String CREDENTIALS_DB = "credDB";
    private static final String SECOND_DB = "secondDB";
    private static final String THIRD_DB = "thirdDB";
    private static final String FOURTH_DB = "fourthDB";
    private static final String FIFTH_DB = "fifthDB";
    private static final String SIXTH_DB = "sixthDB";
    private static final String SEVENTH_DB = "seventhDB";
    private static final String EIGHTH_DB = "eighthDB";
    private static final String NINTH_DB = "ninthDB";
    private static final String TENTH_DB = "tenthDB";
    private static final String ELEVENTH_DB = "eleventhDB";
    private static final String TWELTH_DB = "twelthDB";
    private static final String THIRTEENTH_DB = "thirteenthDB";
    private static final String FOURTEENTH_DB = "fourteenthDB";
    private static final String FIFTEENTH_DB = "fifteenthDB";
    private static final String NAST1_JAR_FILE = "nast1.jar";
    private static final String NAST2_JAR_FILE = "nast2.jar";
    private static final String[] SUPPORT_FILES_SOURCE = new String[]{"functionTests/tests/lang/nast1.jar", "functionTests/tests/lang/nast1.jar"};
    private static final String[] SUPPORT_FILES_TARGET = new String[]{"nast1.jar", "nast2.jar"};
    private static final String PROVIDER_PROPERTY = "derby.authentication.provider";
    private static final String REQUIRE_AUTHENTICATION_PROPERTY = "derby.connection.requireAuthentication";
    private static final String SQL_AUTHORIZATION_PROPERTY = "derby.database.sqlAuthorization";
    private static final String UPGRADE_TO_BETA_PROPERTY = "derby.database.allowPreReleaseUpgrade";
    private static final String CREDENTIALS_DB_DOES_NOT_EXIST = "4251I";
    private static final String BAD_NETWORK_AUTHENTICATION = "08001";
    private static final String INVALID_AUTHENTICATION = "08004";
    private static final String DBO_ONLY_OPERATION = "4251D";
    private static final String INVALID_PROVIDER_CHANGE = "XCY05";
    private static final String CANT_DROP_DBO = "4251F";
    private static final String NO_COLUMN_PERMISSION = "42502";
    private static final String NO_EXECUTE_PERMISSION = "42504";
    private static final String PASSWORD_EXPIRING = "01J15";
    private static final String DBO_PASSWORD_EXPIRING = "01J16";
    private static final String BAD_PASSWORD_PROPERTY = "4251J";
    private static final String BAD_PROPERTY_CHANGE = "XCY02";
    private static final String SQL_AUTHORIZATION_NOT_ON = "42Z60";
    private static final String CANT_BOOT_DATABASE = "XJ040";
    private static final String MISSING_USER = "XK001";
    private static final String BAD_USER_AUTHENTICATOR_CLASS = "XBM0M";
    private static final String USER_ALREADY_EXISTS = "X0Y68";
    private static final String WEAK_AUTHENTICATION = "4251G";
    private static final String HASHING_FORMAT_10_9 = "3b62";
    private static final int HEX_CHARS_PER_BYTE = 2;
    private final int _credentialsDBLocation;
    private final boolean _nativeAuthentication;
    private final boolean _localAuthentication;
    private final boolean _turnOffAuthenticationAndAuthorization;
    private String _credentialsDBPhysicalName;
    private DatabaseChangeSetup _fourthDBSetup;
    private DatabaseChangeSetup _fifthDBSetup;
    private DatabaseChangeSetup _sixthDBSetup;
    private DatabaseChangeSetup _seventhDBSetup;
    private DatabaseChangeSetup _eighthDBSetup;
    private DatabaseChangeSetup _ninthDBSetup;
    private DatabaseChangeSetup _fifteenthDBSetup;
    private String _derbySystemHome;
    private String _fullBackupDir;

    public NativeAuthenticationServiceTest(int credentialsDBLocation, boolean nativeAuthentication, boolean localAuthentication, boolean turnOffAuthenticationAndAuthorization) {
        super("testAll");
        this._credentialsDBLocation = credentialsDBLocation;
        this._nativeAuthentication = nativeAuthentication;
        this._localAuthentication = localAuthentication;
        this._turnOffAuthenticationAndAuthorization = turnOffAuthenticationAndAuthorization;
    }

    public void setUp() throws Exception {
        super.setUp();
        this._derbySystemHome = NativeAuthenticationServiceTest.getSystemProperty("derby.system.home");
        this._fullBackupDir = this._derbySystemHome + "/backupDir";
    }

    private Properties systemProperties(String physicalDatabaseName) throws Exception {
        String authenticationProvider;
        Properties result = new Properties();
        switch (this._credentialsDBLocation) {
            case 1: 
            case 4: {
                this._credentialsDBPhysicalName = NativeAuthenticationServiceTest.jarDBName(this._credentialsDBLocation);
                break;
            }
            case 2: {
                this._credentialsDBPhysicalName = NativeAuthenticationServiceTest.classpathDBName();
                break;
            }
            case 0: 
            case 3: {
                this._credentialsDBPhysicalName = physicalDatabaseName;
                break;
            }
            default: {
                throw new Exception("Unknown location of credentials db: " + this._credentialsDBLocation);
            }
        }
        if (!this._nativeAuthentication) {
            authenticationProvider = "NONE";
        } else {
            authenticationProvider = "NATIVE:" + this._credentialsDBPhysicalName;
            if (this._localAuthentication) {
                authenticationProvider = authenticationProvider + ":LOCAL";
            }
        }
        result.put(UPGRADE_TO_BETA_PROPERTY, "true");
        result.put(PROVIDER_PROPERTY, authenticationProvider);
        if (this._turnOffAuthenticationAndAuthorization) {
            result.put(REQUIRE_AUTHENTICATION_PROPERTY, "false");
            result.put(SQL_AUTHORIZATION_PROPERTY, "false");
        }
        return result;
    }

    private boolean credentialsViaSubprotocol() {
        switch (this._credentialsDBLocation) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private String nameOfTest() {
        String dbLocation = "";
        switch (this._credentialsDBLocation) {
            case 1: {
                dbLocation = "JAR, ";
                break;
            }
            case 4: {
                dbLocation = "JAR_ENCRYPTED, ";
                break;
            }
            case 2: {
                dbLocation = "CLASSPATH, ";
                break;
            }
            case 0: 
            case 3: {
                dbLocation = "FILE, ";
                break;
            }
            default: {
                dbLocation = "UNKNOWN, ";
            }
        }
        String authType = this._nativeAuthentication ? "NATIVE authentication on, " : "Authentication off, ";
        String local = this._localAuthentication ? "LOCAL authentication ON, " : "LOCAL authentication OFF, ";
        String authOverrides = this._turnOffAuthenticationAndAuthorization ? "Authentication/Authorization turned OFF, " : "Authentication/Authorization DEFAULT, ";
        String embedded = this.isEmbedded() ? "Embedded" : "Client/Server";
        return "[ " + dbLocation + authType + local + authOverrides + embedded + " ]";
    }

    public boolean isEmbedded() {
        return this.getTestConfiguration().getJDBCClient().isEmbedded();
    }

    public static Test suite() throws Exception {
        BaseTestSuite suite = new BaseTestSuite();
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            suite.addTest(new NativeAuthenticationServiceTest(4, true, true, false).decorate(false));
        }
        suite.addTest(NativeAuthenticationServiceTest.allConfigurations(false));
        if (!JDBC.vmSupportsJSR169()) {
            suite.addTest(NativeAuthenticationServiceTest.allConfigurations(true));
        }
        return new TimeZoneTestSetup((Test)suite, "GMT");
    }

    private static boolean enableSubprotocolTests() {
        return ClasspathSetup.supportsClose() || !NativeAuthenticationServiceTest.isWindowsPlatform();
    }

    private static Test allConfigurations(boolean clientServer) throws Exception {
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTest(new NativeAuthenticationServiceTest(3, false, false, false).decorate(clientServer));
        suite.addTest(new NativeAuthenticationServiceTest(0, true, true, true).decorate(clientServer));
        suite.addTest(new NativeAuthenticationServiceTest(0, true, true, false).decorate(clientServer));
        suite.addTest(new NativeAuthenticationServiceTest(0, true, false, true).decorate(clientServer));
        suite.addTest(new NativeAuthenticationServiceTest(0, true, false, false).decorate(clientServer));
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            suite.addTest(new NativeAuthenticationServiceTest(1, true, false, false).decorate(clientServer));
            suite.addTest(new NativeAuthenticationServiceTest(1, true, true, false).decorate(clientServer));
            suite.addTest(new NativeAuthenticationServiceTest(2, true, false, false).decorate(clientServer));
            suite.addTest(new NativeAuthenticationServiceTest(2, true, true, false).decorate(clientServer));
        }
        return suite;
    }

    private Test decorate(boolean clientServer) throws Exception {
        String credentialsDBPhysicalName = TestConfiguration.generateUniqueDatabaseName();
        Object result = this;
        if (clientServer) {
            result = TestConfiguration.clientServerDecorator((Test)result);
        }
        Properties systemProperties = null;
        try {
            systemProperties = this.systemProperties(credentialsDBPhysicalName);
        }
        catch (Exception e) {
            NativeAuthenticationServiceTest.printStackTrace(e);
        }
        NativeAuthenticationServiceTest.println(this.nameOfTest());
        NativeAuthenticationServiceTest.println("    NativeAuthenticationServiceTest.decorate() systemProperties = " + systemProperties);
        result = new SystemPropertyTestSetup((Test)result, systemProperties, true);
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            URL nast2Jar = SupportFilesSetup.getReadOnlyURL(NAST2_JAR_FILE);
            result = new ClasspathSetup((Test)result, nast2Jar);
            result = new SupportFilesSetup((Test)result, SUPPORT_FILES_SOURCE, null, SUPPORT_FILES_TARGET, null);
        }
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, CREDENTIALS_DB, credentialsDBPhysicalName);
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, SECOND_DB);
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, THIRD_DB);
        this._fourthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, FOURTH_DB, true);
        result = this._fourthDBSetup;
        this._fifthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, FIFTH_DB, true);
        result = this._fifthDBSetup;
        this._sixthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, SIXTH_DB, true);
        result = this._sixthDBSetup;
        this._seventhDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, SEVENTH_DB, true);
        result = this._seventhDBSetup;
        this._eighthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, EIGHTH_DB, true);
        result = this._eighthDBSetup;
        this._ninthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, NINTH_DB, true);
        result = this._ninthDBSetup;
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, TENTH_DB);
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, ELEVENTH_DB);
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, TWELTH_DB);
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, THIRTEENTH_DB);
        result = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, FOURTEENTH_DB);
        this._fifteenthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)result, FIFTEENTH_DB, true);
        result = this._fifteenthDBSetup;
        result = TestConfiguration.changeUserDecorator((Test)result, DBO, NativeAuthenticationServiceTest.getPassword(DBO));
        return result;
    }

    public void testAll() throws Exception {
        NativeAuthenticationServiceTest.println(this.nameOfTest());
        NativeAuthenticationServiceTest.println("Credentials DB physical name = " + this._credentialsDBPhysicalName);
        NativeAuthenticationServiceTest.println("derby.authentication.provider = " + NativeAuthenticationServiceTest.getSystemProperty(PROVIDER_PROPERTY));
        if (this._credentialsDBLocation == 4) {
            this.vetEncryptedCredentialsDB();
        } else if (this.credentialsViaSubprotocol()) {
            this.vetCredentialsViaSubprotocol();
        } else {
            this.vetCoreBehavior();
            this.vetCasing();
            this.vetSystemWideOperations();
            if (!this._nativeAuthentication) {
                this.vetProviderChanges();
            }
            if (this._localAuthentication && this.isEmbedded()) {
                this.vetPasswordLifetime();
            }
        }
    }

    private void vetEncryptedCredentialsDB() throws Exception {
        Connection badConn = this.getConnection(true, true, THIRTEENTH_DB, DBO, CANT_BOOT_DATABASE);
        Properties props = new Properties();
        props.setProperty("bootPassword", "clo760uds2caPe");
        Connection dboConn = this.openConnection(NativeAuthenticationServiceTest.jarDBName(this._credentialsDBLocation), DBO, false, props);
        Connection grapeConn = this.getConnection(false, true, THIRTEENTH_DB, GRAPE_USER, null);
        this.getConnection(true, true, FOURTEENTH_DB, WALNUT_USER, INVALID_AUTHENTICATION);
    }

    private void vetCredentialsViaSubprotocol() throws Exception {
        String[][] stringArray;
        Connection grapeConn = this.openConnection(TENTH_DB, GRAPE_USER, true, null);
        if (this._localAuthentication) {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{GRAPE_USER};
        } else {
            stringArray = new String[][]{};
        }
        String[][] legalUsers = stringArray;
        this.assertResults(grapeConn, "select username from sys.sysusers order by username", legalUsers, false);
        Connection walnutConn = this.getConnection(true, true, ELEVENTH_DB, WALNUT_USER, INVALID_AUTHENTICATION);
    }

    private void vetCoreBehavior() throws Exception {
        String[][] stringArrayArray;
        String[][] stringArrayArray2;
        Connection secondDBConn = this.getConnection(this._nativeAuthentication, true, SECOND_DB, APPLE_USER, CREDENTIALS_DB_DOES_NOT_EXIST);
        if (this._nativeAuthentication) {
            this.vetEmptyCredentials();
        }
        Connection sysadminConn = this.openConnection(CREDENTIALS_DB, DBO, true, null);
        this.getConnection(this._nativeAuthentication, true, CREDENTIALS_DB, DBO, null, INVALID_AUTHENTICATION);
        if (!this._nativeAuthentication) {
            Connection pineappleConn = this.openConnection(CREDENTIALS_DB, PINEAPPLE_USER, true, null);
            this.addUser(pineappleConn, DBO, DBO_ONLY_OPERATION);
            this.addUser(sysadminConn, DBO);
        }
        this.addUser(sysadminConn, APPLE_USER);
        this.addUser(sysadminConn, BANANA_USER);
        String[][] legalUsers = new String[][]{{APPLE_USER}, {BANANA_USER}, {DBO}};
        this.assertResults(sysadminConn, "select username from sys.sysusers order by username", legalUsers, false);
        String[][] authenticationProvider = new String[][]{{"NATIVE::LOCAL"}};
        this.assertResults(sysadminConn, "values ( syscs_util.syscs_get_database_property( 'derby.authentication.provider' ) )", authenticationProvider, false);
        String[][] sqlAuthorization = new String[][]{{null}};
        this.assertResults(sysadminConn, "values ( syscs_util.syscs_get_database_property( 'derby.database.sqlAuthorization' ) )", sqlAuthorization, false);
        this.vetSQLAuthorizationOn();
        String[][] dboName = new String[][]{{DBO}};
        this.assertResults(sysadminConn, "select authorizationID from sys.sysschemas where schemaName = 'SYS'", dboName, false);
        if (this._localAuthentication) {
            this.passwordHashingTests(sysadminConn);
        }
        Connection thirdDBConn = this.getConnection(this._nativeAuthentication, true, THIRD_DB, WALNUT_USER, INVALID_AUTHENTICATION);
        if (secondDBConn == null) {
            secondDBConn = this.getConnection(false, true, SECOND_DB, APPLE_USER, null);
        }
        this.assertResults(secondDBConn, "select authorizationID from sys.sysschemas where schemaName = 'SYS'", new String[][]{{APPLE_USER}}, false);
        this.assertResults(secondDBConn, "values ( syscs_util.syscs_get_database_property( 'derby.database.sqlAuthorization' ) )", sqlAuthorization, false);
        if (this._localAuthentication) {
            String[][] stringArrayArray3 = new String[1][];
            stringArrayArray2 = stringArrayArray3;
            stringArrayArray3[0] = new String[]{"NATIVE::LOCAL"};
        } else {
            String[][] stringArrayArray4 = new String[1][];
            stringArrayArray2 = stringArrayArray4;
            stringArrayArray4[0] = new String[]{null};
        }
        authenticationProvider = stringArrayArray2;
        this.assertResults(secondDBConn, "values ( syscs_util.syscs_get_database_property( 'derby.authentication.provider' ) )", authenticationProvider, false);
        if (this._localAuthentication) {
            String[][] stringArrayArray5 = new String[1][];
            stringArrayArray = stringArrayArray5;
            stringArrayArray5[0] = new String[]{APPLE_USER};
        } else {
            stringArrayArray = new String[][]{};
        }
        legalUsers = stringArrayArray;
        this.assertResults(secondDBConn, "select username from sys.sysusers order by username", legalUsers, false);
        Connection seventhDBOConn = this.openConnection(SEVENTH_DB, DBO, true, null);
        if (this._localAuthentication) {
            this.addUser(seventhDBOConn, APPLE_USER);
        }
        this.goodStatement(seventhDBOConn, "create table t1( a int )");
        this.goodStatement(seventhDBOConn, "insert into t1( a ) values ( 10 )");
        this.setDatabaseProperty(this._nativeAuthentication, seventhDBOConn, SQL_AUTHORIZATION_PROPERTY, "false", BAD_PROPERTY_CHANGE);
        this.goodStatement(seventhDBOConn, "call syscs_util.syscs_set_database_property( 'derby.connection.requireAuthentication', 'false' )");
        this.goodStatement(seventhDBOConn, "call syscs_util.syscs_set_database_property( 'derby.database.propertiesOnly', 'true' )");
        this._seventhDBSetup.getTestConfiguration().shutdownDatabase();
        Connection seventhAppleConn = this.openConnection(SEVENTH_DB, APPLE_USER, true, null);
        this.vetStatement(this._localAuthentication, seventhAppleConn, "select * from KIWI.t1", NO_COLUMN_PERMISSION);
        Connection seventhWalnutConn = this.getConnection(this._localAuthentication, true, SEVENTH_DB, WALNUT_USER, INVALID_AUTHENTICATION);
        Connection eighthDBOConn = this.openConnection(EIGHTH_DB, DBO, true, null);
        this.setDatabaseProperty(this._localAuthentication, eighthDBOConn, PROVIDER_PROPERTY, "BUILTIN", INVALID_PROVIDER_CHANGE);
        this.setDatabaseProperty(false, eighthDBOConn, REQUIRE_AUTHENTICATION_PROPERTY, "true", null);
        this.setDatabaseProperty(false, eighthDBOConn, "derby.database.propertiesOnly", "true", null);
        this.addBuiltinUser(eighthDBOConn, DBO);
        this.addBuiltinUser(eighthDBOConn, BUILTIN_USER);
        this._eighthDBSetup.getTestConfiguration().shutdownDatabase();
        Connection builtinConn = this.getConnection(this._localAuthentication, true, EIGHTH_DB, BUILTIN_USER, INVALID_AUTHENTICATION);
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            this.vetProtocol(NativeAuthenticationServiceTest.jarDBName(this._credentialsDBLocation));
            this.vetProtocol(NativeAuthenticationServiceTest.classpathDBName());
        }
        Connection twelthDBOConn = this.openConnection(TWELTH_DB, DBO, true, null);
        if (this._localAuthentication) {
            this.addUser(twelthDBOConn, APPLE_USER);
        }
        Connection twelthAppleConn = this.openConnection(TWELTH_DB, APPLE_USER, true, null);
        if (this._localAuthentication) {
            this.vetStatement(this._nativeAuthentication, twelthAppleConn, "call syscs_util.syscs_create_user( 'JULIUS', 'juliuspassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, twelthAppleConn, "call syscs_util.syscs_reset_password( 'JULIUS', 'foopassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, twelthAppleConn, "call syscs_util.syscs_drop_user( 'JULIUS' )", NO_EXECUTE_PERMISSION);
        }
        this.vetStatement(!this._localAuthentication, twelthAppleConn, "call syscs_util.syscs_modify_password( 'foo' )", MISSING_USER);
        this.vetStatement(!this._nativeAuthentication, twelthDBOConn, "grant execute on procedure syscs_util.syscs_create_user to APPLE", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, twelthDBOConn, "grant execute on procedure syscs_util.syscs_reset_password to APPLE", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, twelthDBOConn, "grant execute on procedure syscs_util.syscs_drop_user to APPLE", SQL_AUTHORIZATION_NOT_ON);
        if (this._localAuthentication) {
            this.goodStatement(twelthAppleConn, "call syscs_util.syscs_create_user( 'HORACE', 'horacepassword' )");
            this.goodStatement(twelthAppleConn, "call syscs_util.syscs_reset_password( 'HORACE', 'foopassword' )");
            this.goodStatement(twelthAppleConn, "call syscs_util.syscs_drop_user( 'HORACE' )");
        }
        this.vetStatement(!this._nativeAuthentication, twelthDBOConn, "revoke execute on procedure syscs_util.syscs_create_user from APPLE restrict", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, twelthDBOConn, "revoke execute on procedure syscs_util.syscs_reset_password from APPLE restrict", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, twelthDBOConn, "revoke execute on procedure syscs_util.syscs_drop_user from APPLE restrict", SQL_AUTHORIZATION_NOT_ON);
        if (this._localAuthentication) {
            this.vetStatement(this._nativeAuthentication, twelthAppleConn, "call syscs_util.syscs_create_user( 'CORNELIA', 'corneliapassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, twelthAppleConn, "call syscs_util.syscs_reset_password( 'CORNELIA', 'foopassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, twelthAppleConn, "call syscs_util.syscs_drop_user( 'CORNELIA' )", NO_EXECUTE_PERMISSION);
        }
    }

    private static String jarDBName(int credentialsDBLocation) throws Exception {
        String dbName = credentialsDBLocation == 4 ? "nastEncrypted" : "nast";
        return "jar:(" + SupportFilesSetup.getReadOnlyFileName(NAST1_JAR_FILE) + ")" + dbName;
    }

    private static String classpathDBName() {
        return "classpath:nast";
    }

    private void vetEmptyCredentials() throws Exception {
        this.vetEmptyCredentials(null, null);
        this.vetEmptyCredentials("", null);
        this.vetEmptyCredentials(null, "");
        this.vetEmptyCredentials("", "");
        this.vetEmptyCredentials("foo", null);
        this.vetEmptyCredentials("foo", "");
        if (this.isEmbedded()) {
            this.vetEmptyCredentials(null, "bar");
        }
        this.vetEmptyCredentials("", "bar");
    }

    private void vetEmptyCredentials(String user, String password) throws Exception {
        String[] expectedSQLStates = new String[]{INVALID_AUTHENTICATION, BAD_NETWORK_AUTHENTICATION};
        this.getConnection(true, true, CREDENTIALS_DB, user, password, expectedSQLStates);
    }

    private void addBuiltinUser(Connection conn, String user) throws Exception {
        String key = "derby.user." + user;
        String value = NativeAuthenticationServiceTest.getPassword(user);
        this.setDatabaseProperty(false, conn, key, value, null);
    }

    private void vetProtocol(String protocolDBName) throws Exception {
        Connection grapeConn = this.getConnection(false, false, protocolDBName, GRAPE_USER, null);
        this.vetStatement(true, grapeConn, "select * from KIWI.t", NO_COLUMN_PERMISSION);
        this.getConnection(true, false, protocolDBName, WALNUT_USER, INVALID_AUTHENTICATION);
    }

    private void vetCasing() throws Exception {
        if (!this._nativeAuthentication) {
            return;
        }
        if (this._localAuthentication) {
            return;
        }
        String originalPricklyPearPassword = "prickly_pear_password";
        Connection dboConn = this.openConnection(CREDENTIALS_DB, DBO, true, null);
        this.addUser(dboConn, CAMEL_CASE_DBO, USER_ALREADY_EXISTS);
        this.addUser(dboConn, PEAR_USER, null);
        NativeAuthenticationServiceTest.assertFalse((boolean)PEAR_USER.equals(PRICKLY_PEAR_USER));
        NativeAuthenticationServiceTest.assertTrue((boolean)PEAR_USER.toUpperCase().equals(PRICKLY_PEAR_USER.toUpperCase()));
        this.goodStatement(dboConn, "call syscs_util.syscs_create_user( '\"PeAr\"', '" + originalPricklyPearPassword + "' )");
        String[][] legalUsers = new String[][]{{PEAR_USER}, {PRICKLY_PEAR_USER}};
        this.assertResults(dboConn, "select username from sys.sysusers where username like 'P%' order by username", legalUsers, false);
        Connection pearConn = this.openConnection(CREDENTIALS_DB, PEAR_USER, true, null);
        this.assertResults(pearConn, "values current schema", new String[][]{{PEAR_USER.toUpperCase()}}, false);
        Connection pricklyPearConn = this.openConnection(CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), originalPricklyPearPassword, true, null);
        this.assertResults(pricklyPearConn, "values current schema", new String[][]{{PRICKLY_PEAR_USER}}, false);
        String rev2_password = "password_rev2";
        this.goodStatement(pricklyPearConn, "call syscs_util.syscs_modify_password( '" + rev2_password + "' )");
        this.getConnection(true, true, CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), originalPricklyPearPassword, INVALID_AUTHENTICATION);
        pricklyPearConn = this.openConnection(CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), rev2_password, true, null);
        String rev3_password = "password_rev3";
        this.goodStatement(dboConn, "call syscs_util.syscs_reset_password( '" + this.doubleQuote(PRICKLY_PEAR_USER) + "', '" + rev3_password + "' )");
        this.getConnection(true, true, CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), rev2_password, INVALID_AUTHENTICATION);
        pricklyPearConn = this.openConnection(CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), rev3_password, true, null);
        int userCount = this.countUsers(dboConn);
        this.goodStatement(dboConn, "call syscs_util.syscs_drop_user( '" + this.doubleQuote(PRICKLY_PEAR_USER) + "' )");
        NativeAuthenticationServiceTest.assertEquals((int)(userCount - 1), (int)this.countUsers(dboConn));
        this.getConnection(true, true, CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), rev3_password, INVALID_AUTHENTICATION);
    }

    private String doubleQuote(String raw) {
        return "\"" + raw + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countUsers(Connection conn) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count(*) from sys.sysusers");
        ResultSet rs = ps.executeQuery();
        rs.next();
        try {
            int n = rs.getInt(1);
            return n;
        }
        finally {
            rs.close();
            ps.close();
        }
    }

    private void vetSystemWideOperations() throws Exception {
        Connection dboConn = this.openConnection(SIXTH_DB, DBO, true, null);
        if (this._localAuthentication) {
            this.addUser(dboConn, BANANA_USER);
        }
        this.goodStatement(dboConn, "create table t( a int )");
        this.goodStatement(dboConn, "insert into t( a ) values ( 1000 )");
        if (this._nativeAuthentication) {
            this.goodStatement(dboConn, "grant select on table t to public");
            this.goodStatement(dboConn, "grant insert on table t to public");
        }
        this.goodStatement(dboConn, "call syscs_util.syscs_backup_database( '" + this._fullBackupDir + "' )");
        this.goodStatement(dboConn, "delete from t");
        this.shutdownAndRestoreDB(true, BANANA_USER, null);
        this.shutdownAndRestoreDB(!this._localAuthentication, APPLE_USER, INVALID_AUTHENTICATION);
        NativeAuthenticationServiceTest.assertDirectoryDeleted(new File(this._fullBackupDir));
    }

    private void shutdownAndRestoreDB(boolean shouldSucceed, String user, String expectedSQLState) throws Exception {
        this._sixthDBSetup.getTestConfiguration().shutdownDatabase();
        String dbName = this._sixthDBSetup.physicalDatabaseName();
        int slashIdx = dbName.lastIndexOf("/");
        if (slashIdx >= 0) {
            dbName = dbName.substring(slashIdx + 1);
        }
        DataSource ds = JDBCDataSource.getDataSourceLogical(SIXTH_DB);
        String fullRestoreDir = this._fullBackupDir + "/" + dbName;
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "restoreFrom=" + fullRestoreDir);
        Connection conn = null;
        try {
            conn = ds.getConnection(user, NativeAuthenticationServiceTest.getPassword(user));
            if (!shouldSucceed) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Database restoration should have failed."));
            }
        }
        catch (SQLException se) {
            if (shouldSucceed) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Database restoration unexpectedly failed."));
            }
            NativeAuthenticationServiceTest.assertSQLState(expectedSQLState, se);
        }
        if (conn != null) {
            this.assertResults(conn, "select a from KIWI.t", new String[][]{{"1000"}}, false);
            this.goodStatement(conn, "insert into KIWI.t( a ) values ( 2000 )");
        }
    }

    private void vetProviderChanges() throws Exception {
        String dbo = ORANGE_USER;
        Connection dboConn = this.openConnection(FOURTH_DB, dbo, true, null);
        this.goodStatement(dboConn, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'com.acme.AcmeAuthenticator' )");
        this.expectExecutionError(dboConn, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE::LOCAL' )");
        this.expectExecutionError(dboConn, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE:db:LOCAL' )");
        this.expectExecutionError(dboConn, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE:LOCAL' )");
        this.addUser(dboConn, dbo);
        this.addUser(dboConn, PEAR_USER);
        this.expectExecutionError(dboConn, CANT_DROP_DBO, "call syscs_util.syscs_drop_user( '" + dbo + "' )");
        String[][] legalUsers = new String[][]{{dbo}, {PEAR_USER}};
        this.assertResults(dboConn, "select username from sys.sysusers order by username", legalUsers, false);
        this.expectExecutionError(dboConn, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE::LOCAL' )");
        this.expectExecutionError(dboConn, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', null )");
        this.expectExecutionError(dboConn, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'com.acme.AcmeAuthenticator' )");
        String[][] authenticationProvider = new String[][]{{"NATIVE::LOCAL"}};
        this.assertResults(dboConn, "values ( syscs_util.syscs_get_database_property( 'derby.authentication.provider' ) )", authenticationProvider, false);
        this.goodStatement(dboConn, "create table t( a int )");
        this._fourthDBSetup.getTestConfiguration().shutdownDatabase();
        Connection appleConn = this.getConnection(true, true, FOURTH_DB, APPLE_USER, INVALID_AUTHENTICATION);
        Connection pearConn = this.openConnection(FOURTH_DB, PEAR_USER, true, null);
        this.expectExecutionError(pearConn, NO_COLUMN_PERMISSION, "select * from " + dbo + ".t");
        this.expectCompilationError(pearConn, DBO_ONLY_OPERATION, "select username from sys.sysusers");
        if (this.isEmbedded()) {
            Connection fifteenthConn = this.openConnection(FIFTEENTH_DB, dbo, true, null);
            this.goodStatement(fifteenthConn, "call syscs_util.syscs_set_database_property( 'derby.connection.requireAuthentication', 'true' )");
            this.goodStatement(fifteenthConn, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE' )");
            this._fifteenthDBSetup.getTestConfiguration().shutdownDatabase();
            this.getConnection(true, true, FIFTEENTH_DB, DBO, BAD_USER_AUTHENTICATOR_CLASS);
        }
    }

    private void vetPasswordLifetime() throws Exception {
        Connection dboConn = this.openConnection(FIFTH_DB, DBO, true, null);
        this.addUser(dboConn, APPLE_USER);
        Connection appleConn = this.passwordExpiring(false, FIFTH_DB, APPLE_USER);
        this.goodStatement(dboConn, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', '86400000' )");
        this.goodStatement(dboConn, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeThreshold', '2.0' )");
        this._fifthDBSetup.getTestConfiguration().shutdownDatabase();
        dboConn = this.passwordExpiring(true, FIFTH_DB, DBO);
        appleConn = this.passwordExpiring(true, FIFTH_DB, APPLE_USER);
        this.goodStatement(dboConn, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', '1' )");
        this._fifthDBSetup.getTestConfiguration().shutdownDatabase();
        dboConn = this.openConnection(FIFTH_DB, DBO, true, null);
        appleConn = this.getConnection(true, true, FIFTH_DB, APPLE_USER, INVALID_AUTHENTICATION);
        this.goodStatement(dboConn, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', '0' )");
        this._fifthDBSetup.getTestConfiguration().shutdownDatabase();
        dboConn = this.passwordExpiring(false, FIFTH_DB, DBO);
        appleConn = this.passwordExpiring(false, FIFTH_DB, APPLE_USER);
        this.expectExecutionError(dboConn, BAD_PASSWORD_PROPERTY, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', 'rabbit' )");
        this.expectExecutionError(dboConn, BAD_PASSWORD_PROPERTY, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeThreshold', '-1' )");
    }

    private void passwordHashingTests(Connection dboConnection) throws Exception {
        String originalDigestAlgorithm = this.getDatabaseProperty(dboConnection, "derby.authentication.builtin.algorithm");
        if (originalDigestAlgorithm == null) {
            this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.algorithm", "SHA-1");
        }
        String defaultDigestAlgorithm = this.getDatabaseProperty(dboConnection, "derby.authentication.builtin.algorithm");
        this.goodStatement(dboConnection, "call syscs_util.syscs_create_user( 'pht', 'phtpassword' )");
        this.vetHashingScheme(dboConnection, "pht", HASHING_FORMAT_10_9, 16, 1000, defaultDigestAlgorithm);
        int saltLength = 5;
        this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.saltLength", Integer.toString(saltLength));
        this.goodStatement(dboConnection, "call syscs_util.syscs_reset_password( 'pht', 'newsaltlength' )");
        this.vetHashingScheme(dboConnection, "pht", HASHING_FORMAT_10_9, saltLength, 1000, defaultDigestAlgorithm);
        int iterations = 10;
        this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.iterations", Integer.toString(iterations));
        this.goodStatement(dboConnection, "call syscs_util.syscs_reset_password( 'pht', 'newiterations' )");
        this.vetHashingScheme(dboConnection, "pht", HASHING_FORMAT_10_9, saltLength, iterations, defaultDigestAlgorithm);
        String digestAlgorithm = "SHA-1";
        this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.algorithm", digestAlgorithm);
        this.goodStatement(dboConnection, "call syscs_util.syscs_reset_password( 'pht', 'newiterations' )");
        this.vetHashingScheme(dboConnection, "pht", HASHING_FORMAT_10_9, saltLength, iterations, digestAlgorithm);
        this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.algorithm", null);
        this.expectExecutionError(dboConnection, WEAK_AUTHENTICATION, "call syscs_util.syscs_reset_password( 'pht', 'badalgorithm' )");
        this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.saltLength", null);
        this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.iterations", null);
        this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.algorithm", defaultDigestAlgorithm);
        this.goodStatement(dboConnection, "call syscs_util.syscs_drop_user( 'pht' )");
        if (originalDigestAlgorithm == null) {
            this.setDatabaseProperty(dboConnection, "derby.authentication.builtin.algorithm", null);
        }
    }

    private void setDatabaseProperty(Connection conn, String key, String value) throws Exception {
        value = value == null ? "cast ( null as varchar( 32672 ) )" : "'" + value + "'";
        String command = "call syscs_util.syscs_set_database_property( '" + key + "', " + value + " )";
        this.goodStatement(conn, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseProperty(Connection conn, String key) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "values( syscs_util.syscs_get_database_property( '" + key + "' ) )");
        ResultSet rs = ps.executeQuery();
        try {
            rs.next();
            String string = rs.getString(1);
            return string;
        }
        finally {
            rs.close();
            ps.close();
        }
    }

    private void vetHashingScheme(Connection conn, String userName, String expectedHashingFormat, int expectedSaltLength, int expectedIterations, String expectedDigestAlgorithm) throws Exception {
        String hashingScheme = this.getHashingScheme(conn, userName);
        int firstColonPosition = hashingScheme.indexOf(":");
        int secondColonPosition = hashingScheme.indexOf(":", firstColonPosition + 1);
        int thirdColonPosition = hashingScheme.indexOf(":", secondColonPosition + 1);
        String actualHashingFormat = hashingScheme.substring(0, firstColonPosition);
        String salt = hashingScheme.substring(firstColonPosition + 1, secondColonPosition);
        String iterationString = hashingScheme.substring(secondColonPosition + 1, thirdColonPosition);
        String actualDigestAlgorithm = hashingScheme.substring(thirdColonPosition + 1);
        int actualSaltLength = salt.length();
        int actualIterations = Integer.parseInt(iterationString);
        NativeAuthenticationServiceTest.assertEquals((String)expectedHashingFormat, (String)actualHashingFormat);
        NativeAuthenticationServiceTest.assertEquals((int)(expectedSaltLength * 2), (int)actualSaltLength);
        NativeAuthenticationServiceTest.assertEquals((int)expectedIterations, (int)actualIterations);
        NativeAuthenticationServiceTest.assertEquals((String)expectedDigestAlgorithm, (String)actualDigestAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHashingScheme(Connection conn, String userName) throws Exception {
        PreparedStatement ps = conn.prepareStatement("select userName, hashingScheme from sys.sysusers");
        ResultSet rs = ps.executeQuery();
        userName = userName.toUpperCase();
        try {
            while (rs.next()) {
                if (!userName.equals(rs.getString(1))) continue;
                String string = rs.getString(2);
                return string;
            }
        }
        finally {
            rs.close();
            ps.close();
        }
        NativeAuthenticationServiceTest.fail((String)("Could not find credentials for " + userName));
        return null;
    }

    private void vetSQLAuthorizationOn() throws Exception {
        Connection nonDBOConn = this.openConnection(CREDENTIALS_DB, APPLE_USER, true, null);
        String query = "select username from sys.sysusers";
        try {
            this.chattyPrepare(nonDBOConn, query);
            if (this._nativeAuthentication) {
                NativeAuthenticationServiceTest.fail((String)"SQL Authorization not on!");
            }
        }
        catch (SQLException se) {
            if (this._nativeAuthentication) {
                NativeAuthenticationServiceTest.assertSQLState(DBO_ONLY_OPERATION, se);
            }
            NativeAuthenticationServiceTest.fail((String)("Caught unexpected SQLException: " + se.getSQLState() + ": " + se.getMessage()));
        }
    }

    private Connection getConnection(boolean shouldFail, boolean isLogicalName, String dbName, String user, String expectedSQLState) throws Exception {
        return this.getConnection(shouldFail, isLogicalName, dbName, user, NativeAuthenticationServiceTest.getPassword(user), expectedSQLState);
    }

    private Connection getConnection(boolean shouldFail, boolean isLogicalName, String dbName, String user, String password, String expectedSQLState) throws Exception {
        return this.getConnection(shouldFail, isLogicalName, dbName, user, password, new String[]{expectedSQLState});
    }

    private Connection getConnection(boolean shouldFail, boolean isLogicalName, String dbName, String user, String password, String[] expectedSQLStates) throws Exception {
        Connection conn = null;
        this.reportConnectionAttempt(dbName, user, password, isLogicalName);
        try {
            conn = this.openConnection(dbName, user, password, isLogicalName, null);
            if (shouldFail) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Connection to " + dbName + " should have failed."));
            }
        }
        catch (Throwable t) {
            if (shouldFail && t instanceof SQLException) {
                SQLException se = (SQLException)t;
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < expectedSQLStates.length; ++i) {
                    String expected = expectedSQLStates[i];
                    buffer.append(" " + expected);
                    if (!this.vetSQLState(se, expected)) continue;
                    return null;
                }
                NativeAuthenticationServiceTest.fail((String)this.tagError("SQLState not in expected list: " + buffer.toString()));
            }
            NativeAuthenticationServiceTest.printStackTrace(t);
            NativeAuthenticationServiceTest.fail((String)this.tagError("Connection to " + dbName + " unexpectedly failed."));
        }
        return conn;
    }

    private boolean vetSQLState(SQLException actual, String expectedSQLState) throws Exception {
        if (actual == null) {
            return false;
        }
        if (expectedSQLState.equals(actual.getSQLState())) {
            return true;
        }
        Throwable t = actual.getCause();
        if (t instanceof SQLException && this.vetSQLState((SQLException)t, expectedSQLState)) {
            return true;
        }
        return this.vetSQLState(actual.getNextException(), expectedSQLState);
    }

    private Connection passwordExpiring(boolean expiring, String dbName, String user) throws Exception {
        Connection conn = null;
        this.reportConnectionAttempt(dbName, user, NativeAuthenticationServiceTest.getPassword(user), true);
        String expectedSQLState = DBO.equals(user) ? DBO_PASSWORD_EXPIRING : PASSWORD_EXPIRING;
        conn = this.openConnection(dbName, user, true, null);
        SQLWarning warning = conn.getWarnings();
        if (expiring) {
            NativeAuthenticationServiceTest.assertNotNull((String)this.tagError("Should have seen a warning"), (Object)warning);
            NativeAuthenticationServiceTest.assertSQLState(expectedSQLState, warning);
        } else {
            NativeAuthenticationServiceTest.assertNull((String)this.tagError("Should not have seen a warning"), (Object)warning);
        }
        return conn;
    }

    private void reportConnectionAttempt(String dbName, String user, String password, boolean isLogicalName) {
        String message = "User '" + user + "' with password '" + password + "' attempting to get connection to database " + dbName;
        if (isLogicalName) {
            message = message + " aka " + this.getTestConfiguration().getPhysicalDatabaseName(dbName);
        }
        NativeAuthenticationServiceTest.println(message);
    }

    private void addUser(Connection conn, String user) throws Exception {
        this.addUser(conn, user, null);
    }

    private void addUser(Connection conn, String user, String expectedSQLState) throws Exception {
        boolean shouldFail = expectedSQLState != null;
        String password = NativeAuthenticationServiceTest.getPassword(user);
        String statement = "call syscs_util.syscs_create_user( '" + user + "', '" + password + "' )";
        if (shouldFail) {
            NativeAuthenticationServiceTest.println("Expecting " + expectedSQLState + " when executing '" + statement + "'");
        }
        try {
            this.goodStatement(conn, statement);
            if (shouldFail) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Should not have been allowed to create user " + user));
            }
        }
        catch (SQLException se) {
            if (shouldFail) {
                NativeAuthenticationServiceTest.assertSQLState(expectedSQLState, se);
            }
            NativeAuthenticationServiceTest.fail((String)this.tagError("Unexpectedly failed to create user " + user));
        }
    }

    private void setDatabaseProperty(boolean shouldFail, Connection conn, String key, String value, String expectedSQLState) throws Exception {
        value = value == null ? "cast ( null as varchar( 32672 ) )" : "'" + value + "'";
        String command = "call syscs_util.syscs_set_database_property( '" + key + "', " + value + " )";
        try {
            this.goodStatement(conn, command);
            if (shouldFail) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Property setting should have failed."));
            }
        }
        catch (SQLException se) {
            if (shouldFail) {
                NativeAuthenticationServiceTest.assertSQLState(expectedSQLState, se);
            }
            NativeAuthenticationServiceTest.fail((String)this.tagError("Property setting unexpectedly failed."));
        }
    }

    private void vetStatement(boolean shouldFail, Connection conn, String command, String expectedSQLState) throws Exception {
        try {
            this.goodStatement(conn, command);
            if (shouldFail) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Statement should have failed."));
            }
        }
        catch (SQLException se) {
            if (shouldFail) {
                NativeAuthenticationServiceTest.assertSQLState(expectedSQLState, se);
            }
            String error = "Statement unexpectedly failed. SQLState = " + se.getSQLState() + ": " + se.getMessage();
            NativeAuthenticationServiceTest.fail((String)this.tagError(error));
        }
    }

    private Connection openConnection(String dbName, String user, boolean isLogicalName, Properties props) throws SQLException {
        return this.openConnection(dbName, user, NativeAuthenticationServiceTest.getPassword(user), isLogicalName, props);
    }

    private Connection openConnection(String dbName, String user, String password, boolean isLogicalName, Properties props) throws SQLException {
        if (isLogicalName) {
            return this.getTestConfiguration().openConnection(dbName, user, password);
        }
        return this.getTestConfiguration().openPhysicalConnection(dbName, user, password, props);
    }

    private static String getPassword(String user) {
        return user + "_password";
    }

    private String tagError(String text) {
        return this.nameOfTest() + ": " + text;
    }
}

