/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealScalarAggregateStatistics
extends RealNoPutResultSetStatistics {
    public int rowsInput = 0;
    public boolean indexKeyOptimization;
    public ResultSetStatistics childResultSetStatistics;

    public RealScalarAggregateStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, boolean indexKeyOptimization, int rowsInput, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.indexKeyOptimization = indexKeyOptimization;
        this.rowsInput = rowsInput;
        this.childResultSetStatistics = childResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        return this.indent + MessageService.getTextMessage("43Y00.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X21.U", new Object[0]) + " = " + this.rowsInput + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43Y01.U", new Object[0]) + " = " + this.indexKeyOptimization + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.childResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        return children;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43Y02.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.childResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "AGGREGATION";
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, null, null, (UUID)parentID, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, this.rowsInput, this.rowsSeen, null, this.rowsFiltered, this.rowsInput - this.rowsFiltered, null, this.indexKeyOptimization ? "Y" : "N", (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

