/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

class OrderByNode
extends SingleChildResultSetNode {
    OrderByList orderByList;

    OrderByNode(ResultSetNode childRes, OrderByList orderByList, Properties tableProperties, ContextManager cm) throws StandardException {
        super(childRes, tableProperties, cm);
        this.orderByList = orderByList;
        ResultColumnList prRCList = childRes.getResultColumns().copyListAndObjects();
        this.setResultColumns(childRes.getResultColumns());
        childRes.setResultColumns(prRCList);
        this.getResultColumns().genVirtualColumnNodes(this, prRCList);
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
    }

    @Override
    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.childResult.makeResultDescriptors();
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.getCostEstimate() == null) {
            this.setCostEstimate(this.childResult.getFinalCostEstimate());
        }
        this.orderByList.generate(acb, mb, this.childResult);
        this.setResultSetNumber(this.orderByList.getResultSetNumber());
        this.getResultColumns().setResultSetNumber(this.getResultSetNumber());
    }
}

