/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.IndexStatisticsDaemon;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.ASTVisitor;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStorablePreparedStatement;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;
import org.apache.derby.shared.common.sanity.SanityManager;

public class GenericStatement
implements Statement {
    private final SchemaDescriptor compilationSchema;
    private final String statementText;
    private final boolean isForReadOnly;
    private int prepareIsolationLevel;
    private GenericPreparedStatement preparedStmt;

    public GenericStatement(SchemaDescriptor compilationSchema, String statementText, boolean isForReadOnly) {
        this.compilationSchema = compilationSchema;
        this.statementText = statementText;
        this.isForReadOnly = isForReadOnly;
    }

    @Override
    public PreparedStatement prepare(LanguageConnectionContext lcc) throws StandardException {
        return this.prepare(lcc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepare(LanguageConnectionContext lcc, boolean forMetaData) throws StandardException {
        int depth = lcc.getStatementDepth();
        String prevErrorId = null;
        block11: while (true) {
            boolean recompile = false;
            try {
                PreparedStatement preparedStatement = this.prepMinion(lcc, true, null, null, forMetaData);
                return preparedStatement;
            }
            catch (StandardException se) {
                if ("XSAI2.S".equals(se.getMessageId())) {
                    String conglomId = String.valueOf(se.getArguments()[0]);
                    if (!conglomId.equals(prevErrorId)) {
                        recompile = true;
                    }
                    prevErrorId = conglomId;
                }
                throw se;
            }
            finally {
                GenericPreparedStatement genericPreparedStatement = this.preparedStmt;
                synchronized (genericPreparedStatement) {
                    if (recompile || this.preparedStmt.invalidatedWhileCompiling) {
                        this.preparedStmt.isValid = false;
                        this.preparedStmt.invalidatedWhileCompiling = false;
                        recompile = true;
                    }
                }
                if (recompile) {
                    while (true) {
                        if (lcc.getStatementDepth() <= depth) continue block11;
                        lcc.popStatementContext(lcc.getStatementContext(), null);
                    }
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepMinion(LanguageConnectionContext lcc, boolean cacheMe, Object[] paramDefaults, SchemaDescriptor spsSchema, boolean internalSQL) throws StandardException {
        long beginTime = 0L;
        long parseTime = 0L;
        long bindTime = 0L;
        long optimizeTime = 0L;
        long generateTime = 0L;
        Timestamp beginTimestamp = null;
        Timestamp endTimestamp = null;
        StatementContext statementContext = null;
        if (this.preparedStmt != null && this.preparedStmt.upToDate()) {
            return this.preparedStmt;
        }
        if (lcc.optimizerTracingIsOn()) {
            lcc.getOptimizerTracer().traceStartStatement(this.getSource());
        }
        if ((beginTime = GenericStatement.getCurrentTimeMillis(lcc)) != 0L) {
            beginTimestamp = new Timestamp(beginTime);
        }
        this.prepareIsolationLevel = lcc.getPrepareIsolationLevel();
        boolean foundInCache = false;
        if (this.preparedStmt == null) {
            if (cacheMe) {
                this.preparedStmt = (GenericPreparedStatement)((GenericLanguageConnectionContext)lcc).lookupStatement(this);
            }
            if (this.preparedStmt == null) {
                this.preparedStmt = new GenericPreparedStatement(this);
            } else {
                foundInCache = true;
            }
        }
        GenericPreparedStatement genericPreparedStatement = this.preparedStmt;
        synchronized (genericPreparedStatement) {
            while (true) {
                if (foundInCache && this.preparedStmt.referencesSessionSchema()) {
                    foundInCache = false;
                    this.preparedStmt = new GenericPreparedStatement(this);
                    break;
                }
                if (this.preparedStmt.upToDate()) {
                    return this.preparedStmt;
                }
                if (!this.preparedStmt.isCompiling()) break;
                try {
                    this.preparedStmt.wait();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preparedStmt.beginCompiling();
        }
        try {
            HeaderPrintWriter istream;
            HeaderPrintWriter headerPrintWriter = istream = lcc.getLogStatementText() ? Monitor.getStream() : null;
            if (!this.preparedStmt.isStorable() || lcc.getStatementDepth() == 0) {
                statementContext = lcc.pushStatementContext(true, this.isForReadOnly, this.getSource(), null, false, 0L);
            }
            CompilerContext cc = lcc.pushCompilerContext(this.compilationSchema);
            if (this.prepareIsolationLevel != 0) {
                cc.setScanIsolationLevel(this.prepareIsolationLevel);
            }
            if (internalSQL || spsSchema != null && spsSchema.isSystemSchema() && spsSchema.equals(this.compilationSchema)) {
                cc.setReliability(0);
            }
            try {
                if (istream != null) {
                    String xactId = lcc.getTransactionExecute().getActiveStateTxIdString();
                    istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + "), Begin compiling prepared statement: " + this.getSource() + " :End prepared statement");
                }
                Parser p = cc.getParser();
                cc.setCurrentDependent(this.preparedStmt);
                StatementNode qt = (StatementNode)p.parseStatement(this.statementText, paramDefaults);
                parseTime = GenericStatement.getCurrentTimeMillis(lcc);
                this.walkAST(lcc, qt, 0);
                if (SanityManager.DEBUG_ON("DumpParseTree")) {
                    SanityManager.GET_DEBUG_STREAM().print("\n\n============PARSE===========\n\n");
                    qt.treePrint();
                    lcc.getPrintedObjectsMap().clear();
                }
                if (SanityManager.DEBUG_ON("StopAfterParsing")) {
                    lcc.setLastQueryTree(qt);
                    throw StandardException.newException("42Z55.U", new Object[0]);
                }
                DataDictionary dataDictionary = lcc.getDataDictionary();
                int ddMode = dataDictionary == null ? 0 : dataDictionary.startReading(lcc);
                try {
                    lcc.beginNestedTransaction(true);
                    qt.bindStatement();
                    bindTime = GenericStatement.getCurrentTimeMillis(lcc);
                    this.walkAST(lcc, qt, 1);
                    if (SanityManager.DEBUG_ON("DumpBindTree")) {
                        SanityManager.GET_DEBUG_STREAM().print("\n\n============BIND===========\n\n");
                        qt.treePrint();
                        lcc.getPrintedObjectsMap().clear();
                    }
                    if (SanityManager.DEBUG_ON("StopAfterBinding")) {
                        throw StandardException.newException("42Z56.U", new Object[0]);
                    }
                    if (this.preparedStmt.referencesSessionSchema(qt) && foundInCache) {
                        ((GenericLanguageConnectionContext)lcc).removeStatement(this);
                    }
                    cc.skipTypePrivileges(true);
                    qt.optimizeStatement();
                    optimizeTime = GenericStatement.getCurrentTimeMillis(lcc);
                    this.walkAST(lcc, qt, 2);
                    if (istream != null) {
                        String xactId = lcc.getTransactionExecute().getActiveStateTxIdString();
                        istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + "), End compiling prepared statement: " + this.getSource() + " :End prepared statement");
                    }
                }
                catch (StandardException se) {
                    lcc.commitNestedTransaction();
                    if (istream != null) {
                        String xactId = lcc.getTransactionExecute().getActiveStateTxIdString();
                        istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + "), Error compiling prepared statement: " + this.getSource() + " :End prepared statement");
                    }
                    throw se;
                }
                finally {
                    if (dataDictionary != null) {
                        dataDictionary.doneReading(ddMode, lcc);
                    }
                }
                try {
                    IndexStatisticsDaemon isd;
                    if (SanityManager.DEBUG_ON("DumpOptimizedTree")) {
                        SanityManager.GET_DEBUG_STREAM().print("\n\n============OPT===========\n\n");
                        qt.treePrint();
                        lcc.getPrintedObjectsMap().clear();
                    }
                    if (SanityManager.DEBUG_ON("StopAfterOptimizing")) {
                        throw StandardException.newException("42Z57.U", new Object[0]);
                    }
                    GeneratedClass ac = qt.generate(this.preparedStmt.getByteCodeSaver());
                    generateTime = GenericStatement.getCurrentTimeMillis(lcc);
                    if (generateTime != 0L) {
                        endTimestamp = new Timestamp(generateTime);
                    }
                    if (SanityManager.DEBUG_ON("StopAfterGenerating")) {
                        throw StandardException.newException("42Z58.U", new Object[0]);
                    }
                    this.preparedStmt.setConstantAction(qt.makeConstantAction());
                    this.preparedStmt.setSavedObjects(cc.getSavedObjects());
                    this.preparedStmt.setRequiredPermissionsList(cc.getRequiredPermissionsList());
                    this.preparedStmt.incrementVersionCounter();
                    this.preparedStmt.setActivationClass(ac);
                    this.preparedStmt.setNeedsSavepoint(qt.needsSavepoint());
                    this.preparedStmt.setCursorInfo((CursorInfo)cc.getCursorInfo());
                    this.preparedStmt.setIsAtomic(qt.isAtomic());
                    this.preparedStmt.setExecuteStatementNameAndSchema(qt.executeStatementName(), qt.executeSchemaName());
                    this.preparedStmt.setSPSName(qt.getSPSName());
                    this.preparedStmt.completeCompile(qt);
                    this.preparedStmt.setCompileTimeWarnings(cc.getWarnings());
                    TableDescriptor[] tds = qt.updateIndexStatisticsFor();
                    if (tds.length > 0 && (isd = lcc.getDataDictionary().getIndexStatsRefresher(true)) != null) {
                        for (int i = 0; i < tds.length; ++i) {
                            isd.schedule(tds[i]);
                        }
                    }
                }
                catch (StandardException e) {
                    lcc.commitNestedTransaction();
                    throw e;
                }
                if (lcc.getRunTimeStatisticsMode()) {
                    this.preparedStmt.setCompileTimeMillis(parseTime - beginTime, bindTime - parseTime, optimizeTime - bindTime, generateTime - optimizeTime, generateTime - beginTime, beginTimestamp, endTimestamp);
                }
            }
            finally {
                lcc.popCompilerContext(cc);
            }
        }
        catch (StandardException se) {
            if (foundInCache) {
                ((GenericLanguageConnectionContext)lcc).removeStatement(this);
            }
            throw se;
        }
        finally {
            this.preparedStmt.endCompiling();
        }
        lcc.commitNestedTransaction();
        if (statementContext != null) {
            lcc.popStatementContext(statementContext, null);
        }
        return this.preparedStmt;
    }

    private void walkAST(LanguageConnectionContext lcc, Visitable queryTree, int phase) throws StandardException {
        ASTVisitor visitor = lcc.getASTVisitor();
        if (visitor != null) {
            visitor.begin(this.statementText, phase);
            queryTree.accept(visitor);
            visitor.end(phase);
        }
    }

    @Override
    public PreparedStatement prepareStorable(LanguageConnectionContext lcc, PreparedStatement ps, Object[] paramDefaults, SchemaDescriptor spsSchema, boolean internalSQL) throws StandardException {
        if (ps == null) {
            ps = new GenericStorablePreparedStatement(this);
        } else {
            ((GenericPreparedStatement)ps).statement = this;
        }
        this.preparedStmt = (GenericPreparedStatement)ps;
        return this.prepMinion(lcc, false, paramDefaults, spsSchema, internalSQL);
    }

    @Override
    public String getSource() {
        return this.statementText;
    }

    public String getCompilationSchema() {
        return this.compilationSchema.getDescriptorName();
    }

    private static long getCurrentTimeMillis(LanguageConnectionContext lcc) {
        if (lcc.getStatisticsTiming()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStmt;
    }

    public boolean equals(Object other) {
        if (other instanceof GenericStatement) {
            GenericStatement os = (GenericStatement)other;
            return this.statementText.equals(os.statementText) && this.isForReadOnly == os.isForReadOnly && this.compilationSchema.equals(os.compilationSchema) && this.prepareIsolationLevel == os.prepareIsolationLevel;
        }
        return false;
    }

    public int hashCode() {
        return this.statementText.hashCode();
    }
}

