/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.diag.DiagnosticUtil;
import org.apache.derby.iapi.services.diag.Diagnosticable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.shared.common.sanity.SanityManager;

public class D_LockControl
implements Diagnosticable {
    protected LockControl control;

    @Override
    public void init(Object obj) {
        this.control = (LockControl)obj;
    }

    @Override
    public String diag() throws StandardException {
        List<Lock> granted;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("LockControl:\n  granted list: ");
        int i = 0;
        Lock firstGrant = this.control.getFirstGrant();
        if (firstGrant != null) {
            sb.append("\n    g[" + i + "]:" + DiagnosticUtil.toDiagString(firstGrant));
            ++i;
        }
        if ((granted = this.control.getGranted()) != null) {
            Iterator<Lock> dli = granted.iterator();
            while (dli.hasNext()) {
                sb.append("\n    g[" + i + "]:" + DiagnosticUtil.toDiagString(dli.next()));
                ++i;
            }
        }
        sb.append("\n  waiting list:");
        List<Lock> waiting = this.control.getWaiting();
        int num_waiting = 0;
        if (waiting != null) {
            Iterator<Lock> dli = waiting.iterator();
            while (dli.hasNext()) {
                sb.append("\n    w[" + num_waiting + "]:" + DiagnosticUtil.toDiagString(dli.next()));
                ++num_waiting;
            }
        }
        if (num_waiting == 0) {
            sb.append("    no waiting locks.");
        }
        return sb.toString();
    }

    @Override
    public void diag_detail(Properties prop) {
    }

    static void debugLock(String type, CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier, int timeout) {
        SanityManager.DEBUG("LockTrace", type + D_LockControl.debugLockString(compatibilitySpace, group, ref, qualifier, timeout));
    }

    static void debugLock(String type, CompatibilitySpace compatibilitySpace, Object group) {
        SanityManager.DEBUG("LockTrace", type + D_LockControl.debugLockString(compatibilitySpace, group));
    }

    static void debugLock(String type, CompatibilitySpace compatibilitySpace, Object group, Lockable ref) {
        SanityManager.DEBUG("LockTrace", type + D_LockControl.debugLockString(compatibilitySpace, group, ref));
    }

    static String debugLockString(CompatibilitySpace compatibilitySpace, Object group) {
        StringBuffer sb = new StringBuffer("");
        D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
        D_LockControl.debugAppendObject(sb, " Group=", group);
        D_LockControl.debugAddThreadInfo(sb);
        return sb.toString();
    }

    static String debugLockString(CompatibilitySpace compatibilitySpace, Object group, Lockable ref) {
        StringBuffer sb = new StringBuffer("");
        D_LockControl.debugAppendObject(sb, " Lockable ", ref);
        D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
        D_LockControl.debugAppendObject(sb, " Group=", group);
        D_LockControl.debugAddThreadInfo(sb);
        return sb.toString();
    }

    static String debugLockString(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier, int timeout) {
        StringBuffer sb = new StringBuffer("");
        D_LockControl.debugAppendObject(sb, " Lockable ", ref);
        D_LockControl.debugAppendObject(sb, " Qualifier=", qualifier);
        D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
        D_LockControl.debugAppendObject(sb, " Group=", group);
        if (timeout >= 0) {
            sb.append(" Timeout(ms)=");
            sb.append(timeout);
        }
        D_LockControl.debugAddThreadInfo(sb);
        return sb.toString();
    }

    static void debugAddThreadInfo(StringBuffer sb) {
        if (SanityManager.DEBUG_ON("LockTraceAddThreadInfo")) {
            D_LockControl.debugAppendObject(sb, " Thread=", Thread.currentThread());
        }
    }

    static void debugAppendObject(StringBuffer sb, String desc, Object item) {
        sb.append(desc);
        if (item != null) {
            sb.append(item.toString());
        } else {
            sb.append("<null>");
        }
    }
}

