/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.sanity.SanityManager;

final class StoreStreamClob
implements InternalClob {
    private volatile boolean released = false;
    private final PositionedStoreStream positionedStoreStream;
    private CharacterStreamDescriptor csd;
    private final ConnectionChild conChild;
    private final Object synchronizationObject;
    private UTF8Reader internalReader;
    private FilterReader unclosableInternalReader;

    public StoreStreamClob(CharacterStreamDescriptor csd, ConnectionChild conChild) throws StandardException {
        SanityManager.ASSERT(!csd.isPositionAware());
        try {
            this.positionedStoreStream = new PositionedStoreStream(csd.getStream());
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("40XD0")) {
                throw StandardException.newException("XJ073.S", new Object[0]);
            }
            throw se;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XCL30.S", ioe, "CLOB");
        }
        this.conChild = conChild;
        this.synchronizationObject = conChild.getConnectionSynchronization();
        SanityManager.ASSERT(this.positionedStoreStream.getPosition() == 0L);
        this.csd = new CharacterStreamDescriptor.Builder().copyState(csd).stream(this.positionedStoreStream).positionAware(true).curBytePos(0L).curCharPos(0L).build();
    }

    @Override
    public void release() {
        if (!this.released) {
            if (this.internalReader != null) {
                this.internalReader.close();
            }
            this.positionedStoreStream.closeStream();
            this.released = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCharLength() throws SQLException {
        this.checkIfValid();
        if (this.csd.getCharLength() == 0L) {
            long charLength = 0L;
            Object object = this.synchronizationObject;
            synchronized (object) {
                this.conChild.setupContextStack();
                try {
                    charLength = UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
                }
                catch (Throwable t) {
                    throw StoreStreamClob.noStateChangeLOB(t);
                }
                finally {
                    ConnectionChild.restoreIntrFlagIfSeen(true, this.conChild.getEmbedConnection());
                    this.conChild.restoreContextStack();
                }
            }
            this.csd = new CharacterStreamDescriptor.Builder().copyState(this.csd).charLength(charLength).build();
        }
        return this.csd.getCharLength();
    }

    @Override
    public long getCharLengthIfKnown() {
        this.checkIfValid();
        return this.csd.getCharLength() == 0L ? -1L : this.csd.getCharLength();
    }

    @Override
    public InputStream getRawByteStream() throws IOException, SQLException {
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(this.csd.getDataOffset());
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        return this.positionedStoreStream;
    }

    @Override
    public Reader getReader(long pos) throws IOException, SQLException {
        long skipped;
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(0L);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        UTF8Reader reader = new UTF8Reader(this.csd, this.conChild, this.synchronizationObject);
        for (long leftToSkip = pos - 1L; leftToSkip > 0L; leftToSkip -= skipped) {
            skipped = ((Reader)reader).skip(leftToSkip);
            if (skipped > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return reader;
    }

    @Override
    public Reader getInternalReader(long characterPosition) throws IOException, SQLException {
        if (this.internalReader == null) {
            if (this.positionedStoreStream.getPosition() != 0L) {
                try {
                    this.positionedStoreStream.resetStream();
                }
                catch (StandardException se) {
                    throw Util.generateCsSQLException(se);
                }
            }
            this.internalReader = new UTF8Reader(this.csd, this.conChild, this.synchronizationObject);
            this.unclosableInternalReader = new FilterReader(this.internalReader){

                @Override
                public void close() {
                }
            };
        }
        try {
            this.internalReader.reposition(characterPosition);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        return this.unclosableInternalReader;
    }

    @Override
    public long getUpdateCount() {
        return 0L;
    }

    @Override
    public Writer getWriter(long pos) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    @Override
    public long insertString(String str, long pos) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public void truncate(long newLength) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    private static SQLException noStateChangeLOB(Throwable t) {
        if (t instanceof StandardException && ((StandardException)t).getMessageId().equals("40XD0")) {
            t = StandardException.newException("XJ073.S", new Object[0]);
        }
        return EmbedResultSet.noStateChangeException(t);
    }

    private void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }
}

