/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.DropDatabaseSetup;

public class SupportFilesSetup
extends TestSetup {
    public static final String EXTIN = "extin";
    public static final String EXTINOUT = "extinout";
    public static final String EXTOUT = "extout";
    private String[] readOnly;
    private String[] readWrite;
    private String[] readOnlyTargetFileNames;
    private String[] readWriteTargetFileNames;

    public SupportFilesSetup(Test test) {
        this(test, null, null);
    }

    public SupportFilesSetup(Test test, String[] readOnly) {
        this(test, readOnly, null, null, null);
    }

    public SupportFilesSetup(Test test, String[] readOnly, String[] readWrite) {
        this(test, readOnly, readWrite, null, null);
    }

    public SupportFilesSetup(Test test, String[] readOnly, String[] readWrite, String[] readOnlyTargetFileNames, String[] readWriteTargetFileNames) {
        super(test);
        this.readOnly = readOnly;
        this.readWrite = readWrite;
        this.readOnlyTargetFileNames = readOnlyTargetFileNames;
        this.readWriteTargetFileNames = readWriteTargetFileNames;
    }

    protected void setUp() throws PrivilegedActionException, IOException {
        SupportFilesSetup.privCopyFiles(EXTIN, this.readOnly, this.readOnlyTargetFileNames);
        SupportFilesSetup.privCopyFiles(EXTINOUT, this.readWrite, this.readWriteTargetFileNames);
        SupportFilesSetup.privCopyFiles(EXTOUT, null, null);
    }

    protected void tearDown() {
        DropDatabaseSetup.removeDirectory(EXTIN);
        DropDatabaseSetup.removeDirectory(EXTINOUT);
        DropDatabaseSetup.removeDirectory(EXTOUT);
    }

    public static void privCopyFiles(final String dirName, final String[] resources, final String[] targetNames) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, PrivilegedActionException {
                SupportFilesSetup.copyFiles(dirName, resources, targetNames);
                return null;
            }
        });
    }

    private static void copyFiles(String dirName, String[] resources, String[] targetNames) throws PrivilegedActionException, IOException {
        File dir = new File(dirName);
        dir.mkdir();
        if (resources == null) {
            return;
        }
        for (int i = 0; i < resources.length; ++i) {
            int read;
            String name = "org/apache/derbyTesting/".concat(resources[i]);
            String baseName = targetNames == null ? name.substring(name.lastIndexOf(47) + 1) : targetNames[i];
            URL url = BaseTestCase.getTestResource(name);
            SupportFilesSetup.assertNotNull((String)name, (Object)url);
            InputStream in = BaseTestCase.openTestResource(url);
            File copy = new File(dir, baseName);
            copy.delete();
            FileOutputStream out = new FileOutputStream(copy);
            byte[] buf = new byte[32768];
            while ((read = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, read);
            }
            in.close();
            out.flush();
            ((OutputStream)out).close();
        }
    }

    public static URL getReadOnlyURL(String name) throws MalformedURLException {
        return SupportFilesSetup.getURL(SupportFilesSetup.getReadOnly(name));
    }

    public static URL getReadWriteURL(String name) throws MalformedURLException {
        return SupportFilesSetup.getURL(SupportFilesSetup.getReadWrite(name));
    }

    public static URL getWriteOnlyURL(String name) throws MalformedURLException {
        return SupportFilesSetup.getURL(SupportFilesSetup.getWriteOnly(name));
    }

    public static File getReadOnly(String name) {
        return SupportFilesSetup.getFile(EXTIN, name);
    }

    public static String getReadOnlyFileName(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SupportFilesSetup.getReadOnly(name).getAbsolutePath();
            }
        });
    }

    public static String getReadWriteFileName(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SupportFilesSetup.getReadWrite(name).getAbsolutePath();
            }
        });
    }

    public static File getReadWrite(String name) {
        return SupportFilesSetup.getFile(EXTINOUT, name);
    }

    public static File getWriteOnly(String name) {
        return SupportFilesSetup.getFile(EXTOUT, name);
    }

    private static File getFile(String dirName, String name) {
        File dir = new File(dirName);
        return new File(dir, name);
    }

    private static URL getURL(final File file) throws MalformedURLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return file.toURI().toURL();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getException();
        }
    }

    public static void deleteFile(String fileName) {
        SupportFilesSetup.deleteFile(new File(fileName));
    }

    public static void deleteFile(File file) {
        if (PrivilegedFileOpsForTests.exists(file)) {
            SupportFilesSetup.assertTrue((boolean)PrivilegedFileOpsForTests.delete(file));
        }
    }
}

