/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.pig.tuple.DataToSketch;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.UpdatableSummary;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public abstract class DataToSketchAlgebraicIntermediateFinal<U, S extends UpdatableSummary<U>>
extends EvalFunc<Tuple> {
    private final int sketchSize_;
    private final SummarySetOperations<S> summarySetOps_;
    private final SummaryDeserializer<S> summaryDeserializer_;
    private final UpdatableSketchBuilder<U, S> sketchBuilder_;
    private boolean isFirstCall_ = true;

    public DataToSketchAlgebraicIntermediateFinal(SummaryFactory<S> summaryFactory, SummarySetOperations<S> summarySetOps, SummaryDeserializer<S> summaryDeserializer) {
        this(4096, 1.0f, summaryFactory, summarySetOps, summaryDeserializer);
    }

    public DataToSketchAlgebraicIntermediateFinal(int sketchSize, SummaryFactory<S> summaryFactory, SummarySetOperations<S> summarySetOps, SummaryDeserializer<S> summaryDeserializer) {
        this(sketchSize, 1.0f, summaryFactory, summarySetOps, summaryDeserializer);
    }

    public DataToSketchAlgebraicIntermediateFinal(int sketchSize, float samplingProbability, SummaryFactory<S> summaryFactory, SummarySetOperations<S> summarySetOps, SummaryDeserializer<S> summaryDeserializer) {
        this.sketchSize_ = sketchSize;
        this.summarySetOps_ = summarySetOps;
        this.summaryDeserializer_ = summaryDeserializer;
        this.sketchBuilder_ = new UpdatableSketchBuilder(summaryFactory).setNominalEntries(sketchSize).setSamplingProbability(samplingProbability);
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"algebraic is used");
            this.isFirstCall_ = false;
        }
        Union union = new Union(this.sketchSize_, this.summarySetOps_);
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        for (Tuple dataTuple : bag) {
            Object item = dataTuple.get(0);
            if (item instanceof DataBag) {
                UpdatableSketch sketch = this.sketchBuilder_.build();
                DataToSketch.updateSketch((DataBag)item, sketch);
                union.union((Sketch)sketch);
                continue;
            }
            if (item instanceof DataByteArray) {
                Sketch<S> incomingSketch = Util.deserializeSketchFromTuple(dataTuple, this.summaryDeserializer_);
                union.union(incomingSketch);
                continue;
            }
            throw new IllegalArgumentException("InputTuple.Field0: Bag contains unrecognized types: " + item.getClass().getName());
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(union.getResult().toByteArray()));
    }
}

