/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

abstract class DataToArrayOfDoublesSketchBase
extends EvalFunc<Tuple>
implements Accumulator<Tuple> {
    private final int sketchSize_;
    private final float samplingProbability_;
    private final int numValues_;
    private ArrayOfDoublesUpdatableSketch accumSketch_;
    private boolean isFirstCall_ = true;

    DataToArrayOfDoublesSketchBase() {
        this(4096, 1.0f, 1);
    }

    DataToArrayOfDoublesSketchBase(int numValues) {
        this(4096, 1.0f, numValues);
    }

    DataToArrayOfDoublesSketchBase(int sketchSize, int numValues) {
        this(sketchSize, 1.0f, numValues);
    }

    DataToArrayOfDoublesSketchBase(int sketchSize, float samplingProbability, int numValues) {
        this.sketchSize_ = sketchSize;
        this.samplingProbability_ = samplingProbability;
        this.numValues_ = numValues;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"accumulate is used");
            this.isFirstCall_ = false;
        }
        if (this.accumSketch_ == null) {
            this.accumSketch_ = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(this.sketchSize_).setSamplingProbability(this.samplingProbability_).setNumberOfValues(this.numValues_).build();
        }
        if (inputTuple.size() != 1) {
            throw new IllegalArgumentException("Input tuple must have 1 bag");
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        DataToArrayOfDoublesSketchBase.updateSketch(bag, this.accumSketch_, this.numValues_);
    }

    public void cleanup() {
        this.accumSketch_ = null;
    }

    public Tuple getValue() {
        if (this.accumSketch_ == null) {
            this.accumSketch_ = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(this.sketchSize_).setSamplingProbability(this.samplingProbability_).setNumberOfValues(this.numValues_).build();
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(this.accumSketch_.compact().toByteArray()));
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"exec is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return null;
        }
        if (inputTuple.size() != 1) {
            throw new IllegalArgumentException("Input tuple must have 1 bag");
        }
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(this.sketchSize_).setSamplingProbability(this.samplingProbability_).setNumberOfValues(this.numValues_).build();
        DataBag bag = (DataBag)inputTuple.get(0);
        DataToArrayOfDoublesSketchBase.updateSketch(bag, sketch, this.numValues_);
        return Util.tupleFactory.newTuple((Object)new DataByteArray(sketch.compact().toByteArray()));
    }

    static void updateSketch(DataBag bag, ArrayOfDoublesUpdatableSketch sketch, int numValues) throws ExecException {
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        double[] values = new double[numValues];
        block9: for (Tuple tuple : bag) {
            if (tuple.size() != numValues + 1) {
                throw new IllegalArgumentException("Inner tuple of input bag must have " + (numValues + 1) + " fields.");
            }
            Object key = tuple.get(0);
            if (key == null) continue;
            for (int i = 0; i < numValues; ++i) {
                values[i] = (Double)tuple.get(i + 1);
            }
            switch (tuple.getType(0)) {
                case 6: {
                    sketch.update(((Byte)key).longValue(), values);
                    continue block9;
                }
                case 10: {
                    sketch.update(((Integer)key).longValue(), values);
                    continue block9;
                }
                case 15: {
                    sketch.update(((Long)key).longValue(), values);
                    continue block9;
                }
                case 20: {
                    sketch.update((double)((Float)key).floatValue(), values);
                    continue block9;
                }
                case 25: {
                    sketch.update(((Double)key).doubleValue(), values);
                    continue block9;
                }
                case 50: {
                    DataByteArray dba = (DataByteArray)key;
                    if (dba.size() == 0) continue block9;
                    sketch.update(dba.get(), values);
                    continue block9;
                }
                case 55: {
                    String s = key.toString();
                    if (s.isEmpty()) continue block9;
                    sketch.update(s, values);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Field 0 must be one of NULL, BYTE, INTEGER, LONG, FLOAT, DOUBLE, BYTEARRAY or CHARARRAY. Type = " + DataType.findTypeName((byte)tuple.getType(0)) + ", Object = " + key.toString());
        }
    }
}

