/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;

public class Estimate
extends EvalFunc<Double> {
    private final long seed_;

    public Estimate() {
        this(9001L);
    }

    public Estimate(String seedStr) {
        this(Long.parseLong(seedStr));
    }

    public Estimate(long seed) {
        this.seed_ = seed;
    }

    public Double exec(Tuple sketchTuple) throws IOException {
        if (sketchTuple == null || sketchTuple.size() == 0) {
            return null;
        }
        Sketch sketch = PigUtil.tupleToSketch(sketchTuple, this.seed_);
        return sketch.getEstimate();
    }
}

