/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class DataToSketch
extends EvalFunc<Tuple>
implements Accumulator<Tuple>,
Algebraic {
    private final int nomEntries_;
    private final float p_;
    private final long seed_;
    private final Tuple emptyCompactOrderedSketchTuple_;
    private Union accumUnion_;

    public DataToSketch() {
        this(4096, 1.0f, 9001L);
    }

    public DataToSketch(String nomEntriesStr) {
        this(Integer.parseInt(nomEntriesStr), 1.0f, 9001L);
    }

    public DataToSketch(String nomEntriesStr, String pStr) {
        this(Integer.parseInt(nomEntriesStr), Float.parseFloat(pStr), 9001L);
    }

    public DataToSketch(String nomEntriesStr, String pStr, String seedStr) {
        this(Integer.parseInt(nomEntriesStr), Float.parseFloat(pStr), Long.parseLong(seedStr));
    }

    public DataToSketch(int nomEntries, float p, long seed) {
        this.nomEntries_ = nomEntries;
        this.p_ = p;
        this.seed_ = seed;
        this.emptyCompactOrderedSketchTuple_ = PigUtil.emptySketchTuple(seed);
        Util.checkIfPowerOf2((int)nomEntries, (String)"nomEntries");
        Util.checkProbability((double)p, (String)"p");
        if (nomEntries < 16) {
            throw new IllegalArgumentException("NomEntries too small: " + nomEntries + ", required: " + 16);
        }
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        Union union = DataToSketch.newUnion(this.nomEntries_, this.p_, this.seed_);
        DataBag bag = PigUtil.extractBag(inputTuple);
        if (bag == null) {
            return this.emptyCompactOrderedSketchTuple_;
        }
        DataToSketch.updateUnion(bag, union);
        CompactSketch compOrdSketch = union.getResult(true, null);
        return PigUtil.compactOrderedSketchToTuple(compOrdSketch);
    }

    public Schema outputSchema(Schema input) {
        if (input != null) {
            try {
                Schema tupleSchema = new Schema();
                tupleSchema.add(new Schema.FieldSchema("Sketch", 50));
                return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
            }
            catch (FrontendException frontendException) {
                // empty catch block
            }
        }
        return null;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        DataBag bag;
        if (this.accumUnion_ == null) {
            this.accumUnion_ = DataToSketch.newUnion(this.nomEntries_, this.p_, this.seed_);
        }
        if ((bag = PigUtil.extractBag(inputTuple)) == null) {
            return;
        }
        DataToSketch.updateUnion(bag, this.accumUnion_);
    }

    public Tuple getValue() {
        if (this.accumUnion_ == null) {
            return this.emptyCompactOrderedSketchTuple_;
        }
        CompactSketch compOrdSketch = this.accumUnion_.getResult(true, null);
        return PigUtil.compactOrderedSketchToTuple(compOrdSketch);
    }

    public void cleanup() {
        this.accumUnion_ = null;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return IntermediateFinal.class.getName();
    }

    public String getFinal() {
        return IntermediateFinal.class.getName();
    }

    private static final Union newUnion(int nomEntries, float p, long seed) {
        return SetOperation.builder().setSeed(seed).setP(p).setResizeFactor(PigUtil.RF).setNominalEntries(nomEntries).buildUnion();
    }

    private static void updateUnion(DataBag bag, Union union) {
        block10: for (Tuple innerTuple : bag) {
            Byte type;
            Object f0 = PigUtil.extractFieldAtIndex(innerTuple, 0);
            if (f0 == null || (type = PigUtil.extractTypeAtIndex(innerTuple, 0)) == null) continue;
            switch (type) {
                case 1: {
                    continue block10;
                }
                case 6: {
                    union.update((long)((Byte)f0).byteValue());
                    continue block10;
                }
                case 10: {
                    union.update((long)((Integer)f0).intValue());
                    continue block10;
                }
                case 15: {
                    union.update(((Long)f0).longValue());
                    continue block10;
                }
                case 20: {
                    union.update((double)((Float)f0).floatValue());
                    continue block10;
                }
                case 25: {
                    union.update(((Double)f0).doubleValue());
                    continue block10;
                }
                case 50: {
                    DataByteArray dba = (DataByteArray)f0;
                    union.update(dba.get());
                    continue block10;
                }
                case 55: {
                    union.update(f0.toString());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Field 0 of innerTuple must be one of NULL, BYTE, INTEGER, LONG, FLOAT, DOUBLE, BYTEARRAY or CHARARRAY. Given Type = " + DataType.findTypeName((Object)type) + ", Object = " + f0.toString());
        }
    }

    public static class IntermediateFinal
    extends EvalFunc<Tuple> {
        private final int myNomEntries_;
        private final float myP_;
        private final long mySeed_;
        private final Tuple myEmptyCompactOrderedSketchTuple_;

        public IntermediateFinal() {
            this(Integer.toString(4096), "1.0", Long.toString(9001L));
        }

        public IntermediateFinal(String nomEntriesStr) {
            this(nomEntriesStr, "1.0", Long.toString(9001L));
        }

        public IntermediateFinal(String nomEntriesStr, String pStr) {
            this(nomEntriesStr, pStr, Long.toString(9001L));
        }

        public IntermediateFinal(String nomEntriesStr, String pStr, String seedStr) {
            this(Integer.parseInt(nomEntriesStr), Float.parseFloat(pStr), Long.parseLong(seedStr));
        }

        public IntermediateFinal(int nomEntries, float p, long seed) {
            this.myNomEntries_ = nomEntries;
            this.myP_ = p;
            this.mySeed_ = seed;
            this.myEmptyCompactOrderedSketchTuple_ = PigUtil.emptySketchTuple(seed);
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            Union union = DataToSketch.newUnion(this.myNomEntries_, this.myP_, this.mySeed_);
            DataBag outerBag = PigUtil.extractBag(inputTuple);
            if (outerBag == null) {
                return this.myEmptyCompactOrderedSketchTuple_;
            }
            for (Tuple dataTuple : outerBag) {
                Object f0 = PigUtil.extractFieldAtIndex(dataTuple, 0);
                if (f0 == null) continue;
                if (f0 instanceof DataBag) {
                    DataBag innerBag = (DataBag)f0;
                    if (innerBag.size() == 0L) continue;
                    DataToSketch.updateUnion(innerBag, union);
                    continue;
                }
                if (f0 instanceof DataByteArray) {
                    DataByteArray dba = (DataByteArray)f0;
                    union.union(Memory.wrap((byte[])dba.get()));
                    continue;
                }
                throw new IllegalArgumentException("dataTuple.Field0: Is not a DataByteArray: " + f0.getClass().getName());
            }
            CompactSketch compactSketch = union.getResult(true, null);
            return PigUtil.compactOrderedSketchToTuple(compactSketch);
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Initial() {
            this(Integer.toString(4096), "1.0", Long.toString(9001L));
        }

        public Initial(String nomEntriesStr) {
            this(nomEntriesStr, "1.0", Long.toString(9001L));
        }

        public Initial(String nomEntriesStr, String pStr) {
            this(nomEntriesStr, pStr, Long.toString(9001L));
        }

        public Initial(String nomEntriesStr, String pStr, String seedStr) {
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            return inputTuple;
        }
    }
}

