/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.io.IOException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.kll.GetPmf;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class GetCdf
extends EvalFunc<Tuple> {
    public Tuple exec(Tuple input) throws IOException {
        if (input.size() < 2) {
            throw new IllegalArgumentException("expected two or more inputs: sketch and list of split points");
        }
        if (!(input.get(0) instanceof DataByteArray)) {
            throw new IllegalArgumentException("expected a DataByteArray as a sketch, got " + input.get(0).getClass().getSimpleName());
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])dba.get()));
        float[] splitPoints = new float[input.size() - 1];
        for (int i = 1; i < input.size(); ++i) {
            if (!(input.get(i) instanceof Float)) {
                throw new IllegalArgumentException("expected a float value as a split point, got " + input.get(i).getClass().getSimpleName());
            }
            splitPoints[i - 1] = ((Float)input.get(i)).floatValue();
        }
        double[] cdf = sketch.getCDF(splitPoints);
        if (cdf == null) {
            return null;
        }
        return GetPmf.doubleArrayToTuple(cdf);
    }
}

