/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import java.util.List;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.VarOptSampling;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VarOptSamplingTest {
    static final double EPS = 1.0E-10;
    private static final ArrayOfTuplesSerDe serDe_ = new ArrayOfTuplesSerDe();

    @Test
    public void baseConstructors() {
        VarOptSampling udf = new VarOptSampling();
        Assert.assertNotNull((Object)udf);
        udf = new VarOptSampling("255");
        Assert.assertNotNull((Object)udf);
        udf = new VarOptSampling("123", "0");
        Assert.assertNotNull((Object)udf);
        try {
            new VarOptSampling("-1");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptSampling("-1", "3");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptSampling("10", "-1");
            Assert.fail((String)"Accepted negative weight index");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void algebraicFinalConstructors() {
        VarOptSampling.Final udf = new VarOptSampling.Final();
        Assert.assertNotNull((Object)udf);
        udf = new VarOptSampling.Final("1024");
        Assert.assertNotNull((Object)udf);
        udf = new VarOptSampling.Final("4239", "2");
        Assert.assertNotNull((Object)udf);
        try {
            new VarOptSampling.Final("-1");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptSampling.Final("-1", "3");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptSampling.Final("10", "-1");
            Assert.fail((String)"Accepted negative weight index");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void standardAccumulate() {
        int k = 10;
        VarOptSampling udf = new VarOptSampling(Integer.toString(10), "0");
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        double cumWeight = 0.0;
        try {
            for (int i = 1; i < 10; ++i) {
                Tuple t = TupleFactory.getInstance().newTuple(3);
                t.set(0, (Object)(1.0 * (double)i));
                t.set(1, (Object)i);
                t.set(2, (Object)(-i));
                inputBag.add(t);
                cumWeight += (double)i;
            }
            Tuple inputTuple = TupleFactory.getInstance().newTuple((Object)inputBag);
            Assert.assertNull((Object)udf.getValue());
            udf.accumulate(inputTuple);
            udf.accumulate(inputTuple);
            DataBag result = udf.getValue();
            udf.cleanup();
            Assert.assertNull((Object)udf.getValue());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.size(), (long)10L);
            double cumResultWeight = 0.0;
            for (Tuple weightAndtuple : result) {
                cumResultWeight += ((Double)weightAndtuple.get(0)).doubleValue();
                Tuple sample = (Tuple)weightAndtuple.get(1);
                Assert.assertEquals((int)sample.size(), (int)3);
                int id = (Integer)sample.get(1);
                Assert.assertTrue((id > 0 && id < 10 ? 1 : 0) != 0);
            }
            Assert.assertEquals((double)cumResultWeight, (double)(2.0 * cumWeight), (double)1.0E-10);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void degenerateExecInput() {
        VarOptSampling udf = new VarOptSampling();
        try {
            Assert.assertNull((Object)udf.exec(null));
            Assert.assertNull((Object)udf.exec(TupleFactory.getInstance().newTuple(0)));
            Tuple in = TupleFactory.getInstance().newTuple(1);
            in.set(0, null);
            Assert.assertNull((Object)udf.exec(in));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void algebraicDegenerateInput() {
        try {
            VarOptSampling.Final udf = new VarOptSampling.Final("4");
            DataBag result = udf.exec(null);
            Assert.assertNull((Object)result);
            Tuple inputTuple = TupleFactory.getInstance().newTuple(0);
            result = udf.exec(inputTuple);
            Assert.assertNull((Object)result);
            inputTuple = TupleFactory.getInstance().newTuple(1);
            inputTuple.set(0, null);
            result = udf.exec(inputTuple);
            Assert.assertNull((Object)result);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
    }

    @Test
    public void algebraicFinal() {
        int k = 87;
        int wtIdx = 2;
        VarOptSampling.Final udf = new VarOptSampling.Final(Integer.toString(87), Integer.toString(2));
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)87);
        inputBag.add(TupleFactory.getInstance().newTuple((Object)new DataByteArray(vis.toByteArray((ArrayOfItemsSerDe)serDe_))));
        Tuple inputTuple = TupleFactory.getInstance().newTuple((Object)inputBag);
        try {
            DataBag result = udf.exec(inputTuple);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.size(), (long)0L);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
    }

    @Test
    public void validOutputSchemaTest() throws IOException {
        VarOptSampling udf = new VarOptSampling("5", "1");
        Schema recordSchema = new Schema();
        recordSchema.add(new Schema.FieldSchema("field1", 55));
        recordSchema.add(new Schema.FieldSchema("field2", 25));
        recordSchema.add(new Schema.FieldSchema("field3", 20));
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("record", recordSchema, 110));
        Schema inputSchema = new Schema();
        inputSchema.add(new Schema.FieldSchema("data", tupleSchema, 120));
        Schema output = udf.outputSchema(inputSchema);
        Assert.assertEquals((int)output.size(), (int)1);
        Assert.assertEquals((byte)output.getField((int)0).type, (byte)120);
        List outputFields = output.getField((int)0).schema.getFields();
        Assert.assertEquals((int)outputFields.size(), (int)2);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)0)).alias, (String)"vo_weight");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)0)).type, (byte)25);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)1)).alias, (String)"record");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)1)).type, (byte)110);
        Schema sampleSchema = ((Schema.FieldSchema)outputFields.get((int)1)).schema;
        Assert.assertTrue((boolean)sampleSchema.equals((Object)tupleSchema));
        udf = new VarOptSampling("5", "2");
        output = udf.outputSchema(inputSchema);
        Assert.assertEquals((int)output.size(), (int)1);
        Assert.assertEquals((byte)output.getField((int)0).type, (byte)120);
    }

    @Test
    public void badOutputSchemaTest() throws IOException {
        Schema recordSchema = new Schema();
        recordSchema.add(new Schema.FieldSchema("field1", 55));
        recordSchema.add(new Schema.FieldSchema("field2", 25));
        recordSchema.add(new Schema.FieldSchema("field3", 10));
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("record", recordSchema, 110));
        Schema inputSchema = new Schema();
        inputSchema.add(new Schema.FieldSchema("data", tupleSchema, 120));
        VarOptSampling udf = new VarOptSampling("5", "0");
        try {
            udf.outputSchema(null);
            Assert.fail((String)"Accepted null schema");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            udf.outputSchema(new Schema());
            Assert.fail((String)"Accepted empty schema");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            udf.outputSchema(inputSchema);
            Assert.fail((String)"Accepted non-weight in weightIndex column");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            udf.outputSchema(tupleSchema);
            Assert.fail((String)"Accepted input Tuple instead of DataBag");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

