/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.DataToVarOptSketch;
import org.apache.datasketches.pig.sampling.VarOptCommonAlgebraicTest;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToVarOptSketchTest {
    @Test
    public void checkConstructors() {
        DataToVarOptSketch udf = new DataToVarOptSketch();
        Assert.assertNotNull((Object)udf);
        udf = new DataToVarOptSketch("255");
        Assert.assertNotNull((Object)udf);
        udf = new DataToVarOptSketch("123", "0");
        Assert.assertNotNull((Object)udf);
        try {
            new DataToVarOptSketch("-1");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DataToVarOptSketch("-1", "3");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DataToVarOptSketch("10", "-1");
            Assert.fail((String)"Accepted weight index");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkExecution() {
        int k = 10;
        DataToVarOptSketch udf = new DataToVarOptSketch(Integer.toString(10), "0");
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        try {
            VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)10);
            for (int i = 1; i < 5; ++i) {
                Tuple t = TupleFactory.getInstance().newTuple(3);
                t.set(0, (Object)(1.0 * (double)i));
                t.set(1, (Object)i);
                t.set(2, (Object)(-i));
                inputBag.add(t);
                sketch.update((Object)t, 1.0 * (double)i);
                sketch.update((Object)t, 1.0 * (double)i);
            }
            inputTuple.set(0, (Object)inputBag);
            Assert.assertNull((Object)udf.getValue());
            udf.accumulate(inputTuple);
            udf.accumulate(inputTuple);
            DataByteArray outBytes = udf.getValue();
            udf.cleanup();
            Assert.assertNull((Object)udf.getValue());
            VarOptItemsSketch result = VarOptItemsSketch.heapify((Memory)Memory.wrap((byte[])outBytes.get()), (ArrayOfItemsSerDe)new ArrayOfTuplesSerDe());
            Assert.assertNotNull((Object)result);
            VarOptCommonAlgebraicTest.compareResults((VarOptItemsSketch<Tuple>)result, (VarOptItemsSketch<Tuple>)sketch);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void degenerateExecInput() {
        DataToVarOptSketch udf = new DataToVarOptSketch();
        try {
            Assert.assertNull((Object)udf.exec(null));
            Assert.assertNull((Object)udf.exec(TupleFactory.getInstance().newTuple(0)));
            Tuple in = TupleFactory.getInstance().newTuple(1);
            in.set(0, null);
            Assert.assertNull((Object)udf.exec(in));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void validOutputSchemaTest() throws IOException {
        DataToVarOptSketch udf = new DataToVarOptSketch("5", "1");
        Schema recordSchema = new Schema();
        recordSchema.add(new Schema.FieldSchema("field1", 55));
        recordSchema.add(new Schema.FieldSchema("field2", 25));
        recordSchema.add(new Schema.FieldSchema("field3", 20));
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("record", recordSchema, 110));
        Schema inputSchema = new Schema();
        inputSchema.add(new Schema.FieldSchema("data", tupleSchema, 120));
        Schema output = udf.outputSchema(inputSchema);
        Assert.assertEquals((int)output.size(), (int)1);
        Assert.assertEquals((byte)output.getField((int)0).type, (byte)50);
        udf = new DataToVarOptSketch("5", "2");
        output = udf.outputSchema(inputSchema);
        Assert.assertEquals((int)output.size(), (int)1);
        Assert.assertEquals((byte)output.getField((int)0).type, (byte)50);
    }

    @Test
    public void badOutputSchemaTest() throws IOException {
        Schema recordSchema = new Schema();
        recordSchema.add(new Schema.FieldSchema("field1", 55));
        recordSchema.add(new Schema.FieldSchema("field2", 25));
        recordSchema.add(new Schema.FieldSchema("field3", 10));
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("record", recordSchema, 110));
        Schema inputSchema = new Schema();
        inputSchema.add(new Schema.FieldSchema("data", tupleSchema, 120));
        DataToVarOptSketch udf = new DataToVarOptSketch("5", "0");
        try {
            udf.outputSchema(null);
            Assert.fail((String)"Accepted null schema");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            udf.outputSchema(new Schema());
            Assert.fail((String)"Accepted empty schema");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            udf.outputSchema(inputSchema);
            Assert.fail((String)"Accepted non-weight value in weightIndex column");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            udf.outputSchema(tupleSchema);
            Assert.fail((String)"Accepted Tuple instead of DataBag");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

