/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.count;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesException;
import org.apache.datasketches.count.CountMinSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CountMinSketchTest {
    @Test
    public void createNewCountMinSketchTest() throws Exception {
        Assert.assertThrows(SketchesArgumentException.class, () -> new CountMinSketch(5, 1, 123L));
        Assert.assertThrows(SketchesArgumentException.class, () -> new CountMinSketch(4, 0x10000000, 123L));
        int numHashes = 3;
        int numBuckets = 5;
        long seed = 1234567L;
        CountMinSketch c = new CountMinSketch(3, 5, 1234567L);
        Assert.assertEquals((byte)c.getNumHashes_(), (byte)3);
        Assert.assertEquals((int)c.getNumBuckets_(), (int)5);
        Assert.assertEquals((long)c.getSeed_(), (long)1234567L);
        Assert.assertTrue((boolean)c.isEmpty());
    }

    @Test
    public void parameterSuggestionsTest() {
        Assert.assertThrows((String)"Relative error must be at least 0.", SketchesException.class, () -> CountMinSketch.suggestNumBuckets((double)-1.0));
        Assert.assertEquals((int)CountMinSketch.suggestNumBuckets((double)0.2), (int)14);
        Assert.assertEquals((int)CountMinSketch.suggestNumBuckets((double)0.1), (int)28);
        Assert.assertEquals((int)CountMinSketch.suggestNumBuckets((double)0.05), (int)55);
        Assert.assertEquals((int)CountMinSketch.suggestNumBuckets((double)0.01), (int)272);
        int numHashes = 3;
        long seed = 1234567L;
        Assert.assertTrue((new CountMinSketch(3, 14, 1234567L).getRelativeError() <= 0.2 ? 1 : 0) != 0);
        Assert.assertTrue((new CountMinSketch(3, 28, 1234567L).getRelativeError() <= 0.1 ? 1 : 0) != 0);
        Assert.assertTrue((new CountMinSketch(3, 55, 1234567L).getRelativeError() <= 0.05 ? 1 : 0) != 0);
        Assert.assertTrue((new CountMinSketch(3, 272, 1234567L).getRelativeError() <= 0.01 ? 1 : 0) != 0);
        Assert.assertThrows((String)"Confidence must be between 0 and 1.0 (inclusive).", SketchesException.class, () -> CountMinSketch.suggestNumHashes((double)10.0));
        Assert.assertThrows((String)"Confidence must be between 0 and 1.0 (inclusive).", SketchesException.class, () -> CountMinSketch.suggestNumHashes((double)-1.0));
        Assert.assertEquals((int)CountMinSketch.suggestNumHashes((double)0.682689492), (int)2);
        Assert.assertEquals((int)CountMinSketch.suggestNumHashes((double)0.954499736), (int)4);
        Assert.assertEquals((int)CountMinSketch.suggestNumHashes((double)0.997300204), (int)6);
    }

    @Test
    public void countMinSketchOneUpdateTest() {
        int numHashes = 3;
        int numBuckets = 5;
        long seed = 1234567L;
        long insertedWeights = 0L;
        CountMinSketch c = new CountMinSketch(3, 5, 1234567L);
        String x = "x";
        Assert.assertTrue((boolean)c.isEmpty());
        Assert.assertEquals((long)c.getEstimate("x"), (long)0L);
        c.update("x", 1L);
        Assert.assertFalse((boolean)c.isEmpty());
        Assert.assertEquals((long)c.getEstimate("x"), (long)1L);
        ++insertedWeights;
        long w = 9L;
        c.update("x", 9L);
        Assert.assertEquals((long)c.getEstimate("x"), (long)(insertedWeights += 9L));
        double w1 = 10.0;
        c.update("x", 10L);
        Assert.assertEquals((long)c.getEstimate("x"), (long)(insertedWeights += 10L));
        Assert.assertEquals((long)c.getTotalWeight_(), (long)insertedWeights);
        Assert.assertTrue((c.getEstimate("x") <= c.getUpperBound("x") ? 1 : 0) != 0);
        Assert.assertTrue((c.getEstimate("x") >= c.getLowerBound("x") ? 1 : 0) != 0);
    }

    @Test
    public void frequencyCancellationTest() {
        CountMinSketch c = new CountMinSketch(1, 5, 123456L);
        c.update("x", 1L);
        c.update("y", -1L);
        Assert.assertEquals((long)c.getTotalWeight_(), (long)2L);
        Assert.assertEquals((long)c.getEstimate("x"), (long)1L);
        Assert.assertEquals((long)c.getEstimate("y"), (long)-1L);
    }

    @Test
    public void frequencyEstimates() {
        int numItems = 10;
        long[] data = new long[10];
        long[] frequencies = new long[10];
        for (int i = 0; i < 10; ++i) {
            data[i] = i;
            frequencies[i] = 1L << 10 - i;
        }
        double relativeError = 0.1;
        double confidence = 0.99;
        int numBuckets = CountMinSketch.suggestNumBuckets((double)0.1);
        byte numHashes = CountMinSketch.suggestNumHashes((double)0.99);
        CountMinSketch c = new CountMinSketch(numHashes, numBuckets, 1234567L);
        for (int i = 0; i < 10; ++i) {
            long value = data[i];
            long freq = frequencies[i];
            c.update(value, freq);
        }
        for (long i : data) {
            long est = c.getEstimate(i);
            long upp = c.getUpperBound(i);
            long low = c.getLowerBound(i);
            Assert.assertTrue((est <= upp ? 1 : 0) != 0);
            Assert.assertTrue((est >= low ? 1 : 0) != 0);
        }
    }

    @Test
    public void mergeFailTest() {
        CountMinSketch[] sketches;
        double relativeError = 0.25;
        double confidence = 0.9;
        long seed = 1234567L;
        int numBuckets = CountMinSketch.suggestNumBuckets((double)0.25);
        byte numHashes = CountMinSketch.suggestNumHashes((double)0.9);
        CountMinSketch s = new CountMinSketch(numHashes, numBuckets, 1234567L);
        Assert.assertThrows((String)"Cannot merge a sketch with itself.", SketchesException.class, () -> s.merge(s));
        CountMinSketch s1 = new CountMinSketch((byte)(numHashes + 1), numBuckets, 1234567L);
        CountMinSketch s2 = new CountMinSketch(numHashes, numBuckets + 1, 1234567L);
        CountMinSketch s3 = new CountMinSketch(numHashes, numBuckets, 1234568L);
        for (CountMinSketch sk : sketches = new CountMinSketch[]{s1, s2, s3}) {
            Assert.assertThrows((String)"Incompatible sketch configuration.", SketchesException.class, () -> s.merge(sk));
        }
    }

    @Test
    public void mergeTest() {
        long[] data;
        double relativeError = 0.25;
        double confidence = 0.9;
        long seed = 123456L;
        int numBuckets = CountMinSketch.suggestNumBuckets((double)0.25);
        byte numHashes = CountMinSketch.suggestNumHashes((double)0.9);
        CountMinSketch c = new CountMinSketch(numHashes, numBuckets, 123456L);
        byte sHashes = c.getNumHashes_();
        int sBuckets = c.getNumBuckets_();
        long sSeed = c.getSeed_();
        CountMinSketch s = new CountMinSketch(sHashes, sBuckets, sSeed);
        c.merge(s);
        Assert.assertEquals((long)c.getTotalWeight_(), (long)0L);
        for (long d : data = new long[]{2L, 3L, 5L, 7L}) {
            c.update(d, 1L);
            s.update(d, 1L);
        }
        c.merge(s);
        Assert.assertEquals((long)c.getTotalWeight_(), (long)(2L * s.getTotalWeight_()));
        for (long d : data) {
            Assert.assertTrue((c.getEstimate(d) <= c.getUpperBound(d) ? 1 : 0) != 0);
            Assert.assertTrue((s.getEstimate(d) <= 2L ? 1 : 0) != 0);
        }
    }

    @Test
    public void serializeDeserializeEmptyTest() {
        int numHashes = 3;
        int numBuckets = 32;
        long seed = 123456L;
        CountMinSketch c = new CountMinSketch(3, 32, 123456L);
        byte[] b = c.toByteArray();
        Assert.assertThrows(SketchesArgumentException.class, () -> CountMinSketch.deserialize((byte[])b, (long)123455L));
        CountMinSketch d = CountMinSketch.deserialize((byte[])b, (long)123456L);
        Assert.assertEquals((byte)d.getNumHashes_(), (byte)c.getNumHashes_());
        Assert.assertEquals((int)d.getNumBuckets_(), (int)c.getNumBuckets_());
        Assert.assertEquals((long)d.getSeed_(), (long)c.getSeed_());
        long zero = 0L;
        Assert.assertEquals((long)d.getEstimate(0L), (long)c.getEstimate(0L));
        Assert.assertEquals((long)d.getTotalWeight_(), (long)c.getTotalWeight_());
    }

    @Test
    public void serializeDeserializeTest() {
        int numHashes = 5;
        int numBuckets = 64;
        long seed = 1234456L;
        CountMinSketch c = new CountMinSketch(5, 64, 1234456L);
        for (long i = 0L; i < 10L; ++i) {
            c.update(i, 10L * i * i);
        }
        byte[] b = c.toByteArray();
        Assert.assertThrows(SketchesArgumentException.class, () -> CountMinSketch.deserialize((byte[])b, (long)1234455L));
        CountMinSketch d = CountMinSketch.deserialize((byte[])b, (long)1234456L);
        Assert.assertEquals((byte)d.getNumHashes_(), (byte)c.getNumHashes_());
        Assert.assertEquals((int)d.getNumBuckets_(), (int)c.getNumBuckets_());
        Assert.assertEquals((long)d.getSeed_(), (long)c.getSeed_());
        Assert.assertEquals((long)d.getTotalWeight_(), (long)c.getTotalWeight_());
        for (long i = 0L; i < 10L; ++i) {
            Assert.assertEquals((long)d.getEstimate(i), (long)c.getEstimate(i));
        }
    }
}

