/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsUnion;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

class ItemsUnionState<T>
extends GenericUDAFEvaluator.AbstractAggregationBuffer {
    private final Class<T> clazz_;
    private final Comparator<? super T> comparator_;
    private final ArrayOfItemsSerDe<T> serDe_;
    private ItemsUnion<T> union;

    ItemsUnionState(Class<T> clazz, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        this.clazz_ = clazz;
        this.comparator_ = comparator;
        this.serDe_ = serDe;
    }

    void init(int k) {
        this.union = k > 0 ? ItemsUnion.getInstance(this.clazz_, (int)k, this.comparator_) : ItemsUnion.getInstance(this.clazz_, this.comparator_);
    }

    boolean isInitialized() {
        return this.union != null;
    }

    void update(T value) {
        if (this.union == null) {
            this.union = ItemsUnion.getInstance(this.clazz_, this.comparator_);
        }
        this.union.update(value);
    }

    void update(Memory serializedSketch) {
        ItemsSketch incomingSketch = ItemsSketch.getInstance(this.clazz_, (Memory)serializedSketch, this.comparator_, this.serDe_);
        if (this.union == null) {
            this.union = ItemsUnion.getInstance((ItemsSketch)incomingSketch);
        } else {
            this.union.union(incomingSketch);
        }
    }

    public ItemsSketch<T> getResult() {
        if (this.union == null) {
            return null;
        }
        return this.union.getResultAndReset();
    }

    void reset() {
        this.union = null;
    }
}

