/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.UnionSketchUDF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchUDFTest {
    @Test
    public void evaluateNull() {
        UnionSketchUDF testObject = new UnionSketchUDF();
        BytesWritable intermResult = testObject.evaluate(null, null);
        Memory mem = BytesWritableHelper.wrapAsMemory((BytesWritable)intermResult);
        Sketch testResult = Sketches.wrapSketch((Memory)mem);
        Assert.assertEquals((double)testResult.getEstimate(), (double)0.0);
    }

    @Test
    public void testEvaluateEmpty() {
        UnionSketchUDF testObject = new UnionSketchUDF();
        BytesWritable intermResult = testObject.evaluate(new BytesWritable(), new BytesWritable());
        Memory mem = BytesWritableHelper.wrapAsMemory((BytesWritable)intermResult);
        Sketch testResult = Sketches.wrapSketch((Memory)mem);
        Assert.assertEquals((double)testResult.getEstimate(), (double)0.0);
    }

    @Test
    public void evaluateValidSketch() {
        UnionSketchUDF testObject = new UnionSketchUDF();
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 100; i < 256; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact().toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact().toByteArray());
        BytesWritable output = testObject.evaluate(input1, input2);
        Sketch result = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)output));
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
    }

    @Test
    public void evaluateValidSketchExplicitSizeAndSeed() {
        UnionSketchUDF testObject = new UnionSketchUDF();
        long seed = 1L;
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setSeed(1L).setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setSeed(1L).setNominalEntries(1024).build();
        for (int i = 100; i < 256; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact().toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact().toByteArray());
        BytesWritable output = testObject.evaluate(input1, input2, 128, 1L);
        Sketch result = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)output), (long)1L);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0, (double)5.12);
        Assert.assertTrue(((double)result.getRetainedEntries(true) <= 128.0 ? 1 : 0) != 0);
    }
}

