/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.List;
import org.apache.datasketches.hive.quantiles.GetQuantilesFromDoublesSketchUDF;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantilesFromDoublesSketchUDFTest {
    @Test
    public void nullSketch() {
        List result = new GetQuantilesFromDoublesSketchUDF().evaluate(null, new Double[]{0.0});
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyListOfFractions() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        List result = new GetQuantilesFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Double[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void fractionsNormalCase() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        sketch.update(4.0);
        List result = new GetQuantilesFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Double[]{0.0, 0.5, 1.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)2.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)4.0);
        result = new GetQuantilesFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), new Double[]{0.0, 0.5, 1.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)3.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)4.0);
    }

    @Test
    public void evenlySpacedEmptySketch() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        List result = new GetQuantilesFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), 1);
        Assert.assertNull((Object)result);
    }

    @Test
    public void evenlySpacedZero() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        List result = new GetQuantilesFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), 0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void evenlySpacedNormalCase() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        sketch.update(4.0);
        List result = new GetQuantilesFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), 3);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)2.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)4.0);
        result = new GetQuantilesFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), 3);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)3.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)4.0);
    }
}

