/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.kll.DataToSketchUDAFTest;
import org.apache.datasketches.hive.kll.SketchState;
import org.apache.datasketches.hive.kll.UnionSketchUDAF;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchUDAFTest {
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("a"), Arrays.asList(binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooFewInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategoryArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongTypeArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategoryArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongTypeArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test
    public void partia1ModelDefaultKDowsizeInput() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkResultInspector(resultInspector);
            SketchState state = (SketchState)eval.getNewAggregationBuffer();
            KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)400);
            sketch1.update(1.0f);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray())});
            KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)400);
            sketch2.update(2.0f);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray())});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            KllFloatsSketch resultSketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((double)resultSketch.getNormalizedRankError(false), (double)KllFloatsSketch.getNormalizedRankError((int)200, (boolean)false));
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((float)resultSketch.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)resultSketch.getMaxItem(), (float)2.0f);
        }
    }

    @Test
    public void partia1ModelGivenK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkResultInspector(resultInspector);
            SketchState state = (SketchState)eval.getNewAggregationBuffer();
            KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)400);
            sketch1.update(1.0f);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray()), new IntWritable(400)});
            KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)400);
            sketch2.update(2.0f);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray()), new IntWritable(400)});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            KllFloatsSketch resultSketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((double)resultSketch.getNormalizedRankError(false), (double)KllFloatsSketch.getNormalizedRankError((int)400, (boolean)false));
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((float)resultSketch.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)resultSketch.getMaxItem(), (float)2.0f);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, inspectors);
            DataToSketchUDAFTest.checkResultInspector(resultInspector);
            SketchState state = (SketchState)eval.getNewAggregationBuffer();
            KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)400);
            sketch1.update(1.0f);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray()));
            KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)400);
            sketch2.update(2.0f);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray()));
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            KllFloatsSketch resultSketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((double)resultSketch.getNormalizedRankError(false), (double)KllFloatsSketch.getNormalizedRankError((int)400, (boolean)false));
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((float)resultSketch.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)resultSketch.getMaxItem(), (float)2.0f);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, inspectors);
            DataToSketchUDAFTest.checkResultInspector(resultInspector);
            SketchState state = (SketchState)eval.getNewAggregationBuffer();
            KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)400);
            sketch1.update(1.0f);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray()));
            KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)400);
            sketch2.update(2.0f);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray()));
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            KllFloatsSketch resultSketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((double)resultSketch.getNormalizedRankError(false), (double)KllFloatsSketch.getNormalizedRankError((int)400, (boolean)false));
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((float)resultSketch.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)resultSketch.getMaxItem(), (float)2.0f);
        }
    }

    @Test
    public void completeModelDefaultK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkResultInspector(resultInspector);
            SketchState state = (SketchState)eval.getNewAggregationBuffer();
            KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
            sketch1.update(1.0f);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray())});
            KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance();
            sketch2.update(2.0f);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray())});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            KllFloatsSketch resultSketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((double)resultSketch.getNormalizedRankError(false), (double)KllFloatsSketch.getNormalizedRankError((int)200, (boolean)false));
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((float)resultSketch.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)resultSketch.getMaxItem(), (float)2.0f);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state));
        }
    }
}

