/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.auth;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StaticUserAuthenticatorTest {
    @Test
    public void testAuthenticationRequest() {
        StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator("DOMAIN", "USER", "PWD");
        UserAuthenticationData authenticationData = userAuthenticator.requestAuthentication((UserAuthenticationData.Type[])ArrayUtils.toArray((Object[])new UserAuthenticationData.Type[]{UserAuthenticationData.DOMAIN}));
        Assertions.assertArrayEquals((char[])"DOMAIN".toCharArray(), (char[])authenticationData.getData(UserAuthenticationData.DOMAIN));
        Assertions.assertNull((Object)authenticationData.getData(UserAuthenticationData.USERNAME));
        Assertions.assertNull((Object)authenticationData.getData(UserAuthenticationData.PASSWORD));
        authenticationData = userAuthenticator.requestAuthentication((UserAuthenticationData.Type[])ArrayUtils.toArray((Object[])new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD}));
        Assertions.assertNull((Object)authenticationData.getData(UserAuthenticationData.DOMAIN));
        Assertions.assertArrayEquals((char[])"USER".toCharArray(), (char[])authenticationData.getData(UserAuthenticationData.USERNAME));
        Assertions.assertArrayEquals((char[])"PWD".toCharArray(), (char[])authenticationData.getData(UserAuthenticationData.PASSWORD));
    }

    @Test
    public void testEquality() {
        StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator("DOMAIN", "USER", "PWD");
        Assertions.assertEquals((Object)new StaticUserAuthenticator("DOMAIN", "USER", "PWD"), (Object)userAuthenticator);
        Assertions.assertNotEquals((Object)new StaticUserAuthenticator("DOMAIN", "USER", null), (Object)userAuthenticator);
        Assertions.assertNotEquals((Object)new StaticUserAuthenticator("DOMAIN", null, "PWD"), (Object)userAuthenticator);
        Assertions.assertNotEquals((Object)new StaticUserAuthenticator(null, "USER", "PWD"), (Object)userAuthenticator);
        Assertions.assertEquals((int)new StaticUserAuthenticator("DOMAIN", "USER", "PWD").hashCode(), (int)userAuthenticator.hashCode());
    }
}

