/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.util.Locale;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Http4FilesCacheTest {
    @Test
    public void testQueryStringUrl0() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String noQueryStringUrl = "http4://commons.apache.org/";
        try (FileObject noQueryFile = fileSystemManager.resolveFile("http4://commons.apache.org/");){
            Assertions.assertEquals((Object)"http4://commons.apache.org/", (Object)noQueryFile.getURL().toExternalForm());
        }
    }

    @Test
    public void testQueryStringUrl1() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String noQueryStringUrl = "http4://commons.apache.org/vfs";
        try (FileObject noQueryFile = fileSystemManager.resolveFile("http4://commons.apache.org/vfs");){
            Assertions.assertEquals((Object)"http4://commons.apache.org/vfs", (Object)noQueryFile.getURL().toExternalForm());
        }
    }

    @Test
    public void testQueryStringUrl2() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String queryStringUrl = "http4://commons.apache.org/vfs?query=string";
        try (FileObject queryFile = fileSystemManager.resolveFile("http4://commons.apache.org/vfs?query=string");){
            Assertions.assertEquals((Object)"http4://commons.apache.org/vfs?query=string", (Object)queryFile.getURL().toExternalForm());
        }
    }

    @Test
    public void testQueryStringUrl3() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String queryStringUrl2 = "http4://commons.apache.org/vfs?query=string&more=stuff";
        try (FileObject queryFile2 = fileSystemManager.resolveFile("http4://commons.apache.org/vfs?query=string&more=stuff");){
            Assertions.assertEquals((Object)"http4://commons.apache.org/vfs?query=string&more=stuff", (Object)queryFile2.getURL().toExternalForm());
        }
    }

    @Test
    public void testQueryStringUrl4() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String queryStringUrl3 = "http4://alice%5C1234:secret@localhost:8080/";
        try (FileObject queryFile3 = fileSystemManager.resolveFile("http4://alice%5C1234:secret@localhost:8080/");){
            Assertions.assertEquals((Object)"http4://alice%5C1234:secret@localhost:8080/".toLowerCase(Locale.ROOT), (Object)queryFile3.getURL().toExternalForm());
        }
    }

    @Test
    public void testQueryStringUrl5() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String queryStringUrl4 = "http4://alice%5c1234:secret@localhost:8080/";
        try (FileObject queryFile4 = fileSystemManager.resolveFile("http4://alice%5c1234:secret@localhost:8080/");){
            Assertions.assertEquals((Object)"http4://alice%5c1234:secret@localhost:8080/", (Object)queryFile4.getURL().toExternalForm());
        }
    }

    @Test
    public void testQueryStringUrl6() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String queryStringUrl4 = "http4://alice:secret@localhost:8080/";
        try (FileObject queryFile4 = fileSystemManager.resolveFile("http4://alice:secret@localhost:8080/");){
            Assertions.assertEquals((Object)"http4://alice:secret@localhost:8080/", (Object)queryFile4.getURL().toExternalForm());
        }
    }

    @Test
    public void testQueryStringUrl7() throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        String queryStringUrl4 = "http4://localhost:8080/";
        try (FileObject queryFile4 = fileSystemManager.resolveFile("http4://localhost:8080/");){
            Assertions.assertEquals((Object)"http4://localhost:8080/", (Object)queryFile4.getURL().toExternalForm());
        }
    }
}

