/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class JDOMNamespacePointer
extends NodePointer {
    private static final long serialVersionUID = 7935311686545862379L;
    private final String prefix;
    private String namespaceURI;

    public JDOMNamespacePointer(NodePointer parent, String prefix) {
        super(parent);
        this.prefix = prefix;
    }

    public JDOMNamespacePointer(NodePointer parent, String prefix, String namespaceURI) {
        super(parent);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    @Override
    public String asPath() {
        StringBuilder buffer = new StringBuilder();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append("namespace::");
        buffer.append(this.prefix);
        return buffer.toString();
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JDOMNamespacePointer && this.prefix.equals(((JDOMNamespacePointer)object).prefix);
    }

    @Override
    public Object getBaseValue() {
        return null;
    }

    @Override
    public Object getImmediateNode() {
        return this.getNamespaceURI();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public QName getName() {
        return new QName(this.prefix);
    }

    @Override
    public String getNamespaceURI() {
        if (this.namespaceURI == null) {
            this.namespaceURI = this.parent.getNamespaceURI(this.prefix);
        }
        return this.namespaceURI;
    }

    public int hashCode() {
        return this.prefix.hashCode();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot modify a namespace");
    }
}

