/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynabeans;

import java.util.Locale;
import java.util.Objects;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.ri.model.dynabeans.DynaBeanPropertyPointer;

public class DynaBeanPointer
extends PropertyOwnerPointer {
    private static final long serialVersionUID = -9135052498044877965L;
    private final QName qName;
    private final DynaBean dynaBean;

    public DynaBeanPointer(NodePointer parent, QName qName, DynaBean dynaBean) {
        super(parent);
        this.qName = qName;
        this.dynaBean = dynaBean;
    }

    public DynaBeanPointer(QName qName, DynaBean dynaBean, Locale locale) {
        super(null, locale);
        this.qName = qName;
        this.dynaBean = dynaBean;
    }

    @Override
    public String asPath() {
        return this.parent == null ? "/" : super.asPath();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DynaBeanPointer)) {
            return false;
        }
        DynaBeanPointer other = (DynaBeanPointer)object;
        if (!Objects.equals(this.parent, other.parent) || !Objects.equals(this.qName, other.qName)) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        return iThis == iOther && this.dynaBean == other.dynaBean;
    }

    @Override
    public Object getBaseValue() {
        return this.dynaBean;
    }

    @Override
    public Object getImmediateNode() {
        return this.dynaBean;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public QName getName() {
        return this.qName;
    }

    @Override
    public PropertyPointer getPropertyPointer() {
        return new DynaBeanPropertyPointer((NodePointer)this, this.dynaBean);
    }

    public int hashCode() {
        return this.qName == null ? 0 : this.qName.hashCode();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

