/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.LexicalScope;
import org.apache.commons.jexl3.internal.Script;
import org.junit.Assert;
import org.junit.Test;

public class LexicalTest {
    @Test
    public void testLexical0a() throws Exception {
        this.runLexical0(false);
    }

    @Test
    public void testLexical0b() throws Exception {
        this.runLexical0(true);
    }

    void runLexical0(boolean feature) throws Exception {
        String string;
        JexlScript script;
        JexlFeatures f = new JexlFeatures();
        f.lexical(feature);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setLexical(true);
        try {
            script = jexl.createScript("var x = 0; var x = 1;");
            if (!feature) {
                script.execute((JexlContext)ctxt);
            }
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        try {
            script = jexl.createScript("var x = 0; for(var y : null) { var y = 1;");
            if (!feature) {
                script.execute((JexlContext)ctxt);
            }
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        try {
            script = jexl.createScript("var x = 0; for(var x : null) {};");
            if (!feature) {
                script.execute((JexlContext)ctxt);
            }
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        try {
            script = jexl.createScript("(x)->{ var x = 0; x; }");
            if (!feature) {
                script.execute((JexlContext)ctxt);
            }
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        try {
            script = jexl.createScript("var x; if (true) { if (true) { var x = 0; x; } }");
            if (!feature) {
                script.execute((JexlContext)ctxt);
            }
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        try {
            script = jexl.createScript("if (a) { var y = (x)->{ var x = 0; x; }; y(2) }", new String[]{"a"});
            if (!feature) {
                script.execute((JexlContext)ctxt);
            }
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        try {
            script = jexl.createScript("(x)->{ for(var x : null) { x; } }");
            if (!feature) {
                script.execute((JexlContext)ctxt, new Object[]{42});
            }
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        script = jexl.createScript("var x = 32; (()->{ for(var x : null) { x; }})();");
        if (!feature) {
            script.execute((JexlContext)ctxt, new Object[]{42});
        }
    }

    @Test
    public void testLexical1a() throws Exception {
        this.runLexical1(false);
    }

    @Test
    public void testLexical1b() throws Exception {
        this.runLexical1(true);
    }

    void runLexical1(boolean shade) throws Exception {
        block16: {
            JexlScript script;
            JexlEvalContext ctxt;
            JexlEngine jexl;
            block15: {
                block14: {
                    block13: {
                        jexl = new JexlBuilder().strict(true).create();
                        ctxt = new JexlEvalContext();
                        ctxt.set("x", 4242);
                        JexlOptions options = ctxt.getEngineOptions();
                        options.setLexical(true);
                        options.setLexicalShade(shade);
                        try {
                            script = jexl.createScript("{ var x = 0; } x");
                            script.execute((JexlContext)ctxt);
                            if (shade) {
                                Assert.fail((String)"local shade means 'x' should be undefined");
                            }
                        }
                        catch (JexlException xany) {
                            if (shade) break block13;
                            throw xany;
                        }
                    }
                    try {
                        script = jexl.createScript("{ var x = 0; } x = 42");
                        script.execute((JexlContext)ctxt);
                        if (shade) {
                            Assert.fail((String)"local shade means 'x = 42' should be undefined");
                        }
                    }
                    catch (JexlException xany) {
                        if (shade) break block14;
                        throw xany;
                    }
                }
                try {
                    script = jexl.createScript("{ var x = 0; } y = 42");
                    script.execute((JexlContext)ctxt);
                    if (shade) {
                        Assert.fail((String)"local shade means 'y = 42' should be undefined (y is undefined)");
                    }
                }
                catch (JexlException xany) {
                    if (shade) break block15;
                    throw xany;
                }
            }
            script = jexl.createScript("var x = 32; (()->{ for(var x : null) { x; }})();");
            script.execute((JexlContext)ctxt, new Object[]{42});
            ctxt.set("y", 4242);
            try {
                script = jexl.createScript("{ var y = 0; } y = 42");
                Object result = script.execute((JexlContext)ctxt);
                if (!shade) {
                    Assert.assertEquals((Object)42, (Object)result);
                } else {
                    Assert.fail((String)"local shade means 'y = 42' should be undefined");
                }
            }
            catch (JexlException xany) {
                if (shade) break block16;
                throw xany;
            }
        }
    }

    @Test
    public void testLexical1() throws Exception {
        String string;
        Object result;
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setLexical(true);
        JexlScript script = jexl.createScript("var x = 0; for(var y : [1]) { var x = 42; return x; };");
        try {
            result = script.execute((JexlContext)ctxt);
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        try {
            script = jexl.createScript("(x)->{ if (x) { var x = 7 * (x + x); x; } }");
            result = script.execute((JexlContext)ctxt, new Object[]{3});
            Assert.fail();
        }
        catch (JexlException xany) {
            string = xany.toString();
        }
        script = jexl.createScript("{ var x = 0; } var x = 42; x");
        result = script.execute((JexlContext)ctxt, new Object[]{21});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLexical2a() throws Exception {
        this.runLexical2(true);
    }

    @Test
    public void testLexical2b() throws Exception {
        this.runLexical2(false);
    }

    protected void runLexical2(boolean lexical) throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(lexical).create();
        MapContext ctxt = new MapContext();
        JexlScript script = jexl.createScript("{var x = 42}; {var x; return x; }");
        Object result = script.execute((JexlContext)ctxt);
        if (lexical) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)42, (Object)result);
        }
    }

    @Test
    public void testLexical3() throws Exception {
        String str = "var s = {}; for (var i : [1]) s.add(i); s";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        JexlScript e = jexl.createScript("var s = {}; for (var i : [1]) s.add(i); s");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertTrue((boolean)((Set)o).contains(1));
        e = jexl.createScript("var s = {}; for (var i : [1]) s.add(i); s");
        o = e.execute((JexlContext)jc);
        Assert.assertTrue((boolean)((Set)o).contains(1));
    }

    @Test
    public void testLexical4() throws Exception {
        JexlEngine Jexl2 = new JexlBuilder().silent(false).strict(true).lexical(true).create();
        JxltEngine Jxlt = Jexl2.createJxltEngine();
        MapContext ctxt = new MapContext();
        String rpt = "<report>\n\n$$var y = 1; var x = 2;\n${x + y}\n</report>\n";
        JxltEngine.Template t = Jxlt.createTemplate("$$", (Reader)new StringReader("<report>\n\n$$var y = 1; var x = 2;\n${x + y}\n</report>\n"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctxt, (Writer)strw);
        String output = strw.toString();
        String ctl = "<report>\n\n3\n</report>\n";
        Assert.assertEquals((Object)"<report>\n\n3\n</report>\n", (Object)output);
    }

    @Test
    public void testLexical5() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        DebugContext ctxt = new DebugContext();
        JexlScript script = jexl.createScript("var x = 42; var y = () -> { {var x = debug(-42); }; return x; }; y()");
        try {
            Object result = script.execute((JexlContext)ctxt);
            Assert.assertEquals((Object)42, (Object)result);
        }
        catch (JexlException xany) {
            String ww = xany.toString();
            Assert.fail((String)ww);
        }
    }

    @Test
    public void testLexical6a() throws Exception {
        String str = "i = 0; { var i = 32; }; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        JexlScript e = jexl.createScript("i = 0; { var i = 32; }; i");
        MapContext ctxt = new MapContext();
        Object o = e.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)0, (Object)o);
    }

    @Test
    public void testLexical6b() throws Exception {
        String str = "i = 0; { var i = 32; }; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).lexicalShade(true).create();
        JexlScript e = jexl.createScript("i = 0; { var i = 32; }; i");
        MapContext ctxt = new MapContext();
        try {
            Object o = e.execute((JexlContext)ctxt);
            Assert.fail((String)"i should be shaded");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    @Test
    public void testLexical6c() throws Exception {
        String str = "i = 0; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).lexicalShade(false).create();
        JexlScript e = jexl.createScript("i = 0; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        Object o = e.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)0, (Object)o);
    }

    @Test
    public void testLexical6d() throws Exception {
        String str = "i = 0; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).lexicalShade(true).create();
        JexlScript e = jexl.createScript("i = 0; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        try {
            Object o = e.execute((JexlContext)ctxt);
            Assert.fail((String)"i should be shaded");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    @Test
    public void testPragmaOptions() throws Exception {
        String str = "#pragma jexl.options '+strict +lexical +lexicalShade -safe'\ni = 0; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().strict(false).create();
        JexlScript e = jexl.createScript("#pragma jexl.options '+strict +lexical +lexicalShade -safe'\ni = 0; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        try {
            Object o = e.execute((JexlContext)ctxt);
            Assert.fail((String)"i should be shaded");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    @Test
    public void testPragmaNoop() throws Exception {
        String str = "#pragma jexl.options 'no effect'\ni = -42; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().lexical(false).strict(true).create();
        JexlScript e = jexl.createScript("#pragma jexl.options 'no effect'\ni = -42; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        Object result = e.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testScopeFrame() throws Exception {
        int i;
        LexicalScope scope = new LexicalScope();
        for (i = 0; i < 128; i += 2) {
            Assert.assertTrue((boolean)scope.addSymbol(i));
            Assert.assertFalse((boolean)scope.addSymbol(i));
        }
        for (i = 0; i < 128; i += 2) {
            Assert.assertTrue((boolean)scope.hasSymbol(i));
            Assert.assertFalse((boolean)scope.hasSymbol(i + 1));
        }
    }

    @Test
    public void testContextualOptions0() throws Exception {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().features(f).strict(true).create();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSharedInstance(false);
        options.setLexical(true);
        options.setLexicalShade(true);
        ctxt.set("options", options);
        JexlScript script = jexl.createScript("{var x = 42;} options.lexical = false; options.lexicalShade=false; x");
        try {
            Object result = script.execute((JexlContext)ctxt);
            Assert.fail((String)"setting options.lexical should have no effect during execution");
        }
        catch (JexlException xf) {
            Assert.assertNotNull((Object)((Object)xf));
        }
    }

    @Test
    public void testContextualOptions1() throws Exception {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().features(f).strict(true).create();
        TestContext ctxt = new TestContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSharedInstance(true);
        options.setLexical(true);
        options.setLexicalShade(true);
        ctxt.set("options", options);
        JexlScript runner = jexl.createScript("options.lexical = flag; options.lexicalShade = flag;tryCatch(test, catch, 42);", new String[]{"flag", "test", "catch"});
        JexlScript tested = jexl.createScript("(y)->{ {var x = y;} x }");
        JexlScript catchFn = jexl.createScript("(xany)-> { xany }");
        Object result = runner.execute((JexlContext)ctxt, new Object[]{false, tested, catchFn});
        Assert.assertEquals((Object)42, (Object)result);
        result = runner.execute((JexlContext)ctxt, new Object[]{true, tested, catchFn});
        Assert.assertTrue((boolean)(result instanceof JexlException.Variable));
    }

    @Test
    public void testParameter0() throws Exception {
        String str = "function(u) {}";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("function(u) {}");
        Assert.assertEquals((long)1L, (long)e.getParameters().length);
        e = jexl.createScript(new JexlInfo("TestScript", 1, 1), "function(u) {}", new String[0]);
        Assert.assertEquals((long)1L, (long)e.getParameters().length);
    }

    @Test
    public void testParameter1() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        MapContext jc = new MapContext();
        String strs = "var s = function(x) { for (var i : 1..3) {if (i > 2) return x}}; s(42)";
        JexlScript s42 = jexl.createScript("var s = function(x) { for (var i : 1..3) {if (i > 2) return x}}; s(42)");
        Object result = s42.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testInnerAccess0() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("var x = 32; (()->{ for(var x : null) { var c = 0; {return x; }} })();");
        Assert.assertNull((Object)script.execute(null));
    }

    @Test
    public void testInnerAccess1() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        JexlScript script = jexl.createScript("var x = 32; (()->{ for(var x : null) { var c = 0; {return x; }} })();");
    }

    @Test
    public void testForVariable0() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        try {
            JexlScript script = jexl.createScript("for(var x : 1..3) { var c = 0}; return x");
            Assert.fail((String)"Should not have been parsed");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void testForVariable1() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        try {
            JexlScript script = jexl.createScript("for(var x : 1..3) { var c = 0} for(var x : 1..3) { var c = 0}; return x");
            Assert.fail((String)"Should not have been parsed");
        }
        catch (JexlException ex) {
            Assert.assertTrue((boolean)(ex instanceof JexlException));
        }
    }

    @Test
    public void testUndeclaredVariable() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        try {
            JexlScript script = jexl.createScript("{var x = 0}; return x");
            Assert.fail((String)"Should not have been parsed");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof JexlException));
        }
    }

    @Test
    public void testLexical6a1() throws Exception {
        String str = "i = 0; { var i = 32; }; i";
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript e = jexl.createScript("i = 0; { var i = 32; }; i");
        MapContext ctxt = new MapContext();
        Object o = e.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)0, (Object)o);
    }

    @Test
    public void testInternalLexicalFeatures() throws Exception {
        String str = "42";
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = new JexlBuilder().features(f).create();
        JexlScript e = jexl.createScript("42");
        VarContext vars = new VarContext();
        JexlOptions opts = vars.getEngineOptions();
        opts.setSharedInstance(true);
        Script script = (Script)e;
        JexlFeatures features = script.getFeatures();
        Assert.assertTrue((boolean)features.isLexical());
        Assert.assertTrue((boolean)features.isLexicalShade());
        Object result = e.execute((JexlContext)vars);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)opts.isLexical());
        Assert.assertTrue((boolean)opts.isLexicalShade());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptionsPragma() throws Exception {
        try {
            JexlOptions.setDefaultFlags((String[])new String[]{"+safe", "-lexical", "-lexicalShade"});
            VarContext vars = new VarContext();
            JexlEngine jexl = new JexlBuilder().create();
            int n42 = (Integer)jexl.createScript("#pragma jexl.options none\n-42").execute((JexlContext)vars);
            Assert.assertEquals((long)-42L, (long)n42);
            JexlOptions o = vars.snatchOptions();
            Assert.assertNotNull((Object)o);
            Assert.assertTrue((boolean)o.isStrict());
            Assert.assertTrue((boolean)o.isSafe());
            Assert.assertTrue((boolean)o.isCancellable());
            Assert.assertFalse((boolean)o.isLexical());
            Assert.assertFalse((boolean)o.isLexicalShade());
            n42 = (Integer)jexl.createScript("#pragma jexl.options canonical\n42").execute((JexlContext)vars);
            Assert.assertEquals((long)42L, (long)n42);
            o = vars.snatchOptions();
            Assert.assertNotNull((Object)o);
            Assert.assertTrue((boolean)o.isStrict());
            Assert.assertFalse((boolean)o.isSafe());
            Assert.assertTrue((boolean)o.isCancellable());
            Assert.assertTrue((boolean)o.isLexical());
            Assert.assertTrue((boolean)o.isLexicalShade());
            Assert.assertFalse((boolean)o.isSharedInstance());
        }
        catch (Throwable throwable) {
            JexlOptions.setDefaultFlags((String[])new String[]{"-safe", "+lexical"});
            throw throwable;
        }
        JexlOptions.setDefaultFlags((String[])new String[]{"-safe", "+lexical"});
    }

    @Test
    public void testVarLoop0() throws Exception {
        String src0 = "var count = 10;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n}";
        String src1 = "var count = [0,1,2,3,4,5,6,7,8,9];\nfor (var i : count) {\n  $out.add(i);\n}";
        String src2 = "var count = 10;\n  var outer = 0;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n  outer = i;}\nouter == 9";
        JexlFeatures ff0 = this.runVarLoop(false, "var count = 10;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n}");
        JexlFeatures ft0 = this.runVarLoop(true, "var count = 10;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n}");
        JexlFeatures ff1 = this.runVarLoop(false, "var count = [0,1,2,3,4,5,6,7,8,9];\nfor (var i : count) {\n  $out.add(i);\n}");
        JexlFeatures ft1 = this.runVarLoop(true, "var count = [0,1,2,3,4,5,6,7,8,9];\nfor (var i : count) {\n  $out.add(i);\n}");
        JexlFeatures ff2 = this.runVarLoop(false, "var count = 10;\n  var outer = 0;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n  outer = i;}\nouter == 9");
        JexlFeatures ft2 = this.runVarLoop(true, "var count = 10;\n  var outer = 0;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n  outer = i;}\nouter == 9");
        Assert.assertEquals((Object)ff0, (Object)ff1);
        Assert.assertEquals((Object)ft0, (Object)ft1);
        Assert.assertNotEquals((Object)ff0, (Object)ft0);
        String sff0 = ff0.toString();
        String sff1 = ff1.toString();
        Assert.assertEquals((Object)sff0, (Object)sff1);
        String sft1 = ft1.toString();
        Assert.assertNotEquals((Object)sff0, (Object)sft1);
    }

    private JexlFeatures runVarLoop(boolean flag, String src) throws Exception {
        VarContext vars = new VarContext();
        JexlOptions options = vars.getEngineOptions();
        options.setLexical(true);
        options.setLexicalShade(true);
        options.setSafe(false);
        JexlFeatures features = new JexlFeatures();
        if (flag) {
            features.lexical(true).lexicalShade(true);
        }
        JexlEngine jexl = new JexlBuilder().features(features).create();
        JexlScript script = jexl.createScript(src);
        ArrayList out = new ArrayList(10);
        vars.set("$out", out);
        Object result = script.execute((JexlContext)vars);
        Assert.assertEquals((Object)true, (Object)result);
        Assert.assertEquals((long)10L, (long)out.size());
        return features;
    }

    @Test
    public void testAnnotation() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("@scale(13) @test var i = 42");
        OptAnnotationContext jc = new OptAnnotationContext();
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNamed() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("var i = (x, y, z)->{return x + y + z}; i(22,18,2)");
        MapContext jc = new MapContext();
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void tesstCaptured0() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("var x = 10; (b->{ x + b })(32)");
        MapContext jc = new MapContext();
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCaptured1() throws Exception {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("{var x = 10; } (b->{ x + b })(32)");
        MapContext jc = new MapContext();
        jc.set("x", (Object)11);
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)43, (Object)result);
    }

    public static class OptAnnotationContext
    extends JexlEvalContext
    implements JexlContext.AnnotationProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            if ("scale".equals(name)) {
                JexlOptions options = this.getEngineOptions();
                int scale = options.getMathScale();
                int newScale = (Integer)args[0];
                options.setMathScale(newScale);
                try {
                    Object object = statement.call();
                    return object;
                }
                finally {
                    options.setMathScale(scale);
                }
            }
            return statement.call();
        }
    }

    public static class VarContext
    extends MapContext
    implements JexlContext.PragmaProcessor,
    JexlContext.OptionsHandle {
        private JexlOptions options = new JexlOptions();

        JexlOptions snatchOptions() {
            JexlOptions o = this.options;
            this.options = new JexlOptions();
            return o;
        }

        public void processPragma(String key, Object value) {
            if ("jexl.options".equals(key) && "canonical".equals(value)) {
                this.options.setStrict(true);
                this.options.setLexical(true);
                this.options.setLexicalShade(true);
                this.options.setSafe(false);
            }
        }

        public JexlOptions getEngineOptions() {
            return this.options;
        }
    }

    public static class TestContext
    extends JexlEvalContext {
        public TestContext() {
        }

        public TestContext(Map<String, Object> map) {
            super(map);
        }

        public Object tryCatch(JexlScript tryFn, JexlScript catchFn, Object ... args) {
            Object result;
            try {
                result = tryFn.execute((JexlContext)this, args);
            }
            catch (Throwable xthrow) {
                result = catchFn != null ? catchFn.execute((JexlContext)this, new Object[]{xthrow}) : xthrow;
            }
            return result;
        }
    }

    public static class DebugContext
    extends MapContext {
        public Object debug(Object arg) {
            return arg;
        }
    }
}

