/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.Foo;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class ForEachTest
extends JexlTestCase {
    public ForEachTest(String name) {
        super(name);
    }

    public void testForEachWithEmptyStatement() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list) ;");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertNull((String)"Result is not null", (Object)o);
    }

    public void testForEachWithEmptyList() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list) 1+1");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertNull((String)"Result is not null", (Object)o);
    }

    public void testForEachWithArray() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Object[]{"Hello", "World"});
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    public void testForEachWithCollection() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", Arrays.asList("Hello", "World"));
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    public void testForEachWithEnumeration() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new StringTokenizer("Hello,World", ","));
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    public void testForEachWithIterator() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", Arrays.asList("Hello", "World").iterator());
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    public void testForEachWithMap() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list) item");
        MapContext jc = new MapContext();
        Properties map = System.getProperties();
        String lastProperty = (String)new ArrayList(map.values()).get(System.getProperties().size() - 1);
        jc.set("list", (Object)map);
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)lastProperty, (Object)o);
    }

    public void testForEachWithBlock() throws Exception {
        Expression exs0 = this.JEXL.createExpression("for(in : list) { x = x + in; }");
        Expression exs1 = this.JEXL.createExpression("foreach(item in list) { x = x + item; }");
        Expression[] exs = new Expression[]{exs0, exs1};
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Object[]{"2", "3"});
        for (int ex = 0; ex < exs.length; ++ex) {
            jc.set("x", (Object)new Integer(1));
            Object o = exs[ex].evaluate((JexlContext)jc);
            ForEachTest.assertEquals((String)"Result is wrong", (Object)new Integer(6), (Object)o);
            ForEachTest.assertEquals((String)"x is wrong", (Object)new Integer(6), (Object)jc.get("x"));
        }
    }

    public void testForEachWithListExpression() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list.keySet()) item");
        MapContext jc = new MapContext();
        Properties map = System.getProperties();
        String lastKey = (String)new ArrayList(map.keySet()).get(System.getProperties().size() - 1);
        jc.set("list", (Object)map);
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)lastKey, (Object)o);
    }

    public void testForEachWithProperty() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list.cheeseList) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)"brie", (Object)o);
    }

    public void testForEachWithIteratorMethod() throws Exception {
        Expression e = this.JEXL.createExpression("for(item : list.cheezy) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.evaluate((JexlContext)jc);
        ForEachTest.assertEquals((String)"Result is not last evaluated expression", (Object)"brie", (Object)o);
    }
}

