/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jci.AbstractTestCase;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.classes.ExtendedDump;
import org.apache.commons.jci.classes.SimpleDump;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.listeners.CompilingListener;
import org.apache.commons.jci.listeners.ReloadNotificationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.problems.CompilationProblemHandler;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.utils.ConversionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CompilingClassLoaderTestCase
extends AbstractTestCase {
    private final Log log = LogFactory.getLog(CompilingClassLoaderTestCase.class);
    private ReloadingClassLoader classloader;
    private CompilingListener listener;
    private FilesystemAlterationMonitor fam;

    protected void setUp() throws Exception {
        super.setUp();
        this.classloader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.listener = new CompilingListener((JavaCompiler)new MockJavaCompiler());
        this.listener.addReloadNotificationListener((ReloadNotificationListener)this.classloader);
        this.fam = new FilesystemAlterationMonitor();
        this.fam.addListener(this.directory, (FilesystemAlterationListener)this.listener);
        this.fam.start();
    }

    private void initialCompile() throws Exception {
        this.log.debug((Object)"initial compile");
        this.listener.waitForFirstCheck();
        this.writeFile("jci/Simple.java", "Simple1");
        this.writeFile("jci/Extended.java", "Extended");
        this.log.debug((Object)"waiting for compile changes to get applied");
        this.listener.waitForCheck();
        this.log.debug((Object)"*** ready to test");
    }

    public void testCreate() throws Exception {
        this.initialCompile();
        this.log.debug((Object)"loading Simple");
        Object simple = this.classloader.loadClass("jci.Simple").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple.toString());
        this.log.debug((Object)"loading Extended");
        Object extended = this.classloader.loadClass("jci.Extended").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Extended:Simple1", (String)extended.toString());
    }

    public void testChange() throws Exception {
        this.initialCompile();
        Object simple = this.classloader.loadClass("jci.Simple").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple.toString());
        Object extended = this.classloader.loadClass("jci.Extended").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Extended:Simple1", (String)extended.toString());
        this.delay();
        this.writeFile("jci/Simple.java", "Simple2");
        this.listener.waitForCheck();
        Object simple2 = this.classloader.loadClass("jci.Simple").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Simple2", (String)simple2.toString());
        Object newExtended = this.classloader.loadClass("jci.Extended").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Extended:Simple2", (String)newExtended.toString());
    }

    public void testDelete() throws Exception {
        this.initialCompile();
        Object simple = this.classloader.loadClass("jci.Simple").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple.toString());
        Object extended = this.classloader.loadClass("jci.Extended").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Extended:Simple1", (String)extended.toString());
        this.listener.waitForCheck();
        this.log.debug((Object)"deleting source file");
        CompilingClassLoaderTestCase.assertTrue((boolean)new File(this.directory, "jci/Extended.java").delete());
        this.listener.waitForCheck();
        this.log.debug((Object)"loading Simple");
        Object oldSimple = this.classloader.loadClass("jci.Simple").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Simple1", (String)oldSimple.toString());
        this.log.debug((Object)"trying to loading Extended");
        try {
            this.classloader.loadClass("jci.Extended").newInstance();
            CompilingClassLoaderTestCase.fail();
        }
        catch (ClassNotFoundException e) {
            CompilingClassLoaderTestCase.assertEquals((String)"jci.Extended", (String)e.getMessage());
        }
        this.log.debug((Object)"deleting whole directory");
        FileUtils.deleteDirectory((File)new File(this.directory, "jci"));
        this.listener.waitForCheck();
        this.log.debug((Object)"trying to loading Simple");
        try {
            this.classloader.loadClass("jci.Simple").newInstance();
            CompilingClassLoaderTestCase.fail();
        }
        catch (ClassNotFoundException e) {
            CompilingClassLoaderTestCase.assertEquals((String)"jci.Simple", (String)e.getMessage());
        }
    }

    public void testDeleteDependency() throws Exception {
        this.initialCompile();
        Object simple = this.classloader.loadClass("jci.Simple").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple.toString());
        Object extended = this.classloader.loadClass("jci.Extended").newInstance();
        CompilingClassLoaderTestCase.assertEquals((String)"Extended:Simple1", (String)extended.toString());
        this.log.debug((Object)"deleting source file");
        CompilingClassLoaderTestCase.assertTrue((boolean)new File(this.directory, "jci/Simple.java").delete());
        this.listener.waitForCheck();
        this.log.debug((Object)"trying to load dependend class");
        try {
            this.classloader.loadClass("jci.Extended").newInstance();
            CompilingClassLoaderTestCase.fail();
        }
        catch (NoClassDefFoundError e) {
            CompilingClassLoaderTestCase.assertEquals((String)"jci/Simple", (String)e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        this.fam.removeListener((FilesystemAlterationListener)this.listener);
        this.fam.stop();
        super.tearDown();
    }

    private static final class MockJavaCompiler
    implements JavaCompiler {
        private final Log log = LogFactory.getLog(MockJavaCompiler.class);

        private MockJavaCompiler() {
        }

        public CompilationResult compile(String[] pResourcePaths, ResourceReader pReader, ResourceStore pStore, ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
            for (int i = 0; i < pResourcePaths.length; ++i) {
                byte[] data;
                String resourcePath = pResourcePaths[i];
                byte[] resourceContent = pReader.getBytes(resourcePath);
                this.log.debug((Object)("resource " + resourcePath + " = " + (resourceContent != null ? new String(resourceContent) : null)));
                if ("jci/Simple.java".equals(resourcePath)) {
                    try {
                        data = SimpleDump.dump(new String(resourceContent));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("cannot handle resource " + resourcePath, e);
                    }
                } else if ("jci/Extended.java".equals(resourcePath)) {
                    try {
                        data = ExtendedDump.dump();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("cannot handle resource " + resourcePath, e);
                    }
                } else {
                    throw new RuntimeException("cannot handle resource " + resourcePath);
                }
                this.log.debug((Object)("compiling " + resourcePath + " (" + data.length + ")"));
                pStore.write(ConversionUtils.stripExtension((String)resourcePath) + ".class", data);
            }
            return new CompilationResult(new CompilationProblem[0]);
        }

        public CompilationResult compile(String[] pResourcePaths, ResourceReader pReader, ResourceStore pStore, ClassLoader pClassLoader) {
            return this.compile(pResourcePaths, pReader, pStore, pClassLoader, null);
        }

        public CompilationResult compile(String[] pResourcePaths, ResourceReader pReader, ResourceStore pStore) {
            return this.compile(pResourcePaths, pReader, pStore, null);
        }

        public void setCompilationProblemHandler(CompilationProblemHandler pHandler) {
        }

        public JavaCompilerSettings createDefaultSettings() {
            return null;
        }
    }
}

