/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed;

import java.util.Collection;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.io.core.BoundaryIOManager;
import org.apache.commons.geometry.io.core.GeometryFormat;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.output.GeometryOutput;
import org.apache.commons.geometry.io.euclidean.threed.BoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.BoundaryWriteHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.obj.ObjBoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.obj.ObjBoundaryWriteHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlBoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlBoundaryWriteHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.txt.CsvBoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.txt.CsvBoundaryWriteHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.txt.TextBoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.txt.TextBoundaryWriteHandler3D;
import org.apache.commons.numbers.core.Precision;

public class BoundaryIOManager3D
extends BoundaryIOManager<PlaneConvexSubset, BoundarySource3D, BoundaryReadHandler3D, BoundaryWriteHandler3D> {
    public FacetDefinitionReader facetDefinitionReader(GeometryInput in, GeometryFormat fmt) {
        return ((BoundaryReadHandler3D)this.requireReadHandler(in, fmt)).facetDefinitionReader(in);
    }

    public Stream<FacetDefinition> facets(GeometryInput in, GeometryFormat fmt) {
        return ((BoundaryReadHandler3D)this.requireReadHandler(in, fmt)).facets(in);
    }

    public Stream<Triangle3D> triangles(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return this.boundaries(in, fmt, precision).flatMap(p -> p.toTriangles().stream());
    }

    public TriangleMesh readTriangleMesh(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return ((BoundaryReadHandler3D)this.requireReadHandler(in, fmt)).readTriangleMesh(in, precision);
    }

    public void write(Stream<? extends PlaneConvexSubset> boundaries, GeometryOutput out, GeometryFormat fmt) {
        ((BoundaryWriteHandler3D)this.requireWriteHandler(out, fmt)).write(boundaries, out);
    }

    public void writeFacets(Stream<? extends FacetDefinition> facets, GeometryOutput out, GeometryFormat fmt) {
        ((BoundaryWriteHandler3D)this.requireWriteHandler(out, fmt)).writeFacets(facets, out);
    }

    public void writeFacets(Collection<? extends FacetDefinition> facets, GeometryOutput out, GeometryFormat fmt) {
        ((BoundaryWriteHandler3D)this.requireWriteHandler(out, fmt)).writeFacets(facets, out);
    }

    public void registerDefaultHandlers() {
        this.registerReadHandler(new ObjBoundaryReadHandler3D());
        this.registerWriteHandler(new ObjBoundaryWriteHandler3D());
        this.registerReadHandler(new StlBoundaryReadHandler3D());
        this.registerWriteHandler(new StlBoundaryWriteHandler3D());
        this.registerReadHandler(new TextBoundaryReadHandler3D());
        this.registerWriteHandler(new TextBoundaryWriteHandler3D());
        this.registerReadHandler(new CsvBoundaryReadHandler3D());
        this.registerWriteHandler(new CsvBoundaryWriteHandler3D());
    }
}

