/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.util.Iterator;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.junit.Assert;
import org.junit.Test;

public class FileItemHeadersTest {
    @Test
    public void testFileItemHeaders() throws Exception {
        FileItemHeadersImpl aMutableFileItemHeaders = new FileItemHeadersImpl();
        aMutableFileItemHeaders.addHeader("Content-Disposition", "form-data; name=\"FileItem\"; filename=\"file1.txt\"");
        aMutableFileItemHeaders.addHeader("Content-Type", "text/plain");
        aMutableFileItemHeaders.addHeader("TestHeader", "headerValue1");
        aMutableFileItemHeaders.addHeader("TestHeader", "headerValue2");
        aMutableFileItemHeaders.addHeader("TestHeader", "headerValue3");
        aMutableFileItemHeaders.addHeader("testheader", "headerValue4");
        Iterator headerNameEnumeration = aMutableFileItemHeaders.getHeaderNames();
        Assert.assertEquals((Object)"content-disposition", headerNameEnumeration.next());
        Assert.assertEquals((Object)"content-type", headerNameEnumeration.next());
        Assert.assertEquals((Object)"testheader", headerNameEnumeration.next());
        Assert.assertFalse((boolean)headerNameEnumeration.hasNext());
        Assert.assertEquals((Object)aMutableFileItemHeaders.getHeader("Content-Disposition"), (Object)"form-data; name=\"FileItem\"; filename=\"file1.txt\"");
        Assert.assertEquals((Object)aMutableFileItemHeaders.getHeader("Content-Type"), (Object)"text/plain");
        Assert.assertEquals((Object)aMutableFileItemHeaders.getHeader("content-type"), (Object)"text/plain");
        Assert.assertEquals((Object)aMutableFileItemHeaders.getHeader("TestHeader"), (Object)"headerValue1");
        Assert.assertNull((Object)aMutableFileItemHeaders.getHeader("DummyHeader"));
        Iterator headerValueEnumeration = aMutableFileItemHeaders.getHeaders("Content-Type");
        Assert.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assert.assertEquals(headerValueEnumeration.next(), (Object)"text/plain");
        Assert.assertFalse((boolean)headerValueEnumeration.hasNext());
        headerValueEnumeration = aMutableFileItemHeaders.getHeaders("content-type");
        Assert.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assert.assertEquals(headerValueEnumeration.next(), (Object)"text/plain");
        Assert.assertFalse((boolean)headerValueEnumeration.hasNext());
        headerValueEnumeration = aMutableFileItemHeaders.getHeaders("TestHeader");
        Assert.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assert.assertEquals(headerValueEnumeration.next(), (Object)"headerValue1");
        Assert.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assert.assertEquals(headerValueEnumeration.next(), (Object)"headerValue2");
        Assert.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assert.assertEquals(headerValueEnumeration.next(), (Object)"headerValue3");
        Assert.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assert.assertEquals(headerValueEnumeration.next(), (Object)"headerValue4");
        Assert.assertFalse((boolean)headerValueEnumeration.hasNext());
        headerValueEnumeration = aMutableFileItemHeaders.getHeaders("DummyHeader");
        Assert.assertFalse((boolean)headerValueEnumeration.hasNext());
    }
}

