/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.ResultSetIterator;
import org.junit.Test;
import org.mockito.Mockito;

public class ResultSetIteratorTest
extends BaseTestCase {
    @Test
    public void testCreatesResultSetIteratorTakingThreeArgumentsAndCallsRemove() {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetIterator resultSetIterator = new ResultSetIterator(resultSet, null);
        resultSetIterator.remove();
    }

    public void testNext() {
        ResultSetIterator iter = new ResultSetIterator(this.rs);
        ResultSetIteratorTest.assertTrue((boolean)iter.hasNext());
        Object[] row = (Object[])iter.next();
        ResultSetIteratorTest.assertEquals((int)COLS, (int)row.length);
        ResultSetIteratorTest.assertEquals((Object)"1", (Object)row[0]);
        ResultSetIteratorTest.assertEquals((Object)"2", (Object)row[1]);
        ResultSetIteratorTest.assertEquals((Object)"THREE", (Object)row[2]);
        ResultSetIteratorTest.assertTrue((boolean)iter.hasNext());
        row = (Object[])iter.next();
        ResultSetIteratorTest.assertEquals((int)COLS, (int)row.length);
        ResultSetIteratorTest.assertEquals((Object)"4", (Object)row[0]);
        ResultSetIteratorTest.assertEquals((Object)"5", (Object)row[1]);
        ResultSetIteratorTest.assertEquals((Object)"SIX", (Object)row[2]);
        ResultSetIteratorTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRethrowThrowsRuntimeException() {
        ResultSetIterator resultSetIterator = new ResultSetIterator((ResultSet)null);
        Throwable throwable = new Throwable();
        SQLException sQLException = new SQLException(throwable);
        try {
            resultSetIterator.rethrow(sQLException);
            ResultSetIteratorTest.fail((String)"Expecting exception: RuntimeException");
        }
        catch (RuntimeException e) {
            ResultSetIteratorTest.assertEquals((String)ResultSetIterator.class.getName(), (String)e.getStackTrace()[0].getClassName());
        }
    }
}

