/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class NodeLabel
implements Comparable<NodeLabel> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String DEFAULT_NODE_LABEL_PARTITION = "<DEFAULT_PARTITION>";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String NODE_LABEL_EXPRESSION_NOT_SET = "<Not set>";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final boolean DEFAULT_NODE_LABEL_EXCLUSIVITY = true;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static NodeLabel newInstance(String name) {
        return NodeLabel.newInstance(name, true);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static NodeLabel newInstance(String name, boolean isExclusive) {
        NodeLabel request = Records.newRecord(NodeLabel.class);
        request.setName(name);
        request.setExclusivity(isExclusive);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract boolean isExclusive();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setExclusivity(boolean var1);

    @Override
    public int compareTo(NodeLabel other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeLabel) {
            NodeLabel nl = (NodeLabel)obj;
            return nl.getName().equals(this.getName()) && nl.isExclusive() == this.isExclusive();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.getName());
        sb.append(":exclusivity=");
        sb.append(this.isExclusive());
        sb.append(">");
        return sb.toString();
    }

    public int hashCode() {
        return (this.getName().hashCode() << 16) + (this.isExclusive() ? 1 : 0);
    }
}

