/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.write;

import java.util.ArrayList;
import org.apache.celeborn.common.protocol.PartitionLocation;

public class DataBatches {
    private int totalSize = 0;
    private ArrayList<DataBatch> batches = new ArrayList();

    public synchronized void addDataBatch(PartitionLocation loc, int batchId, byte[] body) {
        DataBatch dataBatch = new DataBatch(loc, batchId, body);
        this.batches.add(dataBatch);
        this.totalSize += body.length;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public ArrayList<DataBatch> requireBatches() {
        this.totalSize = 0;
        ArrayList<DataBatch> allBatches = this.batches;
        this.batches = null;
        return allBatches;
    }

    public ArrayList<DataBatch> requireBatches(int requestSize) {
        if (requestSize >= this.totalSize) {
            this.totalSize = 0;
            return this.batches;
        }
        ArrayList<DataBatch> retBatches = new ArrayList<DataBatch>();
        int currentSize = 0;
        while (currentSize < requestSize) {
            DataBatch elem = this.batches.remove(0);
            retBatches.add(elem);
            currentSize += elem.body.length;
            this.totalSize -= elem.body.length;
        }
        return retBatches;
    }

    public static class DataBatch {
        public final PartitionLocation loc;
        public final int batchId;
        public final byte[] body;

        public DataBatch(PartitionLocation loc, int batchId, byte[] body) {
            this.loc = loc;
            this.batchId = batchId;
            this.body = body;
        }
    }
}

