/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.celeborn.common.network.protocol.Encoders;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.apache.celeborn.common.network.protocol.StreamChunkSlice;

public final class ChunkFetchFailure
extends ResponseMessage {
    public final StreamChunkSlice streamChunkSlice;
    public final String errorString;

    public ChunkFetchFailure(StreamChunkSlice streamChunkSlice, String errorString) {
        this.streamChunkSlice = streamChunkSlice;
        this.errorString = errorString;
    }

    @Override
    public Message.Type type() {
        return Message.Type.CHUNK_FETCH_FAILURE;
    }

    @Override
    public int encodedLength() {
        return this.streamChunkSlice.encodedLength() + Encoders.Strings.encodedLength(this.errorString);
    }

    @Override
    public void encode(ByteBuf buf) {
        this.streamChunkSlice.encode(buf);
        Encoders.Strings.encode(buf, this.errorString);
    }

    public static ChunkFetchFailure decode(ByteBuf buf) {
        StreamChunkSlice streamChunkSlice = StreamChunkSlice.decode(buf);
        String errorString = Encoders.Strings.decode(buf);
        return new ChunkFetchFailure(streamChunkSlice, errorString);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.streamChunkSlice, this.errorString});
    }

    public boolean equals(Object other) {
        if (other instanceof ChunkFetchFailure) {
            ChunkFetchFailure o = (ChunkFetchFailure)other;
            return this.streamChunkSlice.equals(o.streamChunkSlice) && this.errorString.equals(o.errorString);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("streamChunkId", (Object)this.streamChunkSlice).add("errorString", (Object)this.errorString).toString();
    }
}

