/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.jwk;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.ECKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.JWK;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.OctetSequenceKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.PasswordLookup;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.RSAKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.DefaultResourceRetriever;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.IOUtils;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.JSONObjectUtils;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Resource;
import org.apache.hadoop.shaded.net.minidev.json.JSONArray;
import org.apache.hadoop.shaded.net.minidev.json.JSONObject;

public class JWKSet {
    public static final String MIME_TYPE = "application/jwk-set+json; charset=UTF-8";
    private final List<JWK> keys = new LinkedList<JWK>();
    private final Map<String, Object> customMembers = new HashMap<String, Object>();

    public JWKSet() {
    }

    public JWKSet(JWK key) {
        if (key == null) {
            throw new IllegalArgumentException("The JWK must not be null");
        }
        this.keys.add(key);
    }

    public JWKSet(List<JWK> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys);
    }

    public JWKSet(List<JWK> keys, Map<String, Object> customMembers) {
        if (keys == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys);
        this.customMembers.putAll(customMembers);
    }

    public List<JWK> getKeys() {
        return this.keys;
    }

    public JWK getKeyByKeyId(String kid) {
        for (JWK key : this.getKeys()) {
            if (key.getKeyID() == null || !key.getKeyID().equals(kid)) continue;
            return key;
        }
        return null;
    }

    public Map<String, Object> getAdditionalMembers() {
        return this.customMembers;
    }

    public JWKSet toPublicJWKSet() {
        LinkedList<JWK> publicKeyList = new LinkedList<JWK>();
        for (JWK key : this.keys) {
            JWK publicKey = key.toPublicJWK();
            if (publicKey == null) continue;
            publicKeyList.add(publicKey);
        }
        return new JWKSet(publicKeyList, this.customMembers);
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean publicKeysOnly) {
        JSONObject o = new JSONObject(this.customMembers);
        JSONArray a = new JSONArray();
        for (JWK key : this.keys) {
            if (publicKeysOnly) {
                JWK publicKey = key.toPublicJWK();
                if (publicKey == null) continue;
                a.add(publicKey.toJSONObject());
                continue;
            }
            a.add(key.toJSONObject());
        }
        o.put("keys", a);
        return o;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWKSet parse(String s2) throws ParseException {
        return JWKSet.parse(JSONObjectUtils.parse(s2));
    }

    public static JWKSet parse(JSONObject json) throws ParseException {
        JSONArray keyArray = JSONObjectUtils.getJSONArray(json, "keys");
        LinkedList<JWK> keys = new LinkedList<JWK>();
        int i = 0;
        while (i < keyArray.size()) {
            if (!(keyArray.get(i) instanceof JSONObject)) {
                throw new ParseException("The \"keys\" JSON array must contain JSON objects only", 0);
            }
            JSONObject keyJSON = (JSONObject)keyArray.get(i);
            try {
                keys.add(JWK.parse(keyJSON));
            }
            catch (ParseException e) {
                throw new ParseException("Invalid JWK at position " + i + ": " + e.getMessage(), 0);
            }
            ++i;
        }
        JWKSet jwkSet = new JWKSet(keys);
        for (Map.Entry entry : json.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equals("keys")) continue;
            jwkSet.getAdditionalMembers().put((String)entry.getKey(), entry.getValue());
        }
        return jwkSet;
    }

    public static JWKSet load(File file) throws IOException, ParseException {
        return JWKSet.parse(IOUtils.readFileToString(file, Charset.forName("UTF-8")));
    }

    public static JWKSet load(URL url, int connectTimeout, int readTimeout, int sizeLimit) throws IOException, ParseException {
        DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(connectTimeout, readTimeout, sizeLimit);
        Resource resource = resourceRetriever.retrieveResource(url);
        return JWKSet.parse(resource.getContent());
    }

    public static JWKSet load(URL url) throws IOException, ParseException {
        return JWKSet.load(url, 0, 0, 0);
    }

    public static JWKSet load(KeyStore keyStore, PasswordLookup pwLookup) throws KeyStoreException {
        char[] keyPassword;
        String keyAlias;
        LinkedList<JWK> jwks = new LinkedList<JWK>();
        Enumeration<String> keyAliases = keyStore.aliases();
        while (keyAliases.hasMoreElements()) {
            ECKey ecJWK;
            keyAlias = keyAliases.nextElement();
            keyPassword = pwLookup == null ? "".toCharArray() : pwLookup.lookupPassword(keyAlias);
            Certificate cert = keyStore.getCertificate(keyAlias);
            if (cert == null) continue;
            if (cert.getPublicKey() instanceof RSAPublicKey) {
                RSAKey rsaJWK;
                try {
                    rsaJWK = RSAKey.load(keyStore, keyAlias, keyPassword);
                }
                catch (JOSEException jOSEException) {
                    continue;
                }
                if (rsaJWK == null) continue;
                jwks.add(rsaJWK);
                continue;
            }
            if (!(cert.getPublicKey() instanceof ECPublicKey)) continue;
            try {
                ecJWK = ECKey.load(keyStore, keyAlias, keyPassword);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (ecJWK == null) continue;
            jwks.add(ecJWK);
        }
        keyAliases = keyStore.aliases();
        while (keyAliases.hasMoreElements()) {
            OctetSequenceKey octJWK;
            keyAlias = keyAliases.nextElement();
            keyPassword = pwLookup == null ? "".toCharArray() : pwLookup.lookupPassword(keyAlias);
            try {
                octJWK = OctetSequenceKey.load(keyStore, keyAlias, keyPassword);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (octJWK == null) continue;
            jwks.add(octJWK);
        }
        return new JWKSet(jwks);
    }
}

