/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AuthUtils {
    public static final String CASSANDRA_ROLES_ATTRIBUTE_NAME = "cassandra_roles";
    private static final JsonArray EMPTY_JSON_ARRAY = new JsonArray();

    public static List<String> extractIdentities(User user) {
        String identitiesString;
        JsonObject principal = user.principal();
        if (principal == null) {
            return Collections.emptyList();
        }
        ArrayList<String> identities = new ArrayList<String>();
        String identity = principal.getString("identity");
        if (identity != null) {
            identities.add(identity);
        }
        if ((identitiesString = user.principal().getString("identities")) != null) {
            String[] parts = identitiesString.split(",");
            identities.addAll(Arrays.asList(parts));
        }
        return Collections.unmodifiableList(identities);
    }

    public static List<String> extractCassandraRoles(User user) {
        return Objects.requireNonNullElse(user.attributes().getJsonArray(CASSANDRA_ROLES_ATTRIBUTE_NAME), EMPTY_JSON_ARRAY).getList();
    }
}

