/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.vertx.core.Future;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.exceptions.InsufficientStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFileSystemUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncFileSystemUtils.class);

    private AsyncFileSystemUtils() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static Future<FileStoreProps> fileStoreProps(String path, TaskExecutorPool executorPool) {
        return executorPool.executeBlocking(() -> {
            try {
                Path currentPath;
                for (currentPath = Paths.get(path, new String[0]); currentPath != null && !Files.exists(currentPath, new LinkOption[0]); currentPath = currentPath.getParent()) {
                }
                FileStore fs = Files.getFileStore(currentPath);
                return new FileStoreProps(fs.name(), fs.getTotalSpace(), fs.getUsableSpace(), fs.getUnallocatedSpace());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the belonging file store of path: " + path, e);
            }
        });
    }

    public static Future<Void> ensureSufficientStorage(String path, double requiredUsablePercentage, TaskExecutorPool executorPool) {
        return AsyncFileSystemUtils.ensureSufficientStorage(path, 0L, requiredUsablePercentage, executorPool);
    }

    public static Future<Void> ensureSufficientStorage(String path, long requestedSpace, double requiredUsablePercentage, TaskExecutorPool executorPool) {
        return AsyncFileSystemUtils.fileStoreProps(path, executorPool).map(props -> {
            if (props.usableSpace > props.totalSpace) {
                LOGGER.error("Invalid file store state. fileStore={} path={} available={} total={}", new Object[]{props.name, path, props.usableSpace, props.totalSpace});
                throw new IllegalStateException("FileStore has less total space than usable space. FileStore: " + props.name + ", total space: " + props.totalSpace + ", usable space: " + props.usableSpace);
            }
            return props;
        }).compose(props -> {
            long deductedUsableSpace = props.usableSpace - requestedSpace;
            long requiredUsableSpace = (long)Math.ceil((double)props.totalSpace * requiredUsablePercentage);
            if (deductedUsableSpace < requiredUsableSpace) {
                LOGGER.error("Insufficient space available. fileStore={} path={} available={} requested={} required={}", new Object[]{props.name, path, props.usableSpace, requestedSpace, requiredUsableSpace});
                return Future.failedFuture((Throwable)new InsufficientStorageException(props.name, path, props.totalSpace, props.usableSpace, requiredUsableSpace));
            }
            return Future.succeededFuture();
        });
    }

    public static class FileStoreProps {
        public final String name;
        public final long totalSpace;
        public final long usableSpace;
        public final long unallocatedSpace;

        public FileStoreProps(String name, long totalSpace, long usableSpace, long unallocatedSpace) {
            this.name = name;
            this.totalSpace = totalSpace;
            this.usableSpace = usableSpace;
            this.unallocatedSpace = unallocatedSpace;
        }
    }
}

