/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.SchemaReportingConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.datahub.SchemaReporter;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.apache.cassandra.sidecar.utils.EventBusUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaReportingTask
implements PeriodicTask,
ExecuteOnClusterLeaseholderOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaReportingTask.class);
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();
    @NotNull
    protected final SchemaReportingConfiguration configuration;
    @NotNull
    protected final CQLSessionProvider session;
    @NotNull
    protected final SchemaReporter reporter;
    @NotNull
    protected final TaskExecutorPool executor;

    public SchemaReportingTask(@NotNull SidecarConfiguration configuration, @NotNull CQLSessionProvider session, @NotNull SchemaReporter reporter, @NotNull TaskExecutorPool executor) {
        this.configuration = configuration.schemaReportingConfiguration();
        this.session = session;
        this.reporter = reporter;
        this.executor = executor;
    }

    @Override
    public void deploy(@NotNull Vertx vertx, @NotNull PeriodicTaskExecutor executor) {
        EventBusUtils.onceLocalConsumer(vertx.eventBus(), SidecarServerEvents.ON_CASSANDRA_CQL_READY.address(), message -> executor.schedule(this));
    }

    @Override
    public ScheduleDecision scheduleDecision() {
        return this.configuration.enabled() ? ScheduleDecision.EXECUTE : ScheduleDecision.SKIP;
    }

    @Override
    public DurationSpec initialDelay() {
        return new MillisecondBoundConfiguration(RANDOM.nextLong(this.configuration.initialDelay().toMillis()), TimeUnit.MILLISECONDS);
    }

    @Override
    public DurationSpec delay() {
        return this.configuration.executeInterval();
    }

    @Override
    public void execute(@NotNull Promise<Void> promise) {
        LOGGER.info("Schema report is being triggered by the schedule");
        this.execute(promise, 1);
    }

    protected void execute(@NotNull Promise<Void> promise, int attempt) {
        try {
            this.reporter.processScheduled(this.session.get().getCluster());
            LOGGER.info("Schema report has been completed successfully on attempt {}", (Object)attempt);
            promise.complete();
        }
        catch (Throwable throwable) {
            if (attempt < this.configuration.maxRetries()) {
                LOGGER.warn("Schema report has failed, retrying in {}", (Object)this.configuration.retryDelay(), (Object)throwable);
                this.executor.setTimer(this.configuration.retryDelay().toMillis(), (Handler<Long>)((Handler)identifier -> this.execute(promise, attempt + 1)));
            }
            LOGGER.error("Schema report has failed {} times, giving up", (Object)attempt, (Object)throwable);
            promise.fail(throwable);
        }
    }
}

