/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.DataResourceScope;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScope;
import org.apache.cassandra.sidecar.common.utils.StringUtils;

public class ResourceScopes {
    public static final ResourceScope NO_SCOPE = new ResourceScope(){

        @Override
        public String variableAwareResource() {
            return null;
        }

        @Override
        public String resolveWithResource(String resource) {
            return resource;
        }

        @Override
        public Set<String> expandedResources() {
            return Set.of();
        }
    };
    public static final ResourceScope CLUSTER_SCOPE = new ResourceScope(){

        @Override
        public String variableAwareResource() {
            return "cluster";
        }

        @Override
        public String resolveWithResource(String resource) {
            ResourceScopes.validate(resource);
            return "cluster";
        }

        @Override
        public Set<String> expandedResources() {
            return Set.of(this.variableAwareResource());
        }
    };
    public static final ResourceScope OPERATION_SCOPE = new ResourceScope(){

        @Override
        public String variableAwareResource() {
            return "operation";
        }

        @Override
        public String resolveWithResource(String resource) {
            ResourceScopes.validate(resource);
            return "operation";
        }

        @Override
        public Set<String> expandedResources() {
            return Set.of(this.variableAwareResource());
        }
    };
    public static final ResourceScope DATA_SCOPE = DataResourceScope.DATA_SCOPE;
    public static final ResourceScope KEYSPACE_SCOPE = DataResourceScope.KEYSPACE_SCOPE;
    public static final ResourceScope TABLE_SCOPE = DataResourceScope.TABLE_SCOPE;

    private static void validate(String resource) {
        if (StringUtils.isNullOrEmpty((String)resource)) {
            throw new IllegalArgumentException("Resource expected for resolving");
        }
    }
}

