/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.mailsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelMailsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_HOST_CONF = "camel.kamelet.mail-sink.connectionHost";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_HOST_DOC = "The mail server host Example: smtp.gmail.com";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_PORT_CONF = "camel.kamelet.mail-sink.connectionPort";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_PORT_DOC = "The mail server port";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_PORT_DEFAULT = "25";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_USERNAME_CONF = "camel.kamelet.mail-sink.username";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_USERNAME_DOC = "The username to access the mail box";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_MAILSINK_KAMELET_PASSWORD_CONF = "camel.kamelet.mail-sink.password";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_PASSWORD_DOC = "The password to access the mail box";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_MAILSINK_KAMELET_FROM_CONF = "camel.kamelet.mail-sink.from";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_FROM_DOC = "The `from` field of the outgoing mail";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_FROM_DEFAULT = null;
    public static final String CAMEL_SINK_MAILSINK_KAMELET_TO_CONF = "camel.kamelet.mail-sink.to";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_TO_DOC = "The `to` field of the outgoing mail";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_TO_DEFAULT = null;
    public static final String CAMEL_SINK_MAILSINK_KAMELET_SUBJECT_CONF = "camel.kamelet.mail-sink.subject";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_SUBJECT_DOC = "The mail subject of the outgoing mail";
    public static final String CAMEL_SINK_MAILSINK_KAMELET_SUBJECT_DEFAULT = null;

    public CamelMailsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelMailsinkSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_HOST_DOC);
        conf.define(CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MAILSINK_KAMELET_CONNECTION_PORT_DOC);
        conf.define(CAMEL_SINK_MAILSINK_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MAILSINK_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_MAILSINK_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SINK_MAILSINK_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_MAILSINK_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_MAILSINK_KAMELET_PASSWORD_DOC);
        conf.define(CAMEL_SINK_MAILSINK_KAMELET_FROM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MAILSINK_KAMELET_FROM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MAILSINK_KAMELET_FROM_DOC);
        conf.define(CAMEL_SINK_MAILSINK_KAMELET_TO_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MAILSINK_KAMELET_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MAILSINK_KAMELET_TO_DOC);
        conf.define(CAMEL_SINK_MAILSINK_KAMELET_SUBJECT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MAILSINK_KAMELET_SUBJECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MAILSINK_KAMELET_SUBJECT_DOC);
        return conf;
    }
}