/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.googlemailsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelGooglemailsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_INDEX_CONF = "camel.kamelet.google-mail-source.index";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_INDEX_DOC = "An index for the google mail endpoint";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_INDEX_DEFAULT = null;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_ID_CONF = "camel.kamelet.google-mail-source.clientId";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_ID_DOC = "Client ID of the gmail application";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_SECRET_CONF = "camel.kamelet.google-mail-source.clientSecret";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_SECRET_DOC = "Client Secret of the gmail application";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_ACCESS_TOKEN_CONF = "camel.kamelet.google-mail-source.accessToken";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_ACCESS_TOKEN_DOC = "OAuth 2 access token for google mail application. This typically expires after an hour so refreshToken is recommended for long term usage.";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_ACCESS_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_REFRESH_TOKEN_CONF = "camel.kamelet.google-mail-source.refreshToken";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_REFRESH_TOKEN_DOC = "OAuth 2 refresh token for google mail application. Using this, the Google Calendar component can obtain a new accessToken whenever the current one expires - a necessity if the application is long-lived.";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_REFRESH_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_DELAY_CONF = "camel.kamelet.google-mail-source.delay";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_DELAY_DOC = "The number of milliseconds before the next poll";
    public static final Integer CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_DELAY_DEFAULT = 500;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_APPLICATION_NAME_CONF = "camel.kamelet.google-mail-source.applicationName";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_APPLICATION_NAME_DOC = "Google Mail application name";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_APPLICATION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_MARK_AS_READ_CONF = "camel.kamelet.google-mail-source.markAsRead";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_MARK_AS_READ_DOC = "Mark the message as read once it has been consumed";
    public static final Boolean CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_MARK_AS_READ_DEFAULT = true;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_LABELS_CONF = "camel.kamelet.google-mail-source.labels";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_LABELS_DOC = "Comma separated list of labels to take into account Example: inbox";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_LABELS_DEFAULT = null;
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_QUERY_CONF = "camel.kamelet.google-mail-source.query";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_QUERY_DOC = "The query to execute on gmail box Example: is:unread -category:(promotions OR social)";
    public static final String CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_QUERY_DEFAULT = "is:unread";

    public CamelGooglemailsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelGooglemailsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_INDEX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_INDEX_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_INDEX_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_ID_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_ID_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_SECRET_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_SECRET_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_CLIENT_SECRET_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_ACCESS_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_ACCESS_TOKEN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_ACCESS_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_REFRESH_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_REFRESH_TOKEN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_REFRESH_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_DELAY_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_DELAY_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_APPLICATION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_APPLICATION_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_APPLICATION_NAME_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_MARK_AS_READ_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_MARK_AS_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_MARK_AS_READ_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_LABELS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_LABELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_LABELS_DOC);
        conf.define(CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_GOOGLEMAILSOURCE_KAMELET_QUERY_DOC);
        return conf;
    }
}