/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.JvmBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.jvm.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"classpath", "configuration", "debug", "debugAddress", "debugSuspend", "enabled", "jar", "options", "printCommand"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Jvm
implements Editable<JvmBuilder>,
KubernetesResource {
    @JsonProperty(value="classpath")
    @JsonPropertyDescription(value="Additional JVM classpath (use `Linux` classpath separator)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String classpath;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters.\nDeprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="debug")
    @JsonPropertyDescription(value="Activates remote debugging, so that a debugger can be attached to the JVM, e.g., using port-forwarding")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean debug;
    @JsonProperty(value="debugAddress")
    @JsonPropertyDescription(value="Transport address at which to listen for the newly launched JVM (default `*:5005`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String debugAddress;
    @JsonProperty(value="debugSuspend")
    @JsonPropertyDescription(value="Suspends the target JVM immediately before the main class is loaded")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean debugSuspend;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="jar")
    @JsonPropertyDescription(value="The Jar dependency which will run the application. Leave it empty for managed Integrations.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String jar;
    @JsonProperty(value="options")
    @JsonPropertyDescription(value="A list of JVM options")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> options;
    @JsonProperty(value="printCommand")
    @JsonPropertyDescription(value="Prints the command used the start the JVM in the container logs (default `true`)\nDeprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean printCommand;

    public JvmBuilder edit() {
        return new JvmBuilder(this);
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public String getDebugAddress() {
        return this.debugAddress;
    }

    public void setDebugAddress(String debugAddress) {
        this.debugAddress = debugAddress;
    }

    public Boolean getDebugSuspend() {
        return this.debugSuspend;
    }

    public void setDebugSuspend(Boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getJar() {
        return this.jar;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public Boolean getPrintCommand() {
        return this.printCommand;
    }

    public void setPrintCommand(Boolean printCommand) {
        this.printCommand = printCommand;
    }

    public String toString() {
        return "Jvm(classpath=" + this.getClasspath() + ", configuration=" + this.getConfiguration() + ", debug=" + this.getDebug() + ", debugAddress=" + this.getDebugAddress() + ", debugSuspend=" + this.getDebugSuspend() + ", enabled=" + this.getEnabled() + ", jar=" + this.getJar() + ", options=" + this.getOptions() + ", printCommand=" + this.getPrintCommand() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jvm)) {
            return false;
        }
        Jvm other = (Jvm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$debug = this.getDebug();
        Boolean other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
            return false;
        }
        Boolean this$debugSuspend = this.getDebugSuspend();
        Boolean other$debugSuspend = other.getDebugSuspend();
        if (this$debugSuspend == null ? other$debugSuspend != null : !((Object)this$debugSuspend).equals(other$debugSuspend)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$printCommand = this.getPrintCommand();
        Boolean other$printCommand = other.getPrintCommand();
        if (this$printCommand == null ? other$printCommand != null : !((Object)this$printCommand).equals(other$printCommand)) {
            return false;
        }
        String this$classpath = this.getClasspath();
        String other$classpath = other.getClasspath();
        if (this$classpath == null ? other$classpath != null : !this$classpath.equals(other$classpath)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$debugAddress = this.getDebugAddress();
        String other$debugAddress = other.getDebugAddress();
        if (this$debugAddress == null ? other$debugAddress != null : !this$debugAddress.equals(other$debugAddress)) {
            return false;
        }
        String this$jar = this.getJar();
        String other$jar = other.getJar();
        if (this$jar == null ? other$jar != null : !this$jar.equals(other$jar)) {
            return false;
        }
        List<String> this$options = this.getOptions();
        List<String> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Jvm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
        Boolean $debugSuspend = this.getDebugSuspend();
        result = result * 59 + ($debugSuspend == null ? 43 : ((Object)$debugSuspend).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $printCommand = this.getPrintCommand();
        result = result * 59 + ($printCommand == null ? 43 : ((Object)$printCommand).hashCode());
        String $classpath = this.getClasspath();
        result = result * 59 + ($classpath == null ? 43 : $classpath.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $debugAddress = this.getDebugAddress();
        result = result * 59 + ($debugAddress == null ? 43 : $debugAddress.hashCode());
        String $jar = this.getJar();
        result = result * 59 + ($jar == null ? 43 : $jar.hashCode());
        List<String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }
}

