/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.containers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.pipespec.integration.template.spec.containers.ResourcesBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.containers.resources.Claims;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"claims", "limits", "requests"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Resources
implements Editable<ResourcesBuilder>,
KubernetesResource {
    @JsonProperty(value="claims")
    @JsonPropertyDescription(value="Claims lists the names of resources, defined in spec.resourceClaims,\nthat are used by this container.\n\n\nThis is an alpha field and requires enabling the\nDynamicResourceAllocation feature gate.\n\n\nThis field is immutable. It can only be set for containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Claims> claims;
    @JsonProperty(value="limits")
    @JsonPropertyDescription(value="Limits describes the maximum amount of compute resources allowed.\nMore info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, IntOrString> limits;
    @JsonProperty(value="requests")
    @JsonPropertyDescription(value="Requests describes the minimum amount of compute resources required.\nIf Requests is omitted for a container, it defaults to Limits if that is explicitly specified,\notherwise to an implementation-defined value. Requests cannot exceed Limits.\nMore info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, IntOrString> requests;

    public ResourcesBuilder edit() {
        return new ResourcesBuilder(this);
    }

    public List<Claims> getClaims() {
        return this.claims;
    }

    public void setClaims(List<Claims> claims) {
        this.claims = claims;
    }

    public Map<String, IntOrString> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, IntOrString> limits) {
        this.limits = limits;
    }

    public Map<String, IntOrString> getRequests() {
        return this.requests;
    }

    public void setRequests(Map<String, IntOrString> requests) {
        this.requests = requests;
    }

    public String toString() {
        return "Resources(claims=" + this.getClaims() + ", limits=" + this.getLimits() + ", requests=" + this.getRequests() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resources)) {
            return false;
        }
        Resources other = (Resources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Claims> this$claims = this.getClaims();
        List<Claims> other$claims = other.getClaims();
        if (this$claims == null ? other$claims != null : !((Object)this$claims).equals(other$claims)) {
            return false;
        }
        Map<String, IntOrString> this$limits = this.getLimits();
        Map<String, IntOrString> other$limits = other.getLimits();
        if (this$limits == null ? other$limits != null : !((Object)this$limits).equals(other$limits)) {
            return false;
        }
        Map<String, IntOrString> this$requests = this.getRequests();
        Map<String, IntOrString> other$requests = other.getRequests();
        return !(this$requests == null ? other$requests != null : !((Object)this$requests).equals(other$requests));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Resources;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Claims> $claims = this.getClaims();
        result = result * 59 + ($claims == null ? 43 : ((Object)$claims).hashCode());
        Map<String, IntOrString> $limits = this.getLimits();
        result = result * 59 + ($limits == null ? 43 : ((Object)$limits).hashCode());
        Map<String, IntOrString> $requests = this.getRequests();
        result = result * 59 + ($requests == null ? 43 : ((Object)$requests).hashCode());
        return result;
    }
}

