/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.camel.v1.BuildStatusBuilder;
import org.apache.camel.v1.buildstatus.Artifacts;
import org.apache.camel.v1.buildstatus.Conditions;
import org.apache.camel.v1.buildstatus.Failure;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"artifacts", "baseImage", "conditions", "digest", "duration", "error", "failure", "image", "observedGeneration", "phase", "rootImage", "startedAt"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class BuildStatus
implements Editable<BuildStatusBuilder>,
KubernetesResource {
    @JsonProperty(value="artifacts")
    @JsonPropertyDescription(value="a list of artifacts contained in the build")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Artifacts> artifacts;
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="the base image used for this build")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="a list of conditions occurred during the build")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Conditions> conditions;
    @JsonProperty(value="digest")
    @JsonPropertyDescription(value="the digest from image")
    @JsonSetter(nulls=Nulls.SKIP)
    private String digest;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="how long it took for the build\nChange to Duration / ISO 8601 when CRD uses OpenAPI spec v3\nhttps://github.com/OAI/OpenAPI-Specification/issues/845")
    @JsonSetter(nulls=Nulls.SKIP)
    private String duration;
    @JsonProperty(value="error")
    @JsonPropertyDescription(value="the error description (if any)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String error;
    @JsonProperty(value="failure")
    @JsonPropertyDescription(value="the reason of the failure (if any)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Failure failure;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="the image name built")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="observedGeneration")
    @JsonPropertyDescription(value="ObservedGeneration is the most recent generation observed for this Build.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="describes the phase")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="rootImage")
    @JsonPropertyDescription(value="root image (the first image from which the incremental image has started)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String rootImage;
    @JsonProperty(value="startedAt")
    @JsonPropertyDescription(value="the time when it started")
    @JsonSetter(nulls=Nulls.SKIP)
    private ZonedDateTime startedAt;

    public BuildStatusBuilder edit() {
        return new BuildStatusBuilder(this);
    }

    public List<Artifacts> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifacts> artifacts) {
        this.artifacts = artifacts;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public List<Conditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Conditions> conditions) {
        this.conditions = conditions;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getRootImage() {
        return this.rootImage;
    }

    public void setRootImage(String rootImage) {
        this.rootImage = rootImage;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssVV")
    public ZonedDateTime getStartedAt() {
        return this.startedAt;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[XXX][VV]")
    public void setStartedAt(ZonedDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public String toString() {
        return "BuildStatus(artifacts=" + this.getArtifacts() + ", baseImage=" + this.getBaseImage() + ", conditions=" + this.getConditions() + ", digest=" + this.getDigest() + ", duration=" + this.getDuration() + ", error=" + this.getError() + ", failure=" + this.getFailure() + ", image=" + this.getImage() + ", observedGeneration=" + this.getObservedGeneration() + ", phase=" + this.getPhase() + ", rootImage=" + this.getRootImage() + ", startedAt=" + this.getStartedAt() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildStatus)) {
            return false;
        }
        BuildStatus other = (BuildStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$observedGeneration = this.getObservedGeneration();
        Long other$observedGeneration = other.getObservedGeneration();
        if (this$observedGeneration == null ? other$observedGeneration != null : !((Object)this$observedGeneration).equals(other$observedGeneration)) {
            return false;
        }
        List<Artifacts> this$artifacts = this.getArtifacts();
        List<Artifacts> other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        List<Conditions> this$conditions = this.getConditions();
        List<Conditions> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        Failure this$failure = this.getFailure();
        Failure other$failure = other.getFailure();
        if (this$failure == null ? other$failure != null : !((Object)this$failure).equals(other$failure)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
            return false;
        }
        String this$rootImage = this.getRootImage();
        String other$rootImage = other.getRootImage();
        if (this$rootImage == null ? other$rootImage != null : !this$rootImage.equals(other$rootImage)) {
            return false;
        }
        ZonedDateTime this$startedAt = this.getStartedAt();
        ZonedDateTime other$startedAt = other.getStartedAt();
        return !(this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $observedGeneration = this.getObservedGeneration();
        result = result * 59 + ($observedGeneration == null ? 43 : ((Object)$observedGeneration).hashCode());
        List<Artifacts> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        List<Conditions> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        Failure $failure = this.getFailure();
        result = result * 59 + ($failure == null ? 43 : ((Object)$failure).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        String $rootImage = this.getRootImage();
        result = result * 59 + ($rootImage == null ? 43 : $rootImage.hashCode());
        ZonedDateTime $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
        return result;
    }
}

