/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.bookie.AbstractLogCompactor;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLogCompactor;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.EntryLogMetadataMap;
import org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import org.apache.bookkeeper.bookie.GarbageCollector;
import org.apache.bookkeeper.bookie.InMemoryEntryLogMetadataMap;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.ScanAndCompareGarbageCollector;
import org.apache.bookkeeper.bookie.TransactionalEntryLogCompactor;
import org.apache.bookkeeper.bookie.stats.GarbageCollectorStats;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.bookie.storage.ldb.PersistentEntryLogMetadataMap;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectorThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollectorThread.class);
    private static final int SECOND = 1000;
    private static final long MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private final EntryLogMetadataMap entryLogMetaMap;
    private final ScheduledExecutorService gcExecutor;
    Future<?> scheduledFuture = null;
    final long gcWaitTime;
    boolean isForceMinorCompactionAllow = false;
    boolean enableMinorCompaction = false;
    final double minorCompactionThreshold;
    final long minorCompactionInterval;
    final long minorCompactionMaxTimeMillis;
    long lastMinorCompactionTime;
    boolean isForceMajorCompactionAllow = false;
    boolean enableMajorCompaction = false;
    final double majorCompactionThreshold;
    final long majorCompactionInterval;
    long majorCompactionMaxTimeMillis;
    long lastMajorCompactionTime;
    final long entryLocationCompactionInterval;
    long randomCompactionDelay;
    long lastEntryLocationCompactionTime;
    final boolean isForceGCAllowWhenNoSpace;
    final EntryLogger entryLogger;
    AbstractLogCompactor compactor;
    private final GarbageCollectorStats gcStats;
    private volatile long totalEntryLogSize;
    private volatile int numActiveEntryLogs;
    final CompactableLedgerStorage ledgerStorage;
    final AtomicBoolean compacting = new AtomicBoolean(false);
    final AtomicBoolean minorCompacting = new AtomicBoolean(false);
    final AtomicBoolean majorCompacting = new AtomicBoolean(false);
    volatile boolean running = true;
    final AtomicBoolean forceGarbageCollection = new AtomicBoolean(false);
    final AtomicBoolean suspendMajorCompaction = new AtomicBoolean(false);
    final AtomicBoolean suspendMinorCompaction = new AtomicBoolean(false);
    final ScanAndCompareGarbageCollector garbageCollector;
    final GarbageCollector.GarbageCleaner garbageCleaner;
    final ServerConfiguration conf;
    final LedgerDirsManager ledgerDirsManager;
    private static final AtomicLong threadNum = new AtomicLong(0L);
    final AbstractLogCompactor.Throttler throttler;

    public GarbageCollectorThread(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, CompactableLedgerStorage ledgerStorage, EntryLogger entryLogger, StatsLogger statsLogger) throws IOException {
        this(conf, ledgerManager, ledgerDirsManager, ledgerStorage, entryLogger, statsLogger, GarbageCollectorThread.newExecutor());
    }

    @VisibleForTesting
    static ScheduledExecutorService newExecutor() {
        return Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("GarbageCollectorThread"));
    }

    public GarbageCollectorThread(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, CompactableLedgerStorage ledgerStorage, EntryLogger entryLogger, StatsLogger statsLogger, ScheduledExecutorService gcExecutor) throws IOException {
        this.gcExecutor = gcExecutor;
        this.conf = conf;
        this.ledgerDirsManager = ledgerDirsManager;
        this.entryLogger = entryLogger;
        this.entryLogMetaMap = this.createEntryLogMetadataMap();
        this.ledgerStorage = ledgerStorage;
        this.gcWaitTime = conf.getGcWaitTime();
        this.numActiveEntryLogs = 0;
        this.totalEntryLogSize = 0L;
        this.garbageCollector = new ScanAndCompareGarbageCollector(ledgerManager, ledgerStorage, conf, statsLogger);
        this.gcStats = new GarbageCollectorStats(statsLogger, () -> this.numActiveEntryLogs, () -> this.totalEntryLogSize, () -> this.garbageCollector.getNumActiveLedgers());
        this.garbageCleaner = ledgerId -> {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("delete ledger : " + ledgerId);
                }
                this.gcStats.getDeletedLedgerCounter().inc();
                ledgerStorage.deleteLedger(ledgerId);
            }
            catch (IOException e) {
                LOG.error("Exception when deleting the ledger index file on the Bookie: ", (Throwable)e);
            }
        };
        this.minorCompactionThreshold = conf.getMinorCompactionThreshold();
        this.minorCompactionInterval = conf.getMinorCompactionInterval() * 1000L;
        this.majorCompactionThreshold = conf.getMajorCompactionThreshold();
        this.majorCompactionInterval = conf.getMajorCompactionInterval() * 1000L;
        this.isForceGCAllowWhenNoSpace = conf.getIsForceGCAllowWhenNoSpace();
        this.majorCompactionMaxTimeMillis = conf.getMajorCompactionMaxTimeMillis();
        this.minorCompactionMaxTimeMillis = conf.getMinorCompactionMaxTimeMillis();
        this.entryLocationCompactionInterval = conf.getEntryLocationCompactionInterval() * 1000L;
        if (this.entryLocationCompactionInterval > 0L) {
            this.randomCompactionDelay = ThreadLocalRandom.current().nextLong(this.entryLocationCompactionInterval);
        }
        boolean isForceAllowCompaction = conf.isForceAllowCompaction();
        AbstractLogCompactor.LogRemovalListener remover = new AbstractLogCompactor.LogRemovalListener(){

            @Override
            public void removeEntryLog(long logToRemove) {
                try {
                    GarbageCollectorThread.this.removeEntryLog(logToRemove);
                }
                catch (BookieException.EntryLogMetadataMapException e) {
                    LOG.warn("Failed to remove entry-log metadata {}", (Object)logToRemove, (Object)e);
                }
            }
        };
        this.compactor = conf.getUseTransactionalCompaction() ? new TransactionalEntryLogCompactor(conf, entryLogger, ledgerStorage, remover) : new EntryLogCompactor(conf, entryLogger, ledgerStorage, remover);
        this.throttler = new AbstractLogCompactor.Throttler(conf);
        if (this.minorCompactionInterval > 0L && this.minorCompactionThreshold > 0.0) {
            if (this.minorCompactionThreshold > 1.0) {
                throw new IOException("Invalid minor compaction threshold " + this.minorCompactionThreshold);
            }
            if (this.minorCompactionInterval < this.gcWaitTime) {
                throw new IOException("Too short minor compaction interval : " + this.minorCompactionInterval);
            }
            this.enableMinorCompaction = true;
        }
        if (isForceAllowCompaction) {
            if (this.minorCompactionThreshold > 0.0 && this.minorCompactionThreshold < 1.0) {
                this.isForceMinorCompactionAllow = true;
            }
            if (this.majorCompactionThreshold > 0.0 && this.majorCompactionThreshold < 1.0) {
                this.isForceMajorCompactionAllow = true;
            }
        }
        if (this.majorCompactionInterval > 0L && this.majorCompactionThreshold > 0.0) {
            if (this.majorCompactionThreshold > 1.0) {
                throw new IOException("Invalid major compaction threshold " + this.majorCompactionThreshold);
            }
            if (this.majorCompactionInterval < this.gcWaitTime) {
                throw new IOException("Too short major compaction interval : " + this.majorCompactionInterval);
            }
            this.enableMajorCompaction = true;
        }
        if (this.enableMinorCompaction && this.enableMajorCompaction && (this.minorCompactionInterval >= this.majorCompactionInterval || this.minorCompactionThreshold >= this.majorCompactionThreshold)) {
            throw new IOException("Invalid minor/major compaction settings : minor (" + this.minorCompactionThreshold + ", " + this.minorCompactionInterval + "), major (" + this.majorCompactionThreshold + ", " + this.majorCompactionInterval + ")");
        }
        if (this.entryLocationCompactionInterval > 0L && this.entryLocationCompactionInterval < this.gcWaitTime) {
            throw new IOException("Too short entry location compaction interval : " + this.entryLocationCompactionInterval);
        }
        LOG.info("Minor Compaction : enabled=" + this.enableMinorCompaction + ", threshold=" + this.minorCompactionThreshold + ", interval=" + this.minorCompactionInterval);
        LOG.info("Major Compaction : enabled=" + this.enableMajorCompaction + ", threshold=" + this.majorCompactionThreshold + ", interval=" + this.majorCompactionInterval);
        LOG.info("Entry Location Compaction : interval=" + this.entryLocationCompactionInterval + ", randomCompactionDelay=" + this.randomCompactionDelay);
        this.lastMajorCompactionTime = this.lastEntryLocationCompactionTime = System.currentTimeMillis();
        this.lastMinorCompactionTime = this.lastEntryLocationCompactionTime;
    }

    private EntryLogMetadataMap createEntryLogMetadataMap() throws IOException {
        if (this.conf.isGcEntryLogMetadataCacheEnabled()) {
            String baseDir = Strings.isNullOrEmpty((String)this.conf.getGcEntryLogMetadataCachePath()) ? this.ledgerDirsManager.getAllLedgerDirs().get(0).getPath() : this.conf.getGcEntryLogMetadataCachePath();
            try {
                return new PersistentEntryLogMetadataMap(baseDir, this.conf);
            }
            catch (IOException e) {
                LOG.error("Failed to initialize persistent-metadata-map , clean up {}", (Object)(baseDir + "/" + "metadata-cache"), (Object)e);
                throw e;
            }
        }
        return new InMemoryEntryLogMetadataMap();
    }

    public void enableForceGC() {
        if (this.forceGarbageCollection.compareAndSet(false, true)) {
            LOG.info("Forced garbage collection triggered by thread: {}", (Object)Thread.currentThread().getName());
            this.triggerGC(true, this.suspendMajorCompaction.get(), this.suspendMinorCompaction.get());
        }
    }

    public void enableForceGC(boolean forceMajor, boolean forceMinor) {
        if (this.forceGarbageCollection.compareAndSet(false, true)) {
            LOG.info("Forced garbage collection triggered by thread: {}, forceMajor: {}, forceMinor: {}", new Object[]{Thread.currentThread().getName(), forceMajor, forceMinor});
            this.triggerGC(true, !forceMajor, !forceMinor);
        }
    }

    public void disableForceGC() {
        if (this.forceGarbageCollection.compareAndSet(true, false)) {
            LOG.info("{} disabled force garbage collection since bookie has enough space now.", (Object)Thread.currentThread().getName());
        }
    }

    Future<?> triggerGC(boolean force, boolean suspendMajor, boolean suspendMinor) {
        return this.gcExecutor.submit(() -> this.runWithFlags(force, suspendMajor, suspendMinor));
    }

    Future<?> triggerGC() {
        boolean force = this.forceGarbageCollection.get();
        boolean suspendMajor = this.suspendMajorCompaction.get();
        boolean suspendMinor = this.suspendMinorCompaction.get();
        return this.gcExecutor.submit(() -> this.runWithFlags(force, suspendMajor, suspendMinor));
    }

    public boolean isInForceGC() {
        return this.forceGarbageCollection.get();
    }

    public boolean isMajorGcSuspend() {
        return this.suspendMajorCompaction.get();
    }

    public boolean isMinorGcSuspend() {
        return this.suspendMinorCompaction.get();
    }

    public void suspendMajorGC() {
        if (this.suspendMajorCompaction.compareAndSet(false, true)) {
            LOG.info("Suspend Major Compaction triggered by thread: {}", (Object)Thread.currentThread().getName());
        }
    }

    public void resumeMajorGC() {
        if (this.suspendMajorCompaction.compareAndSet(true, false)) {
            LOG.info("{} Major Compaction back to normal since bookie has enough space now.", (Object)Thread.currentThread().getName());
        }
    }

    public void suspendMinorGC() {
        if (this.suspendMinorCompaction.compareAndSet(false, true)) {
            LOG.info("Suspend Minor Compaction triggered by thread: {}", (Object)Thread.currentThread().getName());
        }
    }

    public void resumeMinorGC() {
        if (this.suspendMinorCompaction.compareAndSet(true, false)) {
            LOG.info("{} Minor Compaction back to normal since bookie has enough space now.", (Object)Thread.currentThread().getName());
        }
    }

    public void start() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        long initialDelay = this.getModInitialDelay();
        this.scheduledFuture = this.gcExecutor.scheduleWithFixedDelay(this, initialDelay, this.gcWaitTime, TimeUnit.MILLISECONDS);
    }

    public long getModInitialDelay() {
        int ledgerDirsNum = this.conf.getLedgerDirs().length;
        long splitTime = this.gcWaitTime / (long)ledgerDirsNum;
        long currentThreadNum = threadNum.incrementAndGet();
        return this.gcWaitTime + currentThreadNum * splitTime;
    }

    @Override
    public void run() {
        boolean force = this.forceGarbageCollection.get();
        boolean suspendMajor = this.suspendMajorCompaction.get();
        boolean suspendMinor = this.suspendMinorCompaction.get();
        this.runWithFlags(force, suspendMajor, suspendMinor);
        if (force) {
            this.forceGarbageCollection.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithFlags(boolean force, boolean suspendMajor, boolean suspendMinor) {
        long threadStart = MathUtils.nowInNano();
        if (force) {
            LOG.info("Garbage collector thread forced to perform GC before expiry of wait time.");
        }
        this.compactor.cleanUpAndRecover();
        try {
            this.doGcLedgers();
            this.extractMetaFromEntryLogs();
            this.doGcEntryLogs();
            if (suspendMajor) {
                LOG.info("Disk almost full, suspend major compaction to slow down filling disk.");
            }
            if (suspendMinor) {
                LOG.info("Disk full, suspend minor compaction to slow down filling disk.");
            }
            long curTime = System.currentTimeMillis();
            if ((this.isForceMajorCompactionAllow && force || this.enableMajorCompaction && (force || curTime - this.lastMajorCompactionTime > this.majorCompactionInterval)) && !suspendMajor) {
                LOG.info("Enter major compaction, suspendMajor {}", (Object)suspendMajor);
                this.majorCompacting.set(true);
                try {
                    this.doCompactEntryLogs(this.majorCompactionThreshold, this.majorCompactionMaxTimeMillis);
                }
                finally {
                    this.lastMinorCompactionTime = this.lastMajorCompactionTime = System.currentTimeMillis();
                    this.gcStats.getMajorCompactionCounter().inc();
                    this.majorCompacting.set(false);
                }
            }
            if ((this.isForceMinorCompactionAllow && force || this.enableMinorCompaction && (force || curTime - this.lastMinorCompactionTime > this.minorCompactionInterval)) && !suspendMinor) {
                LOG.info("Enter minor compaction, suspendMinor {}", (Object)suspendMinor);
                this.minorCompacting.set(true);
                try {
                    this.doCompactEntryLogs(this.minorCompactionThreshold, this.minorCompactionMaxTimeMillis);
                }
                finally {
                    this.lastMinorCompactionTime = System.currentTimeMillis();
                    this.gcStats.getMinorCompactionCounter().inc();
                    this.minorCompacting.set(false);
                }
            }
            if (this.entryLocationCompactionInterval > 0L && curTime - this.lastEntryLocationCompactionTime > this.entryLocationCompactionInterval + this.randomCompactionDelay) {
                LOG.info("Enter entry location compaction, entryLocationCompactionInterval {}, randomCompactionDelay {}, lastEntryLocationCompactionTime {}", new Object[]{this.entryLocationCompactionInterval, this.randomCompactionDelay, this.lastEntryLocationCompactionTime});
                this.ledgerStorage.entryLocationCompact();
                this.lastEntryLocationCompactionTime = System.currentTimeMillis();
                this.randomCompactionDelay = ThreadLocalRandom.current().nextLong(this.entryLocationCompactionInterval);
                LOG.info("Next entry location compaction interval {}", (Object)(this.entryLocationCompactionInterval + this.randomCompactionDelay));
                this.gcStats.getEntryLocationCompactionCounter().inc();
            }
            this.gcStats.getGcThreadRuntime().registerSuccessfulEvent(MathUtils.nowInNano() - threadStart, TimeUnit.NANOSECONDS);
        }
        catch (BookieException.EntryLogMetadataMapException e) {
            LOG.error("Error in entryLog-metadatamap, Failed to complete GC/Compaction due to entry-log {}", (Object)e.getMessage(), (Object)e);
            this.gcStats.getGcThreadRuntime().registerFailedEvent(MathUtils.nowInNano() - threadStart, TimeUnit.NANOSECONDS);
        }
        catch (Throwable e) {
            LOG.error("Error in garbage collector thread, Failed to complete GC/Compaction due to {}", (Object)e.getMessage(), (Object)e);
            this.gcStats.getGcThreadRuntime().registerFailedEvent(MathUtils.elapsedNanos((long)threadStart), TimeUnit.NANOSECONDS);
        }
        finally {
            if (force && this.forceGarbageCollection.compareAndSet(true, false)) {
                LOG.info("{} Set forceGarbageCollection to false after force GC to make it forceGC-able again.", (Object)Thread.currentThread().getName());
            }
        }
    }

    private void doGcLedgers() {
        this.garbageCollector.gc(this.garbageCleaner);
    }

    private void doGcEntryLogs() throws BookieException.EntryLogMetadataMapException {
        AtomicLong totalEntryLogSizeAcc = new AtomicLong(0L);
        this.entryLogMetaMap.forEach((entryLogId, meta) -> {
            try {
                boolean modified = this.removeIfLedgerNotExists((EntryLogMetadata)meta);
                if (meta.isEmpty()) {
                    LOG.info("Deleting entryLogId {} as it has no active ledgers!", entryLogId);
                    if (this.removeEntryLog((long)entryLogId)) {
                        this.gcStats.getReclaimedSpaceViaDeletes().addCount(meta.getTotalSize());
                    } else {
                        this.gcStats.getReclaimFailedToDelete().inc();
                    }
                } else if (modified) {
                    this.entryLogMetaMap.put(meta.getEntryLogId(), (EntryLogMetadata)meta);
                }
            }
            catch (BookieException.EntryLogMetadataMapException e) {
                LOG.warn("Failed to remove ledger from entry-log metadata {}", entryLogId, (Object)e);
            }
            totalEntryLogSizeAcc.getAndAdd(meta.getRemainingSize());
        });
        this.totalEntryLogSize = totalEntryLogSizeAcc.get();
        this.numActiveEntryLogs = this.entryLogMetaMap.size();
    }

    private boolean removeIfLedgerNotExists(EntryLogMetadata meta) throws BookieException.EntryLogMetadataMapException {
        MutableBoolean modified = new MutableBoolean(false);
        meta.removeLedgerIf(entryLogLedger -> {
            try {
                boolean exist = this.ledgerStorage.ledgerExists(entryLogLedger);
                if (!exist) {
                    modified.setTrue();
                }
                return !exist;
            }
            catch (IOException e) {
                LOG.error("Error reading from ledger storage", (Throwable)e);
                return false;
            }
        });
        return modified.getValue();
    }

    @VisibleForTesting
    void doCompactEntryLogs(double threshold, long maxTimeMillis) throws BookieException.EntryLogMetadataMapException {
        LOG.info("Do compaction to compact those files lower than {}", (Object)threshold);
        int numBuckets = 10;
        int[] entryLogUsageBuckets = new int[10];
        int[] compactedBuckets = new int[10];
        ArrayList compactableBuckets = new ArrayList(10);
        for (int i = 0; i < 10; ++i) {
            compactableBuckets.add(new LinkedList());
        }
        long start = System.currentTimeMillis();
        MutableLong end = new MutableLong(start);
        MutableLong timeDiff = new MutableLong(0L);
        this.entryLogMetaMap.forEach((entryLogId, meta) -> {
            int bucketIndex;
            double usage = meta.getUsage();
            if (this.conf.isUseTargetEntryLogSizeForGc() && usage < 1.0) {
                usage = (double)meta.getRemainingSize() / (double)Math.max(meta.getTotalSize(), this.conf.getEntryLogSizeLimit());
            }
            int n = bucketIndex = this.calculateUsageIndex(10, usage);
            entryLogUsageBuckets[n] = entryLogUsageBuckets[n] + 1;
            if (timeDiff.getValue() < maxTimeMillis) {
                end.setValue(System.currentTimeMillis());
                timeDiff.setValue(end.getValue() - start);
            }
            if (usage >= threshold || maxTimeMillis > 0L && timeDiff.getValue() >= maxTimeMillis || !this.running) {
                return;
            }
            ((LinkedList)compactableBuckets.get(bucketIndex)).add(meta.getEntryLogId());
        });
        LOG.info("Compaction: entry log usage buckets before compaction [10% 20% 30% 40% 50% 60% 70% 80% 90% 100%] = {}", (Object)entryLogUsageBuckets);
        int maxBucket = this.calculateUsageIndex(10, threshold);
        int totalEntryLogIds = 0;
        for (int currBucket = 0; currBucket <= maxBucket; ++currBucket) {
            totalEntryLogIds += ((LinkedList)compactableBuckets.get(currBucket)).size();
        }
        long lastPrintTimestamp = 0L;
        AtomicInteger processedEntryLogCnt = new AtomicInteger(0);
        block2: for (int currBucket = 0; currBucket <= maxBucket; ++currBucket) {
            LinkedList entryLogIds = (LinkedList)compactableBuckets.get(currBucket);
            while (!entryLogIds.isEmpty()) {
                if (timeDiff.getValue() < maxTimeMillis) {
                    end.setValue(System.currentTimeMillis());
                    timeDiff.setValue(end.getValue() - start);
                }
                if (maxTimeMillis > 0L && timeDiff.getValue() >= maxTimeMillis || !this.running) break block2;
                int bucketIndex = currBucket;
                long logId = (Long)entryLogIds.remove();
                if (System.currentTimeMillis() - lastPrintTimestamp >= MINUTE) {
                    lastPrintTimestamp = System.currentTimeMillis();
                    LOG.info("Compaction progress {} / {}, current compaction entryLogId: {}", new Object[]{processedEntryLogCnt.get(), totalEntryLogIds, logId});
                }
                this.entryLogMetaMap.forKey(logId, (entryLogId, meta) -> {
                    if (meta == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Metadata for entry log {} already deleted", (Object)logId);
                        }
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Compacting entry log {} with usage {} below threshold {}", new Object[]{meta.getEntryLogId(), meta.getUsage(), threshold});
                    }
                    long priorRemainingSize = meta.getRemainingSize();
                    this.compactEntryLog((EntryLogMetadata)meta);
                    this.gcStats.getReclaimedSpaceViaCompaction().addCount(meta.getTotalSize() - priorRemainingSize);
                    int n = bucketIndex;
                    compactedBuckets[n] = compactedBuckets[n] + 1;
                    processedEntryLogCnt.getAndIncrement();
                });
            }
        }
        if (LOG.isDebugEnabled()) {
            if (!this.running) {
                LOG.debug("Compaction exited due to gc not running");
            }
            if (maxTimeMillis > 0L && timeDiff.getValue() > maxTimeMillis) {
                LOG.debug("Compaction ran for {}ms but was limited by {}ms", (Object)timeDiff, (Object)maxTimeMillis);
            }
        }
        LOG.info("Compaction: entry log usage buckets[10% 20% 30% 40% 50% 60% 70% 80% 90% 100%] = {}, compacted {}", (Object)entryLogUsageBuckets, (Object)compactedBuckets);
    }

    int calculateUsageIndex(int numBuckets, double usage) {
        return Math.min(numBuckets - 1, (int)Math.floor(usage * (double)numBuckets));
    }

    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
    public synchronized void shutdown() throws InterruptedException {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Shutting down GarbageCollectorThread");
        this.throttler.cancelledAcquire();
        this.compactor.throttler.cancelledAcquire();
        while (!this.compacting.compareAndSet(false, true)) {
            Thread.sleep(100L);
        }
        this.gcExecutor.shutdownNow();
        try {
            this.entryLogMetaMap.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close entryLog metadata-map", (Throwable)e);
        }
    }

    protected boolean removeEntryLog(long entryLogId) throws BookieException.EntryLogMetadataMapException {
        if (this.entryLogger.removeEntryLog(entryLogId)) {
            LOG.info("Removing entry log metadata for {}", (Object)entryLogId);
            this.entryLogMetaMap.remove(entryLogId);
            return true;
        }
        return false;
    }

    protected void compactEntryLog(EntryLogMetadata entryLogMeta) {
        if (!this.compacting.compareAndSet(false, true)) {
            return;
        }
        try {
            this.compactor.compact(entryLogMeta);
        }
        catch (Exception e) {
            LOG.error("Failed to compact entry log {} due to unexpected error", (Object)entryLogMeta.getEntryLogId(), (Object)e);
        }
        finally {
            this.compacting.set(false);
        }
    }

    protected void extractMetaFromEntryLogs() throws BookieException.EntryLogMetadataMapException {
        for (long entryLogId : this.entryLogger.getFlushedLogIds()) {
            if (this.entryLogMetaMap.containsKey(entryLogId) || !this.entryLogger.logExists(entryLogId)) continue;
            try {
                EntryLogMetadata entryLogMeta = this.entryLogger.getEntryLogMetadata(entryLogId, this.throttler);
                LOG.info("Extracted entry log meta from entryLogId: {}, ledgers {}", (Object)entryLogId, entryLogMeta.getLedgersMap().keys());
                this.removeIfLedgerNotExists(entryLogMeta);
                if (entryLogMeta.isEmpty()) {
                    LOG.info("Deleting entryLogId {} as it has no active ledgers!", (Object)entryLogId);
                    if (this.removeEntryLog(entryLogId)) {
                        this.gcStats.getReclaimedSpaceViaDeletes().addCount(entryLogMeta.getTotalSize());
                        continue;
                    }
                    this.gcStats.getReclaimFailedToDelete().inc();
                    continue;
                }
                this.entryLogMetaMap.put(entryLogId, entryLogMeta);
            }
            catch (IOException | RuntimeException e) {
                LOG.warn("Premature exception when processing {} recovery will take care of the problem", (Object)entryLogId, (Object)e);
            }
            catch (OutOfMemoryError oome) {
                LOG.warn("OutOfMemoryError when processing {} - skipping the entry log", (Object)entryLogId, (Object)oome);
            }
        }
    }

    CompactableLedgerStorage getLedgerStorage() {
        return this.ledgerStorage;
    }

    @VisibleForTesting
    EntryLogMetadataMap getEntryLogMetaMap() {
        return this.entryLogMetaMap;
    }

    public GarbageCollectionStatus getGarbageCollectionStatus() {
        return GarbageCollectionStatus.builder().forceCompacting(this.forceGarbageCollection.get()).majorCompacting(this.majorCompacting.get()).minorCompacting(this.minorCompacting.get()).lastMajorCompactionTime(this.lastMajorCompactionTime).lastMinorCompactionTime(this.lastMinorCompactionTime).lastEntryLocationCompactionTime(this.lastEntryLocationCompactionTime).majorCompactionCounter(this.gcStats.getMajorCompactionCounter().get()).minorCompactionCounter(this.gcStats.getMinorCompactionCounter().get()).entryLocationCompactionCounter(this.gcStats.getEntryLocationCompactionCounter().get()).build();
    }

    public boolean isForceGCAllowWhenNoSpace() {
        return this.isForceGCAllowWhenNoSpace;
    }
}

