//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Protocol Buffers describing the Job API, api for communicating with a runner
// for job submission over GRPC.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: beam_job_api.proto

package jobmanagement_v1

import (
	context "context"
	pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type JobMessage_MessageImportance int32

const (
	JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED JobMessage_MessageImportance = 0
	JobMessage_JOB_MESSAGE_DEBUG              JobMessage_MessageImportance = 1
	JobMessage_JOB_MESSAGE_DETAILED           JobMessage_MessageImportance = 2
	JobMessage_JOB_MESSAGE_BASIC              JobMessage_MessageImportance = 3
	JobMessage_JOB_MESSAGE_WARNING            JobMessage_MessageImportance = 4
	JobMessage_JOB_MESSAGE_ERROR              JobMessage_MessageImportance = 5
)

// Enum value maps for JobMessage_MessageImportance.
var (
	JobMessage_MessageImportance_name = map[int32]string{
		0: "MESSAGE_IMPORTANCE_UNSPECIFIED",
		1: "JOB_MESSAGE_DEBUG",
		2: "JOB_MESSAGE_DETAILED",
		3: "JOB_MESSAGE_BASIC",
		4: "JOB_MESSAGE_WARNING",
		5: "JOB_MESSAGE_ERROR",
	}
	JobMessage_MessageImportance_value = map[string]int32{
		"MESSAGE_IMPORTANCE_UNSPECIFIED": 0,
		"JOB_MESSAGE_DEBUG":              1,
		"JOB_MESSAGE_DETAILED":           2,
		"JOB_MESSAGE_BASIC":              3,
		"JOB_MESSAGE_WARNING":            4,
		"JOB_MESSAGE_ERROR":              5,
	}
)

func (x JobMessage_MessageImportance) Enum() *JobMessage_MessageImportance {
	p := new(JobMessage_MessageImportance)
	*p = x
	return p
}

func (x JobMessage_MessageImportance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobMessage_MessageImportance) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_job_api_proto_enumTypes[0].Descriptor()
}

func (JobMessage_MessageImportance) Type() protoreflect.EnumType {
	return &file_beam_job_api_proto_enumTypes[0]
}

func (x JobMessage_MessageImportance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobMessage_MessageImportance.Descriptor instead.
func (JobMessage_MessageImportance) EnumDescriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{14, 0}
}

type JobState_Enum int32

const (
	// The job state reported by a runner cannot be interpreted by the SDK.
	JobState_UNSPECIFIED JobState_Enum = 0
	// The job has not yet started.
	JobState_STOPPED JobState_Enum = 1
	// The job is currently running.
	JobState_RUNNING JobState_Enum = 2
	// The job has successfully completed. (terminal)
	JobState_DONE JobState_Enum = 3
	// The job has failed. (terminal)
	JobState_FAILED JobState_Enum = 4
	// The job has been explicitly cancelled. (terminal)
	JobState_CANCELLED JobState_Enum = 5
	// The job has been updated. (terminal)
	JobState_UPDATED JobState_Enum = 6
	// The job is draining its data. (optional)
	JobState_DRAINING JobState_Enum = 7
	// The job has completed draining its data. (terminal)
	JobState_DRAINED JobState_Enum = 8
	// The job is starting up.
	JobState_STARTING JobState_Enum = 9
	// The job is cancelling. (optional)
	JobState_CANCELLING JobState_Enum = 10
	// The job is in the process of being updated. (optional)
	JobState_UPDATING JobState_Enum = 11
)

// Enum value maps for JobState_Enum.
var (
	JobState_Enum_name = map[int32]string{
		0:  "UNSPECIFIED",
		1:  "STOPPED",
		2:  "RUNNING",
		3:  "DONE",
		4:  "FAILED",
		5:  "CANCELLED",
		6:  "UPDATED",
		7:  "DRAINING",
		8:  "DRAINED",
		9:  "STARTING",
		10: "CANCELLING",
		11: "UPDATING",
	}
	JobState_Enum_value = map[string]int32{
		"UNSPECIFIED": 0,
		"STOPPED":     1,
		"RUNNING":     2,
		"DONE":        3,
		"FAILED":      4,
		"CANCELLED":   5,
		"UPDATED":     6,
		"DRAINING":    7,
		"DRAINED":     8,
		"STARTING":    9,
		"CANCELLING":  10,
		"UPDATING":    11,
	}
)

func (x JobState_Enum) Enum() *JobState_Enum {
	p := new(JobState_Enum)
	*p = x
	return p
}

func (x JobState_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobState_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_job_api_proto_enumTypes[1].Descriptor()
}

func (JobState_Enum) Type() protoreflect.EnumType {
	return &file_beam_job_api_proto_enumTypes[1]
}

func (x JobState_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobState_Enum.Descriptor instead.
func (JobState_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{16, 0}
}

type PipelineOptionType_Enum int32

const (
	PipelineOptionType_STRING  PipelineOptionType_Enum = 0
	PipelineOptionType_BOOLEAN PipelineOptionType_Enum = 1
	// whole numbers, see https://json-schema.org/understanding-json-schema/reference/numeric.html
	PipelineOptionType_INTEGER PipelineOptionType_Enum = 2
	PipelineOptionType_NUMBER  PipelineOptionType_Enum = 3
	PipelineOptionType_ARRAY   PipelineOptionType_Enum = 4
	PipelineOptionType_OBJECT  PipelineOptionType_Enum = 5
)

// Enum value maps for PipelineOptionType_Enum.
var (
	PipelineOptionType_Enum_name = map[int32]string{
		0: "STRING",
		1: "BOOLEAN",
		2: "INTEGER",
		3: "NUMBER",
		4: "ARRAY",
		5: "OBJECT",
	}
	PipelineOptionType_Enum_value = map[string]int32{
		"STRING":  0,
		"BOOLEAN": 1,
		"INTEGER": 2,
		"NUMBER":  3,
		"ARRAY":   4,
		"OBJECT":  5,
	}
)

func (x PipelineOptionType_Enum) Enum() *PipelineOptionType_Enum {
	p := new(PipelineOptionType_Enum)
	*p = x
	return p
}

func (x PipelineOptionType_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PipelineOptionType_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_job_api_proto_enumTypes[2].Descriptor()
}

func (PipelineOptionType_Enum) Type() protoreflect.EnumType {
	return &file_beam_job_api_proto_enumTypes[2]
}

func (x PipelineOptionType_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PipelineOptionType_Enum.Descriptor instead.
func (PipelineOptionType_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{21, 0}
}

// Prepare is a synchronous request that returns a preparationId back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error ALREADY_EXISTS if the jobName is reused. Runners are permitted to deduplicate based on the name of the job.
// Throws error UNKNOWN for all other issues
type PrepareJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Pipeline        *pipeline_v1.Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`                                      // (required)
	PipelineOptions *_struct.Struct       `protobuf:"bytes,2,opt,name=pipeline_options,json=pipelineOptions,proto3" json:"pipeline_options,omitempty"` // (required)
	JobName         string                `protobuf:"bytes,3,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`                         // (required)
}

func (x *PrepareJobRequest) Reset() {
	*x = PrepareJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareJobRequest) ProtoMessage() {}

func (x *PrepareJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareJobRequest.ProtoReflect.Descriptor instead.
func (*PrepareJobRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{0}
}

func (x *PrepareJobRequest) GetPipeline() *pipeline_v1.Pipeline {
	if x != nil {
		return x.Pipeline
	}
	return nil
}

func (x *PrepareJobRequest) GetPipelineOptions() *_struct.Struct {
	if x != nil {
		return x.PipelineOptions
	}
	return nil
}

func (x *PrepareJobRequest) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

type PrepareJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (required) The ID used to associate calls made while preparing the job. preparationId is used
	// to run the job.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// An endpoint which exposes the Beam Artifact Staging API. Artifacts used by the job should be
	// staged to this endpoint, and will be available during job execution.
	ArtifactStagingEndpoint *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,2,opt,name=artifact_staging_endpoint,json=artifactStagingEndpoint,proto3" json:"artifact_staging_endpoint,omitempty"`
	// (required) Token for the artifact staging. This token also represent an artifact
	// staging session with the artifact staging service.
	StagingSessionToken string `protobuf:"bytes,3,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
}

func (x *PrepareJobResponse) Reset() {
	*x = PrepareJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareJobResponse) ProtoMessage() {}

func (x *PrepareJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareJobResponse.ProtoReflect.Descriptor instead.
func (*PrepareJobResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{1}
}

func (x *PrepareJobResponse) GetPreparationId() string {
	if x != nil {
		return x.PreparationId
	}
	return ""
}

func (x *PrepareJobResponse) GetArtifactStagingEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if x != nil {
		return x.ArtifactStagingEndpoint
	}
	return nil
}

func (x *PrepareJobResponse) GetStagingSessionToken() string {
	if x != nil {
		return x.StagingSessionToken
	}
	return ""
}

// Run is a synchronous request that returns a jobId back.
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the preparation ID does not exist
// Throws error UNKNOWN for all other issues
type RunJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (required) The ID provided by an earlier call to prepare. Runs the job. All prerequisite tasks
	// must have been completed.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// (optional) If any artifacts have been staged for this job, contains the retrieval_token returned
	// from the CommitManifestResponse.
	RetrievalToken string `protobuf:"bytes,2,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
}

func (x *RunJobRequest) Reset() {
	*x = RunJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunJobRequest) ProtoMessage() {}

func (x *RunJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunJobRequest.ProtoReflect.Descriptor instead.
func (*RunJobRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{2}
}

func (x *RunJobRequest) GetPreparationId() string {
	if x != nil {
		return x.PreparationId
	}
	return ""
}

func (x *RunJobRequest) GetRetrievalToken() string {
	if x != nil {
		return x.RetrievalToken
	}
	return ""
}

type RunJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"` // (required) The ID for the executing job
}

func (x *RunJobResponse) Reset() {
	*x = RunJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunJobResponse) ProtoMessage() {}

func (x *RunJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunJobResponse.ProtoReflect.Descriptor instead.
func (*RunJobResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{3}
}

func (x *RunJobResponse) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// Cancel is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type CancelJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"` // (required)
}

func (x *CancelJobRequest) Reset() {
	*x = CancelJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelJobRequest) ProtoMessage() {}

func (x *CancelJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelJobRequest.ProtoReflect.Descriptor instead.
func (*CancelJobRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{4}
}

func (x *CancelJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// Valid responses include any terminal state or CANCELLING
type CancelJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State JobState_Enum `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"` // (required)
}

func (x *CancelJobResponse) Reset() {
	*x = CancelJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelJobResponse) ProtoMessage() {}

func (x *CancelJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelJobResponse.ProtoReflect.Descriptor instead.
func (*CancelJobResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{5}
}

func (x *CancelJobResponse) GetState() JobState_Enum {
	if x != nil {
		return x.State
	}
	return JobState_UNSPECIFIED
}

// A subset of info provided by ProvisionApi.ProvisionInfo
type JobInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId           string          `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`                                                // (required)
	JobName         string          `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`                                          // (required)
	PipelineOptions *_struct.Struct `protobuf:"bytes,3,opt,name=pipeline_options,json=pipelineOptions,proto3" json:"pipeline_options,omitempty"`                  // (required)
	State           JobState_Enum   `protobuf:"varint,4,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"` // (required)
}

func (x *JobInfo) Reset() {
	*x = JobInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobInfo) ProtoMessage() {}

func (x *JobInfo) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobInfo.ProtoReflect.Descriptor instead.
func (*JobInfo) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{6}
}

func (x *JobInfo) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *JobInfo) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *JobInfo) GetPipelineOptions() *_struct.Struct {
	if x != nil {
		return x.PipelineOptions
	}
	return nil
}

func (x *JobInfo) GetState() JobState_Enum {
	if x != nil {
		return x.State
	}
	return JobState_UNSPECIFIED
}

// GetJobs is a synchronus request that returns a list of invoked jobs back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
type GetJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetJobsRequest) Reset() {
	*x = GetJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobsRequest) ProtoMessage() {}

func (x *GetJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobsRequest.ProtoReflect.Descriptor instead.
func (*GetJobsRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{7}
}

type GetJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobInfo []*JobInfo `protobuf:"bytes,1,rep,name=job_info,json=jobInfo,proto3" json:"job_info,omitempty"` // (required)
}

func (x *GetJobsResponse) Reset() {
	*x = GetJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobsResponse) ProtoMessage() {}

func (x *GetJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobsResponse.ProtoReflect.Descriptor instead.
func (*GetJobsResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{8}
}

func (x *GetJobsResponse) GetJobInfo() []*JobInfo {
	if x != nil {
		return x.JobInfo
	}
	return nil
}

// GetState is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type GetJobStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"` // (required)
}

func (x *GetJobStateRequest) Reset() {
	*x = GetJobStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobStateRequest) ProtoMessage() {}

func (x *GetJobStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobStateRequest.ProtoReflect.Descriptor instead.
func (*GetJobStateRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{9}
}

func (x *GetJobStateRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

type JobStateEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State     JobState_Enum        `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"` // (required)
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`                                                     // (required)
}

func (x *JobStateEvent) Reset() {
	*x = JobStateEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStateEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStateEvent) ProtoMessage() {}

func (x *JobStateEvent) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStateEvent.ProtoReflect.Descriptor instead.
func (*JobStateEvent) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{10}
}

func (x *JobStateEvent) GetState() JobState_Enum {
	if x != nil {
		return x.State
	}
	return JobState_UNSPECIFIED
}

func (x *JobStateEvent) GetTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

// GetPipeline is a synchronus request that returns a pipeline back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type GetJobPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"` // (required)
}

func (x *GetJobPipelineRequest) Reset() {
	*x = GetJobPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobPipelineRequest) ProtoMessage() {}

func (x *GetJobPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobPipelineRequest.ProtoReflect.Descriptor instead.
func (*GetJobPipelineRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{11}
}

func (x *GetJobPipelineRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

type GetJobPipelineResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Pipeline *pipeline_v1.Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"` // (required)
}

func (x *GetJobPipelineResponse) Reset() {
	*x = GetJobPipelineResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobPipelineResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobPipelineResponse) ProtoMessage() {}

func (x *GetJobPipelineResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobPipelineResponse.ProtoReflect.Descriptor instead.
func (*GetJobPipelineResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{12}
}

func (x *GetJobPipelineResponse) GetPipeline() *pipeline_v1.Pipeline {
	if x != nil {
		return x.Pipeline
	}
	return nil
}

// GetJobMessages is a streaming api for streaming job messages from the service
// One request will connect you to the job and you'll get a stream of job state
// and job messages back; one is used for logging and the other for detecting
// the job ended.
type JobMessagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"` // (required)
}

func (x *JobMessagesRequest) Reset() {
	*x = JobMessagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobMessagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobMessagesRequest) ProtoMessage() {}

func (x *JobMessagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobMessagesRequest.ProtoReflect.Descriptor instead.
func (*JobMessagesRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{13}
}

func (x *JobMessagesRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

type JobMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MessageId   string                       `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	Time        string                       `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	Importance  JobMessage_MessageImportance `protobuf:"varint,3,opt,name=importance,proto3,enum=org.apache.beam.model.job_management.v1.JobMessage_MessageImportance" json:"importance,omitempty"`
	MessageText string                       `protobuf:"bytes,4,opt,name=message_text,json=messageText,proto3" json:"message_text,omitempty"`
}

func (x *JobMessage) Reset() {
	*x = JobMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobMessage) ProtoMessage() {}

func (x *JobMessage) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobMessage.ProtoReflect.Descriptor instead.
func (*JobMessage) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{14}
}

func (x *JobMessage) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *JobMessage) GetTime() string {
	if x != nil {
		return x.Time
	}
	return ""
}

func (x *JobMessage) GetImportance() JobMessage_MessageImportance {
	if x != nil {
		return x.Importance
	}
	return JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED
}

func (x *JobMessage) GetMessageText() string {
	if x != nil {
		return x.MessageText
	}
	return ""
}

type JobMessagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Response:
	//	*JobMessagesResponse_MessageResponse
	//	*JobMessagesResponse_StateResponse
	Response isJobMessagesResponse_Response `protobuf_oneof:"response"`
}

func (x *JobMessagesResponse) Reset() {
	*x = JobMessagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobMessagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobMessagesResponse) ProtoMessage() {}

func (x *JobMessagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobMessagesResponse.ProtoReflect.Descriptor instead.
func (*JobMessagesResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{15}
}

func (m *JobMessagesResponse) GetResponse() isJobMessagesResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *JobMessagesResponse) GetMessageResponse() *JobMessage {
	if x, ok := x.GetResponse().(*JobMessagesResponse_MessageResponse); ok {
		return x.MessageResponse
	}
	return nil
}

func (x *JobMessagesResponse) GetStateResponse() *JobStateEvent {
	if x, ok := x.GetResponse().(*JobMessagesResponse_StateResponse); ok {
		return x.StateResponse
	}
	return nil
}

type isJobMessagesResponse_Response interface {
	isJobMessagesResponse_Response()
}

type JobMessagesResponse_MessageResponse struct {
	MessageResponse *JobMessage `protobuf:"bytes,1,opt,name=message_response,json=messageResponse,proto3,oneof"`
}

type JobMessagesResponse_StateResponse struct {
	StateResponse *JobStateEvent `protobuf:"bytes,2,opt,name=state_response,json=stateResponse,proto3,oneof"`
}

func (*JobMessagesResponse_MessageResponse) isJobMessagesResponse_Response() {}

func (*JobMessagesResponse_StateResponse) isJobMessagesResponse_Response() {}

// Enumeration of all JobStates
//
// The state transition diagram is:
//   STOPPED -> STARTING -> RUNNING -> DONE
//                                  \> FAILED
//                                  \> CANCELLING -> CANCELLED
//                                  \> UPDATING -> UPDATED
//                                  \> DRAINING -> DRAINED
//
// Transitions are optional such that a job may go from STOPPED to RUNNING
// without needing to pass through STARTING.
type JobState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *JobState) Reset() {
	*x = JobState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobState) ProtoMessage() {}

func (x *JobState) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobState.ProtoReflect.Descriptor instead.
func (*JobState) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{16}
}

type GetJobMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"` // (required)
}

func (x *GetJobMetricsRequest) Reset() {
	*x = GetJobMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobMetricsRequest) ProtoMessage() {}

func (x *GetJobMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetJobMetricsRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{17}
}

func (x *GetJobMetricsRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

type GetJobMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metrics *MetricResults `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *GetJobMetricsResponse) Reset() {
	*x = GetJobMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobMetricsResponse) ProtoMessage() {}

func (x *GetJobMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobMetricsResponse.ProtoReflect.Descriptor instead.
func (*GetJobMetricsResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{18}
}

func (x *GetJobMetricsResponse) GetMetrics() *MetricResults {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// All metrics for a given job.  Runners may support one or the other or both.
type MetricResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Attempted []*pipeline_v1.MonitoringInfo `protobuf:"bytes,1,rep,name=attempted,proto3" json:"attempted,omitempty"`
	Committed []*pipeline_v1.MonitoringInfo `protobuf:"bytes,2,rep,name=committed,proto3" json:"committed,omitempty"`
}

func (x *MetricResults) Reset() {
	*x = MetricResults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricResults) ProtoMessage() {}

func (x *MetricResults) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricResults.ProtoReflect.Descriptor instead.
func (*MetricResults) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{19}
}

func (x *MetricResults) GetAttempted() []*pipeline_v1.MonitoringInfo {
	if x != nil {
		return x.Attempted
	}
	return nil
}

func (x *MetricResults) GetCommitted() []*pipeline_v1.MonitoringInfo {
	if x != nil {
		return x.Committed
	}
	return nil
}

// DescribePipelineOptions provides metadata about the options supported by a runner.
// It will be used by the SDK client to validate the options specified by or
// list available options to the user.
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
type DescribePipelineOptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DescribePipelineOptionsRequest) Reset() {
	*x = DescribePipelineOptionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DescribePipelineOptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribePipelineOptionsRequest) ProtoMessage() {}

func (x *DescribePipelineOptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribePipelineOptionsRequest.ProtoReflect.Descriptor instead.
func (*DescribePipelineOptionsRequest) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{20}
}

// Type for pipeline options.
// Types mirror those of JSON, since that's how pipeline options are serialized.
type PipelineOptionType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PipelineOptionType) Reset() {
	*x = PipelineOptionType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineOptionType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineOptionType) ProtoMessage() {}

func (x *PipelineOptionType) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineOptionType.ProtoReflect.Descriptor instead.
func (*PipelineOptionType) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{21}
}

// Metadata for a pipeline option.
type PipelineOptionDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The option name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) Type of option.
	Type PipelineOptionType_Enum `protobuf:"varint,2,opt,name=type,proto3,enum=org.apache.beam.model.job_management.v1.PipelineOptionType_Enum" json:"type,omitempty"`
	// (Optional) Description suitable for display / help text.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// (Optional) Default value.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// (Required) The group this option belongs to.
	Group string `protobuf:"bytes,5,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *PipelineOptionDescriptor) Reset() {
	*x = PipelineOptionDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineOptionDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineOptionDescriptor) ProtoMessage() {}

func (x *PipelineOptionDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineOptionDescriptor.ProtoReflect.Descriptor instead.
func (*PipelineOptionDescriptor) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{22}
}

func (x *PipelineOptionDescriptor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PipelineOptionDescriptor) GetType() PipelineOptionType_Enum {
	if x != nil {
		return x.Type
	}
	return PipelineOptionType_STRING
}

func (x *PipelineOptionDescriptor) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PipelineOptionDescriptor) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

func (x *PipelineOptionDescriptor) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

type DescribePipelineOptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of pipeline option descriptors.
	Options []*PipelineOptionDescriptor `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *DescribePipelineOptionsResponse) Reset() {
	*x = DescribePipelineOptionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_job_api_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DescribePipelineOptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribePipelineOptionsResponse) ProtoMessage() {}

func (x *DescribePipelineOptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_job_api_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribePipelineOptionsResponse.ProtoReflect.Descriptor instead.
func (*DescribePipelineOptionsResponse) Descriptor() ([]byte, []int) {
	return file_beam_job_api_proto_rawDescGZIP(), []int{23}
}

func (x *DescribePipelineOptionsResponse) GetOptions() []*PipelineOptionDescriptor {
	if x != nil {
		return x.Options
	}
	return nil
}

var File_beam_job_api_proto protoreflect.FileDescriptor

var file_beam_job_api_proto_rawDesc = []byte{
	0x0a, 0x12, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x61, 0x70, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x15, 0x62,
	0x65, 0x61, 0x6d, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x61, 0x70, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x01, 0x0a, 0x11, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x08, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x08, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x42, 0x0a, 0x10, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0xe4, 0x01, 0x0a, 0x12, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x70,
	0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x73, 0x0a, 0x19, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x67,
	0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x17, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65,
	0x70, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x27, 0x0a, 0x0e, 0x52, 0x75, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62,
	0x49, 0x64, 0x22, 0x29, 0x0a, 0x10, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0x61, 0x0a,
	0x11, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x22, 0xcd, 0x01, 0x0a, 0x07, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x15, 0x0a, 0x06,
	0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f,
	0x62, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42,
	0x0a, 0x10, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x22, 0x10, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0x5e, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x49, 0x6e,
	0x66, 0x6f, 0x22, 0x2b, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22,
	0x97, 0x01, 0x0a, 0x0d, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x2e, 0x0a, 0x15, 0x47, 0x65, 0x74,
	0x4a, 0x6f, 0x62, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0x61, 0x0a, 0x16, 0x47, 0x65, 0x74,
	0x4a, 0x6f, 0x62, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x08, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x2b, 0x0a, 0x12,
	0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0xfb, 0x02, 0x0a, 0x0a, 0x4a, 0x6f,
	0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x0a, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x54, 0x65, 0x78, 0x74, 0x22, 0xaf, 0x01, 0x0a, 0x11, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4d,
	0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x44,
	0x45, 0x42, 0x55, 0x47, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45,
	0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f,
	0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x4a, 0x4f, 0x42, 0x5f, 0x4d,
	0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x04,
	0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x22, 0xe4, 0x01, 0x0a, 0x13, 0x4a, 0x6f, 0x62, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x60, 0x0a, 0x10, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x48, 0x00,
	0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb7,
	0x01, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x04,
	0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x06, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x52, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0b, 0x22, 0x2d, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4a,
	0x6f, 0x62, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0x69, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4a, 0x6f,
	0x62, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x50, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x22, 0xb1, 0x01, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x61, 0x74, 0x74, 0x65,
	0x6d, 0x70, 0x74, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x22, 0x20, 0x0a, 0x1e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x65, 0x0a, 0x12, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x4f,
	0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52, 0x52, 0x41,
	0x59, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x05, 0x22,
	0xe1, 0x01, 0x0a, 0x18, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x54, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x22, 0x7e, 0x0a, 0x1f, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x32, 0xf6, 0x0a, 0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x07, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x12, 0x3a,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x03, 0x52, 0x75, 0x6e, 0x12, 0x36,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a,
	0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x75, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x7c, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x37, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7f, 0x0a,
	0x08, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a,
	0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x8e,
	0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x3e,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x7f, 0x0a, 0x06, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0x39, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x87, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x12, 0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x30, 0x01, 0x12, 0x8f, 0x01, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x8e, 0x01, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3d,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xac, 0x01,
	0x0a, 0x17, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x48, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x81, 0x01, 0x0a,
	0x26, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x06, 0x4a, 0x6f, 0x62, 0x41, 0x70, 0x69, 0x5a,
	0x4f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x73, 0x64, 0x6b, 0x73, 0x2f, 0x67, 0x6f, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x6a,
	0x6f, 0x62, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x31, 0x3b,
	0x6a, 0x6f, 0x62, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_beam_job_api_proto_rawDescOnce sync.Once
	file_beam_job_api_proto_rawDescData = file_beam_job_api_proto_rawDesc
)

func file_beam_job_api_proto_rawDescGZIP() []byte {
	file_beam_job_api_proto_rawDescOnce.Do(func() {
		file_beam_job_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_beam_job_api_proto_rawDescData)
	})
	return file_beam_job_api_proto_rawDescData
}

var file_beam_job_api_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_beam_job_api_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_beam_job_api_proto_goTypes = []interface{}{
	(JobMessage_MessageImportance)(0),        // 0: org.apache.beam.model.job_management.v1.JobMessage.MessageImportance
	(JobState_Enum)(0),                       // 1: org.apache.beam.model.job_management.v1.JobState.Enum
	(PipelineOptionType_Enum)(0),             // 2: org.apache.beam.model.job_management.v1.PipelineOptionType.Enum
	(*PrepareJobRequest)(nil),                // 3: org.apache.beam.model.job_management.v1.PrepareJobRequest
	(*PrepareJobResponse)(nil),               // 4: org.apache.beam.model.job_management.v1.PrepareJobResponse
	(*RunJobRequest)(nil),                    // 5: org.apache.beam.model.job_management.v1.RunJobRequest
	(*RunJobResponse)(nil),                   // 6: org.apache.beam.model.job_management.v1.RunJobResponse
	(*CancelJobRequest)(nil),                 // 7: org.apache.beam.model.job_management.v1.CancelJobRequest
	(*CancelJobResponse)(nil),                // 8: org.apache.beam.model.job_management.v1.CancelJobResponse
	(*JobInfo)(nil),                          // 9: org.apache.beam.model.job_management.v1.JobInfo
	(*GetJobsRequest)(nil),                   // 10: org.apache.beam.model.job_management.v1.GetJobsRequest
	(*GetJobsResponse)(nil),                  // 11: org.apache.beam.model.job_management.v1.GetJobsResponse
	(*GetJobStateRequest)(nil),               // 12: org.apache.beam.model.job_management.v1.GetJobStateRequest
	(*JobStateEvent)(nil),                    // 13: org.apache.beam.model.job_management.v1.JobStateEvent
	(*GetJobPipelineRequest)(nil),            // 14: org.apache.beam.model.job_management.v1.GetJobPipelineRequest
	(*GetJobPipelineResponse)(nil),           // 15: org.apache.beam.model.job_management.v1.GetJobPipelineResponse
	(*JobMessagesRequest)(nil),               // 16: org.apache.beam.model.job_management.v1.JobMessagesRequest
	(*JobMessage)(nil),                       // 17: org.apache.beam.model.job_management.v1.JobMessage
	(*JobMessagesResponse)(nil),              // 18: org.apache.beam.model.job_management.v1.JobMessagesResponse
	(*JobState)(nil),                         // 19: org.apache.beam.model.job_management.v1.JobState
	(*GetJobMetricsRequest)(nil),             // 20: org.apache.beam.model.job_management.v1.GetJobMetricsRequest
	(*GetJobMetricsResponse)(nil),            // 21: org.apache.beam.model.job_management.v1.GetJobMetricsResponse
	(*MetricResults)(nil),                    // 22: org.apache.beam.model.job_management.v1.MetricResults
	(*DescribePipelineOptionsRequest)(nil),   // 23: org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest
	(*PipelineOptionType)(nil),               // 24: org.apache.beam.model.job_management.v1.PipelineOptionType
	(*PipelineOptionDescriptor)(nil),         // 25: org.apache.beam.model.job_management.v1.PipelineOptionDescriptor
	(*DescribePipelineOptionsResponse)(nil),  // 26: org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse
	(*pipeline_v1.Pipeline)(nil),             // 27: org.apache.beam.model.pipeline.v1.Pipeline
	(*_struct.Struct)(nil),                   // 28: google.protobuf.Struct
	(*pipeline_v1.ApiServiceDescriptor)(nil), // 29: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor
	(*timestamp.Timestamp)(nil),              // 30: google.protobuf.Timestamp
	(*pipeline_v1.MonitoringInfo)(nil),       // 31: org.apache.beam.model.pipeline.v1.MonitoringInfo
}
var file_beam_job_api_proto_depIdxs = []int32{
	27, // 0: org.apache.beam.model.job_management.v1.PrepareJobRequest.pipeline:type_name -> org.apache.beam.model.pipeline.v1.Pipeline
	28, // 1: org.apache.beam.model.job_management.v1.PrepareJobRequest.pipeline_options:type_name -> google.protobuf.Struct
	29, // 2: org.apache.beam.model.job_management.v1.PrepareJobResponse.artifact_staging_endpoint:type_name -> org.apache.beam.model.pipeline.v1.ApiServiceDescriptor
	1,  // 3: org.apache.beam.model.job_management.v1.CancelJobResponse.state:type_name -> org.apache.beam.model.job_management.v1.JobState.Enum
	28, // 4: org.apache.beam.model.job_management.v1.JobInfo.pipeline_options:type_name -> google.protobuf.Struct
	1,  // 5: org.apache.beam.model.job_management.v1.JobInfo.state:type_name -> org.apache.beam.model.job_management.v1.JobState.Enum
	9,  // 6: org.apache.beam.model.job_management.v1.GetJobsResponse.job_info:type_name -> org.apache.beam.model.job_management.v1.JobInfo
	1,  // 7: org.apache.beam.model.job_management.v1.JobStateEvent.state:type_name -> org.apache.beam.model.job_management.v1.JobState.Enum
	30, // 8: org.apache.beam.model.job_management.v1.JobStateEvent.timestamp:type_name -> google.protobuf.Timestamp
	27, // 9: org.apache.beam.model.job_management.v1.GetJobPipelineResponse.pipeline:type_name -> org.apache.beam.model.pipeline.v1.Pipeline
	0,  // 10: org.apache.beam.model.job_management.v1.JobMessage.importance:type_name -> org.apache.beam.model.job_management.v1.JobMessage.MessageImportance
	17, // 11: org.apache.beam.model.job_management.v1.JobMessagesResponse.message_response:type_name -> org.apache.beam.model.job_management.v1.JobMessage
	13, // 12: org.apache.beam.model.job_management.v1.JobMessagesResponse.state_response:type_name -> org.apache.beam.model.job_management.v1.JobStateEvent
	22, // 13: org.apache.beam.model.job_management.v1.GetJobMetricsResponse.metrics:type_name -> org.apache.beam.model.job_management.v1.MetricResults
	31, // 14: org.apache.beam.model.job_management.v1.MetricResults.attempted:type_name -> org.apache.beam.model.pipeline.v1.MonitoringInfo
	31, // 15: org.apache.beam.model.job_management.v1.MetricResults.committed:type_name -> org.apache.beam.model.pipeline.v1.MonitoringInfo
	2,  // 16: org.apache.beam.model.job_management.v1.PipelineOptionDescriptor.type:type_name -> org.apache.beam.model.job_management.v1.PipelineOptionType.Enum
	25, // 17: org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse.options:type_name -> org.apache.beam.model.job_management.v1.PipelineOptionDescriptor
	3,  // 18: org.apache.beam.model.job_management.v1.JobService.Prepare:input_type -> org.apache.beam.model.job_management.v1.PrepareJobRequest
	5,  // 19: org.apache.beam.model.job_management.v1.JobService.Run:input_type -> org.apache.beam.model.job_management.v1.RunJobRequest
	10, // 20: org.apache.beam.model.job_management.v1.JobService.GetJobs:input_type -> org.apache.beam.model.job_management.v1.GetJobsRequest
	12, // 21: org.apache.beam.model.job_management.v1.JobService.GetState:input_type -> org.apache.beam.model.job_management.v1.GetJobStateRequest
	14, // 22: org.apache.beam.model.job_management.v1.JobService.GetPipeline:input_type -> org.apache.beam.model.job_management.v1.GetJobPipelineRequest
	7,  // 23: org.apache.beam.model.job_management.v1.JobService.Cancel:input_type -> org.apache.beam.model.job_management.v1.CancelJobRequest
	12, // 24: org.apache.beam.model.job_management.v1.JobService.GetStateStream:input_type -> org.apache.beam.model.job_management.v1.GetJobStateRequest
	16, // 25: org.apache.beam.model.job_management.v1.JobService.GetMessageStream:input_type -> org.apache.beam.model.job_management.v1.JobMessagesRequest
	20, // 26: org.apache.beam.model.job_management.v1.JobService.GetJobMetrics:input_type -> org.apache.beam.model.job_management.v1.GetJobMetricsRequest
	23, // 27: org.apache.beam.model.job_management.v1.JobService.DescribePipelineOptions:input_type -> org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest
	4,  // 28: org.apache.beam.model.job_management.v1.JobService.Prepare:output_type -> org.apache.beam.model.job_management.v1.PrepareJobResponse
	6,  // 29: org.apache.beam.model.job_management.v1.JobService.Run:output_type -> org.apache.beam.model.job_management.v1.RunJobResponse
	11, // 30: org.apache.beam.model.job_management.v1.JobService.GetJobs:output_type -> org.apache.beam.model.job_management.v1.GetJobsResponse
	13, // 31: org.apache.beam.model.job_management.v1.JobService.GetState:output_type -> org.apache.beam.model.job_management.v1.JobStateEvent
	15, // 32: org.apache.beam.model.job_management.v1.JobService.GetPipeline:output_type -> org.apache.beam.model.job_management.v1.GetJobPipelineResponse
	8,  // 33: org.apache.beam.model.job_management.v1.JobService.Cancel:output_type -> org.apache.beam.model.job_management.v1.CancelJobResponse
	13, // 34: org.apache.beam.model.job_management.v1.JobService.GetStateStream:output_type -> org.apache.beam.model.job_management.v1.JobStateEvent
	18, // 35: org.apache.beam.model.job_management.v1.JobService.GetMessageStream:output_type -> org.apache.beam.model.job_management.v1.JobMessagesResponse
	21, // 36: org.apache.beam.model.job_management.v1.JobService.GetJobMetrics:output_type -> org.apache.beam.model.job_management.v1.GetJobMetricsResponse
	26, // 37: org.apache.beam.model.job_management.v1.JobService.DescribePipelineOptions:output_type -> org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse
	28, // [28:38] is the sub-list for method output_type
	18, // [18:28] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_beam_job_api_proto_init() }
func file_beam_job_api_proto_init() {
	if File_beam_job_api_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_beam_job_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStateEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobPipelineResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobMessagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobMessagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricResults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DescribePipelineOptionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineOptionType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineOptionDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_job_api_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DescribePipelineOptionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_beam_job_api_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*JobMessagesResponse_MessageResponse)(nil),
		(*JobMessagesResponse_StateResponse)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_beam_job_api_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_beam_job_api_proto_goTypes,
		DependencyIndexes: file_beam_job_api_proto_depIdxs,
		EnumInfos:         file_beam_job_api_proto_enumTypes,
		MessageInfos:      file_beam_job_api_proto_msgTypes,
	}.Build()
	File_beam_job_api_proto = out.File
	file_beam_job_api_proto_rawDesc = nil
	file_beam_job_api_proto_goTypes = nil
	file_beam_job_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error)
	// Get a list of all invoked jobs
	GetJobs(ctx context.Context, in *GetJobsRequest, opts ...grpc.CallOption) (*GetJobsResponse, error)
	// Get the current state of the job
	GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*JobStateEvent, error)
	// Get the job's pipeline
	GetPipeline(ctx context.Context, in *GetJobPipelineRequest, opts ...grpc.CallOption) (*GetJobPipelineResponse, error)
	// Cancel the job
	Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error)
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error)
	// Fetch metrics for a given job
	GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*GetJobMetricsResponse, error)
	// Get the supported pipeline options of the runner
	DescribePipelineOptions(ctx context.Context, in *DescribePipelineOptionsRequest, opts ...grpc.CallOption) (*DescribePipelineOptionsResponse, error)
}

type jobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewJobServiceClient(cc grpc.ClientConnInterface) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error) {
	out := new(PrepareJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Prepare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error) {
	out := new(RunJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Run", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJobs(ctx context.Context, in *GetJobsRequest, opts ...grpc.CallOption) (*GetJobsResponse, error) {
	out := new(GetJobsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*JobStateEvent, error) {
	out := new(JobStateEvent)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetPipeline(ctx context.Context, in *GetJobPipelineRequest, opts ...grpc.CallOption) (*GetJobPipelineResponse, error) {
	out := new(GetJobPipelineResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error) {
	out := new(CancelJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Cancel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.JobService/GetStateStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetStateStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetStateStreamClient interface {
	Recv() (*JobStateEvent, error)
	grpc.ClientStream
}

type jobServiceGetStateStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetStateStreamClient) Recv() (*JobStateEvent, error) {
	m := new(JobStateEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jobServiceClient) GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[1], "/org.apache.beam.model.job_management.v1.JobService/GetMessageStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetMessageStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetMessageStreamClient interface {
	Recv() (*JobMessagesResponse, error)
	grpc.ClientStream
}

type jobServiceGetMessageStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetMessageStreamClient) Recv() (*JobMessagesResponse, error) {
	m := new(JobMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jobServiceClient) GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*GetJobMetricsResponse, error) {
	out := new(GetJobMetricsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetJobMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DescribePipelineOptions(ctx context.Context, in *DescribePipelineOptionsRequest, opts ...grpc.CallOption) (*DescribePipelineOptionsResponse, error) {
	out := new(DescribePipelineOptionsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/DescribePipelineOptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(context.Context, *PrepareJobRequest) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(context.Context, *RunJobRequest) (*RunJobResponse, error)
	// Get a list of all invoked jobs
	GetJobs(context.Context, *GetJobsRequest) (*GetJobsResponse, error)
	// Get the current state of the job
	GetState(context.Context, *GetJobStateRequest) (*JobStateEvent, error)
	// Get the job's pipeline
	GetPipeline(context.Context, *GetJobPipelineRequest) (*GetJobPipelineResponse, error)
	// Cancel the job
	Cancel(context.Context, *CancelJobRequest) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(*GetJobStateRequest, JobService_GetStateStreamServer) error
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(*JobMessagesRequest, JobService_GetMessageStreamServer) error
	// Fetch metrics for a given job
	GetJobMetrics(context.Context, *GetJobMetricsRequest) (*GetJobMetricsResponse, error)
	// Get the supported pipeline options of the runner
	DescribePipelineOptions(context.Context, *DescribePipelineOptionsRequest) (*DescribePipelineOptionsResponse, error)
}

// UnimplementedJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedJobServiceServer struct {
}

func (*UnimplementedJobServiceServer) Prepare(context.Context, *PrepareJobRequest) (*PrepareJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Prepare not implemented")
}
func (*UnimplementedJobServiceServer) Run(context.Context, *RunJobRequest) (*RunJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Run not implemented")
}
func (*UnimplementedJobServiceServer) GetJobs(context.Context, *GetJobsRequest) (*GetJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobs not implemented")
}
func (*UnimplementedJobServiceServer) GetState(context.Context, *GetJobStateRequest) (*JobStateEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (*UnimplementedJobServiceServer) GetPipeline(context.Context, *GetJobPipelineRequest) (*GetJobPipelineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipeline not implemented")
}
func (*UnimplementedJobServiceServer) Cancel(context.Context, *CancelJobRequest) (*CancelJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Cancel not implemented")
}
func (*UnimplementedJobServiceServer) GetStateStream(*GetJobStateRequest, JobService_GetStateStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method GetStateStream not implemented")
}
func (*UnimplementedJobServiceServer) GetMessageStream(*JobMessagesRequest, JobService_GetMessageStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method GetMessageStream not implemented")
}
func (*UnimplementedJobServiceServer) GetJobMetrics(context.Context, *GetJobMetricsRequest) (*GetJobMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobMetrics not implemented")
}
func (*UnimplementedJobServiceServer) DescribePipelineOptions(context.Context, *DescribePipelineOptionsRequest) (*DescribePipelineOptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribePipelineOptions not implemented")
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_Prepare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Prepare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Prepare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Prepare(ctx, req.(*PrepareJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Run_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Run(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Run",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Run(ctx, req.(*RunJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJobs(ctx, req.(*GetJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetState(ctx, req.(*GetJobStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetPipeline(ctx, req.(*GetJobPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Cancel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Cancel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Cancel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Cancel(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetStateStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetJobStateRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetStateStream(m, &jobServiceGetStateStreamServer{stream})
}

type JobService_GetStateStreamServer interface {
	Send(*JobStateEvent) error
	grpc.ServerStream
}

type jobServiceGetStateStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetStateStreamServer) Send(m *JobStateEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _JobService_GetMessageStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(JobMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetMessageStream(m, &jobServiceGetMessageStreamServer{stream})
}

type JobService_GetMessageStreamServer interface {
	Send(*JobMessagesResponse) error
	grpc.ServerStream
}

type jobServiceGetMessageStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetMessageStreamServer) Send(m *JobMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _JobService_GetJobMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJobMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetJobMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJobMetrics(ctx, req.(*GetJobMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DescribePipelineOptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribePipelineOptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DescribePipelineOptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/DescribePipelineOptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DescribePipelineOptions(ctx, req.(*DescribePipelineOptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Prepare",
			Handler:    _JobService_Prepare_Handler,
		},
		{
			MethodName: "Run",
			Handler:    _JobService_Run_Handler,
		},
		{
			MethodName: "GetJobs",
			Handler:    _JobService_GetJobs_Handler,
		},
		{
			MethodName: "GetState",
			Handler:    _JobService_GetState_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _JobService_GetPipeline_Handler,
		},
		{
			MethodName: "Cancel",
			Handler:    _JobService_Cancel_Handler,
		},
		{
			MethodName: "GetJobMetrics",
			Handler:    _JobService_GetJobMetrics_Handler,
		},
		{
			MethodName: "DescribePipelineOptions",
			Handler:    _JobService_DescribePipelineOptions_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetStateStream",
			Handler:       _JobService_GetStateStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetMessageStream",
			Handler:       _JobService_GetMessageStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_job_api.proto",
}
