/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescriptionWSDL;
import org.apache.axis2.jaxws.description.MethodRetriever;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.LegacyMethodRetrieverImpl;
import org.apache.axis2.jaxws.description.impl.OperationDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.PostRI216MethodRetrieverImpl;
import org.apache.axis2.jaxws.description.impl.ServiceDescriptionImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSToolingUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointInterfaceDescriptionImpl
implements EndpointInterfaceDescription,
EndpointInterfaceDescriptionJava,
EndpointInterfaceDescriptionWSDL {
    private final EndpointDescriptionImpl parentEndpointDescription;
    private final ArrayList<OperationDescription> operationDescriptions = new ArrayList();
    private Map<QName, List<OperationDescription>> dispatchableOperations;
    private final DescriptionBuilderComposite dbc;
    private static final Log log = LogFactory.getLog(EndpointInterfaceDescriptionImpl.class);
    private WebService webServiceAnnotation;
    private String webServiceTargetNamespace;
    private String webService_Name;
    private SOAPBinding soapBindingAnnotation;
    private SOAPBinding.Style soapBindingStyle;
    public static final SOAPBinding.Style SOAPBinding_Style_DEFAULT = SOAPBinding.Style.DOCUMENT;
    private SOAPBinding.Use soapBindingUse;
    public static final SOAPBinding.Use SOAPBinding_Use_DEFAULT = SOAPBinding.Use.LITERAL;
    private SOAPBinding.ParameterStyle soapParameterStyle;
    public static final SOAPBinding.ParameterStyle SOAPBinding_ParameterStyle_DEFAULT = SOAPBinding.ParameterStyle.WRAPPED;

    void addOperation(OperationDescription operation) {
        ServiceDescriptionImpl sd;
        if (log.isDebugEnabled()) {
            log.debug((Object)("start addOperation for " + String.valueOf(operation)));
        }
        this.operationDescriptions.add(operation);
        ServiceDescriptionImpl serviceDescriptionImpl = sd = this.getEndpointDescriptionImpl() == null ? null : this.getEndpointDescriptionImpl().getServiceDescriptionImpl();
        if (sd != null) {
            sd.runtimeDescMap.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end addOperation");
        }
    }

    EndpointInterfaceDescriptionImpl(Class sei, EndpointDescriptionImpl parent) {
        this.parentEndpointDescription = parent;
        this.dbc = new DescriptionBuilderComposite();
        this.dbc.setCorrespondingClass(sei);
        for (Method method : EndpointInterfaceDescriptionImpl.getSEIMethods(this.dbc.getCorrespondingClass())) {
            OperationDescriptionImpl operation = new OperationDescriptionImpl(method, (EndpointInterfaceDescription)this);
            this.addOperation(operation);
        }
    }

    EndpointInterfaceDescriptionImpl(EndpointDescriptionImpl parent) {
        this.parentEndpointDescription = parent;
        this.dbc = new DescriptionBuilderComposite();
        AxisService axisService = this.parentEndpointDescription.getAxisService();
        if (axisService != null) {
            ArrayList publishedOperations = axisService.getPublishedOperations();
            for (AxisOperation axisOperation : publishedOperations) {
                this.addOperation(new OperationDescriptionImpl(axisOperation, (EndpointInterfaceDescription)this));
            }
        }
    }

    EndpointInterfaceDescriptionImpl(DescriptionBuilderComposite dbc, EndpointDescriptionImpl parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a EndpointInterfaceDescription for a generic WSDL-less provider");
        }
        this.parentEndpointDescription = parent;
        this.dbc = dbc;
        AxisOperation genericProviderAxisOp = null;
        try {
            genericProviderAxisOp = AxisOperationFactory.getOperationDescription((String)"http://www.w3.org/ns/wsdl/in-out");
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("eiDescrImplErr"), e);
        }
        genericProviderAxisOp.setName(new QName("jaxwsNoWSDLProviderOperation"));
        OperationDescriptionImpl opDesc = new OperationDescriptionImpl(genericProviderAxisOp, (EndpointInterfaceDescription)this);
        this.addOperation(opDesc);
        AxisService axisService = this.getEndpointDescription().getAxisService();
        axisService.addOperation(genericProviderAxisOp);
    }

    EndpointInterfaceDescriptionImpl(DescriptionBuilderComposite dbc, boolean isClass, EndpointDescriptionImpl parent) {
        this.parentEndpointDescription = parent;
        this.dbc = dbc;
        this.getEndpointDescription().getAxisService().setTargetNamespace(this.getEndpointDescriptionImpl().getTargetNamespace());
        MethodRetriever methodRetriever = this.getMethodRetriever();
        Iterator<MethodDescriptionComposite> iter = methodRetriever.retrieveMethods();
        if (log.isDebugEnabled()) {
            log.debug((Object)"EndpointInterfaceDescriptionImpl: Finished retrieving methods");
        }
        MethodDescriptionComposite mdc = null;
        while (iter.hasNext()) {
            mdc = iter.next();
            mdc.setDeclaringClass(dbc.getClassName());
            if (!DescriptionUtils.createOperationDescription(mdc.getMethodName())) continue;
            AxisService axisService = this.getEndpointDescription().getAxisService();
            AxisOperation axisOperation = axisService.getOperation(OperationDescriptionImpl.determineOperationQName(this, mdc));
            OperationDescriptionImpl operation = new OperationDescriptionImpl(mdc, this, axisOperation);
            if (this.getWSDLDefinition() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"wsdl definition found, we will not expose operation not found in AxisService.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EID: Just added operation= " + operation.getOperationName()));
                }
                this.addOperation(operation);
                if (this.getEndpointDescriptionImpl().isWSDLFullySpecified()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Partial wsdl definition found, we will add operation to the AxisService.");
                }
                operation.addToAxisService(axisService);
                continue;
            }
            if (axisOperation == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"wsdl defintion NOT found, we will expose operation using annotations.");
                }
                operation.addToAxisService(axisService);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EID: Just added operation= " + operation.getOperationName()));
                }
                this.addOperation(operation);
                continue;
            }
            if (this.getWSDLDefinition() != null || axisOperation == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("EID: Just added operation= " + operation.getOperationName()));
            }
            this.addOperation(operation);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"EndpointInterfaceDescriptionImpl: Finished Adding operations");
        }
    }

    private static Method[] getSEIMethods(Class sei) {
        Method[] seiMethods = sei.getMethods();
        ArrayList<Method> methodList = new ArrayList<Method>();
        if (sei != null) {
            for (Method method : seiMethods) {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) continue;
                methodList.add(method);
                if (Modifier.isPublic(method.getModifiers())) continue;
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("seiMethodsErr"));
            }
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    void updateWithSEI(Class sei) {
        Class seiClass = this.dbc.getCorrespondingClass();
        if (seiClass != null && seiClass != sei) {
            throw ExceptionFactory.makeWebServiceException(new UnsupportedOperationException(Messages.getMessage("seiProcessingErr")));
        }
        if (seiClass != null && seiClass == sei) {
            return;
        }
        if (sei != null) {
            this.webServiceAnnotation = null;
            this.webServiceTargetNamespace = null;
            this.webService_Name = null;
            this.soapBindingAnnotation = null;
            this.soapBindingStyle = null;
            this.soapBindingUse = null;
            this.soapParameterStyle = null;
            this.dispatchableOperations = null;
            seiClass = sei;
            this.dbc.setCorrespondingClass(sei);
            for (Method seiMethod : EndpointInterfaceDescriptionImpl.getSEIMethods(seiClass)) {
                if (this.getOperation(seiMethod) != null) continue;
                QName seiOperationQName = OperationDescriptionImpl.determineOperationQName(seiMethod);
                OperationDescription[] updateOpDesc = this.getOperation(seiOperationQName);
                if (updateOpDesc == null || updateOpDesc.length == 0) {
                    OperationDescriptionImpl operation = new OperationDescriptionImpl(seiMethod, (EndpointInterfaceDescription)this);
                    this.addOperation(operation);
                    continue;
                }
                boolean addOpDesc = true;
                for (OperationDescription checkOpDesc : updateOpDesc) {
                    if (checkOpDesc.getSEIMethod() != null || DescriptionUtils.isAsync(seiMethod)) continue;
                    ((OperationDescriptionImpl)checkOpDesc).setSEIMethod(seiMethod);
                    addOpDesc = false;
                    break;
                }
                if (!addOpDesc) continue;
                OperationDescriptionImpl operation = new OperationDescriptionImpl(seiMethod, (EndpointInterfaceDescription)this);
                this.addOperation(operation);
            }
        }
    }

    @Override
    public OperationDescription[] getOperationForJavaMethod(String javaMethodName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting on javaMethodName : " + javaMethodName + " , on operationDescriptions.size: " + this.operationDescriptions.size()));
        }
        if (DescriptionUtils.isEmpty(javaMethodName)) {
            return null;
        }
        ArrayList<OperationDescription> matchingOperations = new ArrayList<OperationDescription>();
        for (OperationDescription operation : this.getOperations()) {
            if (javaMethodName.equals(operation.getJavaMethodName())) {
                matchingOperations.add(operation);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("getOperationForJavaMethod() found no match for javaMethodName: " + javaMethodName + "  on operation: " + operation.getJavaMethodName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOperationForJavaMethod() found match size: " + matchingOperations.size()));
        }
        if (matchingOperations.size() == 0) {
            return null;
        }
        return matchingOperations.toArray(new OperationDescription[0]);
    }

    @Override
    public OperationDescription getOperation(String operationName) {
        if (DescriptionUtils.isEmpty(operationName)) {
            return null;
        }
        OperationDescription matchingOperation = null;
        for (OperationDescription operation : this.getOperations()) {
            if (!operationName.equals(operation.getOperationName())) continue;
            matchingOperation = operation;
            break;
        }
        return matchingOperation;
    }

    @Override
    public OperationDescription[] getOperations() {
        return this.operationDescriptions.toArray(new OperationDescription[0]);
    }

    public EndpointDescriptionImpl getEndpointDescriptionImpl() {
        return this.parentEndpointDescription;
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.parentEndpointDescription;
    }

    @Override
    public OperationDescription[] getOperation(QName operationQName) {
        OperationDescription[] returnOperations = null;
        if (!DescriptionUtils.isEmpty(operationQName)) {
            OperationDescription[] allOperations;
            ArrayList<OperationDescription> matchingOperations = new ArrayList<OperationDescription>();
            for (OperationDescription operation : allOperations = this.getOperations()) {
                if (!operation.getName().getLocalPart().equals(operationQName.getLocalPart())) continue;
                matchingOperations.add(operation);
            }
            if (matchingOperations.size() > 0) {
                returnOperations = matchingOperations.toArray(new OperationDescription[0]);
            }
        }
        return returnOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationDescription[] getDispatchableOperation(QName operationQName) {
        EndpointInterfaceDescriptionImpl endpointInterfaceDescriptionImpl = this;
        synchronized (endpointInterfaceDescriptionImpl) {
            if (this.dispatchableOperations == null) {
                this.initializeDispatchableOperationsList();
            }
        }
        QName key = new QName("", operationQName.getLocalPart());
        List<OperationDescription> operations = this.dispatchableOperations.get(key);
        if (operations != null) {
            return operations.toArray(new OperationDescription[operations.size()]);
        }
        return new OperationDescription[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationDescription[] getDispatchableOperations() {
        OperationDescription[] returnOperations = null;
        EndpointInterfaceDescriptionImpl endpointInterfaceDescriptionImpl = this;
        synchronized (endpointInterfaceDescriptionImpl) {
            if (this.dispatchableOperations == null) {
                this.initializeDispatchableOperationsList();
            }
        }
        Collection<List<OperationDescription>> dispatchableValues = this.dispatchableOperations.values();
        Iterator<List<OperationDescription>> iteratorValues = dispatchableValues.iterator();
        ArrayList<OperationDescription> allDispatchableOperations = new ArrayList<OperationDescription>();
        while (iteratorValues.hasNext()) {
            List<OperationDescription> opDescList = iteratorValues.next();
            allDispatchableOperations.addAll(opDescList);
        }
        if (allDispatchableOperations.size() > 0) {
            returnOperations = allDispatchableOperations.toArray(new OperationDescription[allDispatchableOperations.size()]);
        }
        return returnOperations;
    }

    private void initializeDispatchableOperationsList() {
        OperationDescription[] opDescs;
        this.dispatchableOperations = new HashMap<QName, List<OperationDescription>>();
        for (OperationDescription opDesc : opDescs = this.getOperations()) {
            if (opDesc.isJAXWSAsyncClientMethod() || opDesc.isExcluded()) continue;
            List<OperationDescription> dispatchableOperationsWithName = this.dispatchableOperations.get(opDesc.getName());
            if (dispatchableOperationsWithName == null) {
                dispatchableOperationsWithName = new ArrayList<OperationDescription>();
                this.dispatchableOperations.put(opDesc.getName(), dispatchableOperationsWithName);
            }
            dispatchableOperationsWithName.add(opDesc);
        }
    }

    @Override
    public OperationDescription getOperation(Method seiMethod) {
        OperationDescription returnOperation = null;
        if (seiMethod != null) {
            OperationDescription[] allOperations;
            for (OperationDescription operation : allOperations = this.getOperations()) {
                if (operation.getSEIMethod() == null || !operation.getSEIMethod().equals(seiMethod)) continue;
                returnOperation = operation;
            }
        }
        return returnOperation;
    }

    @Override
    public Class getSEIClass() {
        return this.dbc.getCorrespondingClass();
    }

    @Override
    public SOAPBinding getAnnoSoapBinding() {
        if (this.soapBindingAnnotation == null) {
            this.soapBindingAnnotation = this.dbc.getSoapBindingAnnot();
        }
        return this.soapBindingAnnotation;
    }

    @Override
    public SOAPBinding.Style getSoapBindingStyle() {
        return this.getAnnoSoapBindingStyle();
    }

    @Override
    public SOAPBinding.Style getAnnoSoapBindingStyle() {
        if (this.soapBindingStyle == null) {
            this.soapBindingStyle = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().style() != null ? this.getAnnoSoapBinding().style() : SOAPBinding_Style_DEFAULT;
        }
        return this.soapBindingStyle;
    }

    @Override
    public SOAPBinding.Use getSoapBindingUse() {
        return this.getAnnoSoapBindingUse();
    }

    @Override
    public SOAPBinding.Use getAnnoSoapBindingUse() {
        if (this.soapBindingUse == null) {
            this.soapBindingUse = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().use() != null ? this.getAnnoSoapBinding().use() : SOAPBinding_Use_DEFAULT;
        }
        return this.soapBindingUse;
    }

    @Override
    public SOAPBinding.ParameterStyle getSoapBindingParameterStyle() {
        return this.getAnnoSoapBindingParameterStyle();
    }

    @Override
    public SOAPBinding.ParameterStyle getAnnoSoapBindingParameterStyle() {
        if (this.soapParameterStyle == null) {
            this.soapParameterStyle = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().parameterStyle() != null ? this.getAnnoSoapBinding().parameterStyle() : SOAPBinding_ParameterStyle_DEFAULT;
        }
        return this.soapParameterStyle;
    }

    private Definition getWSDLDefinition() {
        return ((ServiceDescriptionWSDL)((Object)this.getEndpointDescription().getServiceDescription())).getWSDLDefinition();
    }

    @Override
    public PortType getWSDLPortType() {
        PortType portType = null;
        Definition wsdlDefn = this.getWSDLDefinition();
        if (wsdlDefn != null) {
            String tns = this.getEndpointDescription().getTargetNamespace();
            String localPart = this.getEndpointDescription().getName();
            if (localPart != null) {
                portType = wsdlDefn.getPortType(new QName(tns, localPart));
            }
        }
        return portType;
    }

    @Override
    public String getTargetNamespace() {
        return this.getAnnoWebServiceTargetNamespace();
    }

    @Override
    public WebService getAnnoWebService() {
        if (this.webServiceAnnotation == null) {
            this.webServiceAnnotation = this.dbc.getWebServiceAnnot();
        }
        return this.webServiceAnnotation;
    }

    @Override
    public String getAnnoWebServiceTargetNamespace() {
        if (this.webServiceTargetNamespace == null) {
            this.webServiceTargetNamespace = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().targetNamespace()) ? this.getAnnoWebService().targetNamespace() : DescriptionUtils.makeNamespaceFromPackageName(DescriptionUtils.getJavaPackageName(this.dbc.getClassName()), "http");
        }
        return this.webServiceTargetNamespace;
    }

    public String getAnnoWebServiceName() {
        if (this.webService_Name == null) {
            this.webService_Name = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().name()) ? this.getAnnoWebService().name() : DescriptionUtils.getSimpleJavaClassName(this.dbc.getClassName());
        }
        return this.webService_Name;
    }

    public String getName() {
        return this.getAnnoWebServiceName();
    }

    @Override
    public QName getPortType() {
        String name = this.getName();
        String tns = this.getTargetNamespace();
        return new QName(tns, name);
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("Name: " + this.getName());
            string.append("; ");
            string.append("PortType: " + String.valueOf(this.getPortType()));
            string.append("\n");
            string.append("SOAP Style: " + String.valueOf(this.getSoapBindingStyle()));
            string.append("; ");
            string.append("SOAP Use: " + String.valueOf(this.getSoapBindingUse()));
            string.append("; ");
            string.append("SOAP Paramater Style: " + String.valueOf(this.getSoapBindingParameterStyle()));
            string.append("\n");
            OperationDescription[] operations = this.getOperations();
            if (operations != null && operations.length > 0) {
                string.append("Number of operations: " + operations.length);
                for (OperationDescription operation : operations) {
                    string.append("\n");
                    string.append("Operation: " + operation.toString());
                }
            } else {
                string.append("OperationDescription array is null");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for EndpointInterfaceDescription");
            return string.toString();
        }
        return string.toString();
    }

    private MethodRetriever getMethodRetriever() {
        MethodRetriever methodRetriever = null;
        boolean newSunBehavior = false;
        String legacyWebmethod = null;
        String postWebMethodRules = this.readUsePostWebMethodRulesFlag();
        if (WSToolingUtils.hasValue(postWebMethodRules) && postWebMethodRules.equalsIgnoreCase("true")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"EndpointInterfaceDescriptionImpl: System property jaxws.runtime.usePostWebMethodRules  set to true, all other configurations are ignored");
            }
            newSunBehavior = true;
        } else {
            newSunBehavior = this.isNewSunBehaviorSupported();
            legacyWebmethod = this.readLegacyWebMethodFlag();
            if (WSToolingUtils.hasValue(legacyWebmethod) && legacyWebmethod.equalsIgnoreCase("true")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"EndpointInterfaceDescriptionImpl: System or Manifest property jaxws.runtime.legacyWebMethod set to true");
                }
                newSunBehavior = false;
            } else {
                String newSunRulesFlag = EndpointInterfaceDescriptionImpl.getNewSunRulesFlag();
                if (WSToolingUtils.hasValue(newSunRulesFlag) && newSunRulesFlag.equalsIgnoreCase("true")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"EndpointInterfaceDescriptionImpl: System property com.sun.xml.ws.model.RuntimeModeler.legacyWebMethod set to true");
                    }
                    newSunBehavior = false;
                }
            }
        }
        methodRetriever = newSunBehavior ? new PostRI216MethodRetrieverImpl(this.dbc, this) : new LegacyMethodRetrieverImpl(this.dbc, this);
        methodRetriever.setLegacyWebMethod(legacyWebmethod);
        if (log.isDebugEnabled()) {
            if (newSunBehavior) {
                log.debug((Object)"getMethodRetriever: returning a PostRI216MethodRetrieverImpl");
            } else {
                log.debug((Object)"getMethodRetriever: returning a LegacyMethodRetrieverImpl");
            }
        }
        return methodRetriever;
    }

    private boolean isNewSunBehaviorSupported() {
        boolean versionValid;
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"isNewSunBehavior: Validating that JDK version can be used");
            }
            versionValid = false;
            try {
                String wsGenVersion = WSToolingUtils.getWsGenVersion();
                versionValid = WSToolingUtils.isValidVersion(wsGenVersion);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("isNewSunBehavior: versionValid is: " + versionValid));
                }
                if (!versionValid && log.isDebugEnabled()) {
                    log.debug((Object)"New Sun tooling behavior is not supported with this version of the JDK");
                }
            }
            catch (ClassNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Unable to determine WsGen version being used");
                }
            }
            catch (IOException ioex) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)" Unable to determine WsGen version being used");
            }
        }
        return versionValid;
    }

    private String readLegacyWebMethodFlag() {
        String legacyWebmethod;
        block14: {
            legacyWebmethod = null;
            try {
                legacyWebmethod = EndpointInterfaceDescriptionImpl.getSystemProperty("jaxws.runtime.legacyWebMethod");
            }
            catch (PrivilegedActionException e) {
                if (!log.isWarnEnabled()) break block14;
                log.debug((Object)("Exception getting USE_LEGACY_WEB_METHOD_RULES system property: " + String.valueOf(e.getException())));
            }
        }
        if (!WSToolingUtils.hasValue(legacyWebmethod)) {
            ConfigurationContext configContext;
            if (log.isDebugEnabled()) {
                log.debug((Object)"EndpointInterfaceDescriptionImpl: system property 'jaxws.runtime.legacyWebMethod' not set");
            }
            if ((configContext = this.getEndpointDescription().getServiceDescription().getAxisConfigContext()) != null) {
                String param;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"EndpointInterfaceDescriptionImpl: Reading Manifest property 'LegacyWebMethod'");
                }
                if ((param = (String)configContext.getProperty("LegacyWebMethod")) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"EndpointInterfaceDescriptionImpl: Manifest property 'LegacyWebMethod' not set");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("EndpointInterfaceDescriptionImpl: Manifest property 'LegacyWebMethod' is set to" + param));
                    }
                    legacyWebmethod = param;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"EndpointInterfaceDescriptionImpl: Unable to Read Manifest property 'LegacyWebMethod'");
                log.debug((Object)"EndpointInterfaceDescriptionImpl: AxisConfigContext was null");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"EndpointInterfaceDescriptionImpl: system property 'jaxws.runtime.legacyWebMethod' set");
        }
        return legacyWebmethod;
    }

    private static String getNewSunRulesFlag() {
        String newSunRulesFlag;
        block6: {
            newSunRulesFlag = null;
            try {
                newSunRulesFlag = EndpointInterfaceDescriptionImpl.getSystemProperty("com.sun.xml.ws.model.RuntimeModeler.legacyWebMethod");
            }
            catch (PrivilegedActionException e) {
                if (!log.isWarnEnabled()) break block6;
                log.debug((Object)("Exception getting USE_LEGACY_WEB_METHOD_RULES_SUN system property: " + String.valueOf(e.getException())));
            }
        }
        if (WSToolingUtils.hasValue(newSunRulesFlag)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"EndpointInterfaceDescriptionImpl: system property 'com.sun.xml.ws.model.RuntimeModeler.legacyWebMethod' is set");
                log.debug((Object)("MDQConstants.USE_LEGACY_WEB_METHOD_RULES_SUN =" + newSunRulesFlag));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"EndpointInterfaceDescriptionImpl: system property 'com.sun.xml.ws.model.RuntimeModeler.legacyWebMethod' is not set");
        }
        return newSunRulesFlag;
    }

    private String readUsePostWebMethodRulesFlag() {
        String usePostMethodRules;
        block6: {
            usePostMethodRules = null;
            try {
                usePostMethodRules = EndpointInterfaceDescriptionImpl.getSystemProperty("jaxws.runtime.usePostWebMethodRules");
            }
            catch (PrivilegedActionException e) {
                if (!log.isWarnEnabled()) break block6;
                log.debug((Object)("Exception getting USE_POST_WEB_METHOD_RULES system property: " + String.valueOf(e.getException())));
            }
        }
        if (WSToolingUtils.hasValue(usePostMethodRules)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("EndpointInterfaceDescriptionImpl: system property 'jaxws.runtime.usePostWebMethodRules' is set with " + usePostMethodRules));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"EndpointInterfaceDescriptionImpl: system property 'jaxws.runtime.usePostWebMethodRules' is not set");
        }
        return usePostMethodRules;
    }

    private static String getSystemProperty(final String propertyName) throws PrivilegedActionException {
        return (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }
}

